/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.bridge.impl;

import com.google.common.base.Preconditions;
import io.github.axolotlclient.bridge.events.Events;
import io.github.axolotlclient.bridge.impl.commands.CommandsImpl;
import io.github.axolotlclient.bridge.item.AxoItemStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.unmapped.C_1241852;
import net.minecraft.unmapped.C_2454309;
import net.minecraft.unmapped.C_3628668;
import net.minecraft.unmapped.C_3755722;
import net.minecraft.unmapped.C_7778778;
import net.ornithemc.osl.keybinds.api.KeyBindingEvents;
import net.ornithemc.osl.keybinds.api.KeyBindingRegistry;
import net.ornithemc.osl.lifecycle.api.client.MinecraftClientEvents;
import net.ornithemc.osl.networking.api.client.ClientConnectionEvents;
import net.ornithemc.osl.resource.loader.api.ResourceLoaderEvents;
import org.jetbrains.annotations.Nullable;

public class Bridge {
    @Nullable
    private static List<C_7778778> keyBindings = new ArrayList<C_7778778>();

    public static AxoItemStack wrapStack(@Nullable C_2454309 stack) {
        return (AxoItemStack)Objects.requireNonNullElseGet(stack, () -> new C_2454309(C_3755722.m_0135857((C_1241852)C_3628668.f_1888477), 0));
    }

    @Nullable
    public static C_2454309 unwrapStack(AxoItemStack stack) {
        if (stack.br$isEmpty()) {
            return null;
        }
        Preconditions.checkArgument((boolean)(stack instanceof C_2454309), (Object)"stack instanceof ItemStack");
        return (C_2454309)stack;
    }

    public static void addKeybind(C_7778778 keyBinding) {
        Preconditions.checkState((keyBindings != null ? 1 : 0) != 0, (Object)"keybind registered too late!");
        keyBindings.add(keyBinding);
    }

    public static void init() {
        KeyBindingEvents.REGISTER_KEYBINDS.register(keyBindingRegistry -> {
            Preconditions.checkState((keyBindings != null ? 1 : 0) != 0, (Object)"double keybind register");
            keyBindings.forEach(arg_0 -> ((KeyBindingRegistry)keyBindingRegistry).register(arg_0));
            keyBindings = null;
        });
        MinecraftClientEvents.START.register(minecraft -> ((Runnable)Events.CLIENT_START.invoker()).run());
        MinecraftClientEvents.READY.register(minecraft -> ((Runnable)Events.CLIENT_READY.invoker()).run());
        MinecraftClientEvents.STOP.register(minecraft -> ((Runnable)Events.CLIENT_STOP.invoker()).run());
        MinecraftClientEvents.TICK_END.register(minecraft -> ((Runnable)Events.TICK.invoker()).run());
        ResourceLoaderEvents.END_RESOURCE_RELOAD.register(() -> ((Runnable)Events.END_RESOURCE_RELOAD.invoker()).run());
        ClientConnectionEvents.PLAY_READY.register(mc -> ((Consumer)Events.CONNECTION_PLAY_READY.invoker()).accept(mc.m_1862495()));
        ClientConnectionEvents.DISCONNECT.register(mc -> ((Runnable)Events.DISCONNECT.invoker()).run());
    }

    public static void postInit() {
        ((Consumer)Events.COMMAND_REGISTER.invoker()).accept(CommandsImpl.getInstance());
    }
}

