/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.bridge.impl.commands;

import com.google.common.base.Preconditions;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.axolotlclient.bridge.commands.AxoClientCmdSrcStack;
import io.github.axolotlclient.bridge.commands.Commands;
import io.github.axolotlclient.bridge.util.AxoText;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import net.minecraft.unmapped.C_1160932;
import net.minecraft.unmapped.C_1716360;
import net.minecraft.unmapped.C_1730529;
import net.minecraft.unmapped.C_8105098;
import net.minecraft.unmapped.C_9550253;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CommandsImpl
implements Commands {
    private static final CommandsImpl instance = new CommandsImpl();
    private final CommandDispatcher<AxoClientCmdSrcStack> dispatcher = new CommandDispatcher();
    private final Logger logger = LogManager.getLogger((String)"ClientCommandHandler");

    private static boolean isIgnoredException(CommandExceptionType type) {
        return type == CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand() || type == CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherParseException();
    }

    private static C_9550253 getErrorMessage(CommandSyntaxException e) {
        String context = e.getContext();
        return context != null ? new C_1160932("lcu.command.parse_error", new Object[]{e.getMessage(), e.getCursor(), context}) : new C_1716360(e.getMessage());
    }

    private static SourceStack buildClientSource(C_8105098 client) {
        Preconditions.checkState((client.f_7663840 != null ? 1 : 0) != 0);
        return new SourceStack((C_1730529)client.f_7663840);
    }

    public boolean dispatchClient(String command) {
        if (!command.startsWith("/")) {
            return false;
        }
        C_8105098 client = C_8105098.m_0408063();
        SourceStack source = CommandsImpl.buildClientSource(client);
        command = command.trim().substring(1);
        try {
            this.dispatcher.execute(command, (Object)source);
            return true;
        }
        catch (CommandSyntaxException e) {
            if (CommandsImpl.isIgnoredException(e.getType())) {
                return false;
            }
            this.logger.warn("Syntax exception for command '{}'", (Object)command, (Object)e);
            source.origin().m_3031403(CommandsImpl.getErrorMessage(e));
            return true;
        }
        catch (Exception e) {
            this.logger.warn("Error while executing command '{}'", (Object)command, (Object)e);
            source.origin().m_3031403((C_9550253)new C_1716360(e.getMessage() == null ? "" : e.getMessage()));
            return true;
        }
    }

    public CompletableFuture<List<String>> getCompletionsClient(String command) {
        C_8105098 client = C_8105098.m_0408063();
        String command0 = command.startsWith("/") ? command.substring(1) : command;
        return this.dispatcher.getCompletionSuggestions(this.dispatcher.parse(command0, (Object)CommandsImpl.buildClientSource(client))).thenApply(suggestions -> suggestions.getList().stream().map(x -> command0.contains(" ") ? x.getText() : "/" + x.getText()).toList());
    }

    @Generated
    public static CommandsImpl getInstance() {
        return instance;
    }

    @Generated
    public CommandDispatcher<AxoClientCmdSrcStack> getDispatcher() {
        return this.dispatcher;
    }

    public record SourceStack(C_1730529 origin) implements AxoClientCmdSrcStack
    {
        public void br$sendError(AxoText text) {
            this.origin.m_3031403((C_9550253)text);
        }

        public void br$sendFeedback(AxoText text) {
            this.origin.m_3031403((C_9550253)text);
        }
    }
}

