/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.bridge.mixin;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ListenableFuture;
import io.github.axolotlclient.bridge.AxoGameOptions;
import io.github.axolotlclient.bridge.AxoMinecraftClient;
import io.github.axolotlclient.bridge.AxoPlayerListEntry;
import io.github.axolotlclient.bridge.AxoSession;
import io.github.axolotlclient.bridge.entity.AxoEntity;
import io.github.axolotlclient.bridge.entity.AxoPlayer;
import io.github.axolotlclient.bridge.render.AxoFont;
import io.github.axolotlclient.bridge.resource.AxoResourceManager;
import io.github.axolotlclient.bridge.util.AxoText;
import io.github.axolotlclient.bridge.world.AxoWorld;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.unmapped.C_0539808;
import net.minecraft.unmapped.C_0814381;
import net.minecraft.unmapped.C_1023567;
import net.minecraft.unmapped.C_1331819;
import net.minecraft.unmapped.C_1533205;
import net.minecraft.unmapped.C_3020744;
import net.minecraft.unmapped.C_3526030;
import net.minecraft.unmapped.C_3831727;
import net.minecraft.unmapped.C_3945557;
import net.minecraft.unmapped.C_4143404;
import net.minecraft.unmapped.C_6577431;
import net.minecraft.unmapped.C_7873567;
import net.minecraft.unmapped.C_8105098;
import net.minecraft.unmapped.C_8398976;
import net.minecraft.unmapped.C_8651652;
import net.minecraft.unmapped.C_8730536;
import net.minecraft.unmapped.C_9550253;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={C_8105098.class})
public abstract class MinecraftClientMixin
implements AxoMinecraftClient {
    @Shadow
    public C_3831727 f_0426313;
    @Shadow
    public C_1023567 f_7663840;
    @Shadow
    public C_7873567 f_4601986;
    @Shadow
    public C_1331819 f_9967940;
    @Shadow
    @Final
    private C_8730536 f_2424468;
    @Shadow
    public C_8651652 f_3501374;
    @Shadow
    public C_3020744 f_0723335;
    @Shadow
    public C_8398976 f_4021716;
    @Shadow
    private C_0539808 f_2096674;
    @Shadow
    private String f_6808466;

    @Shadow
    public abstract boolean m_9805322();

    @Shadow
    public abstract C_1533205 m_1862495();

    @Shadow
    public abstract C_6577431 m_3739907();

    @Shadow
    public abstract ListenableFuture<Object> m_2167033(Runnable var1);

    @Nullable
    public AxoPlayer br$getPlayer() {
        return this.f_7663840;
    }

    public AxoWorld br$getWorld() {
        return this.f_4601986;
    }

    public AxoFont br$getFont() {
        return this.f_0426313;
    }

    public AxoGameOptions br$getGameOptions() {
        return this.f_9967940;
    }

    public AxoSession br$getSession() {
        return new AxoSession(this.f_2424468.m_4631150(), this.f_2424468.m_2698451(), this.f_2424468.m_1063667());
    }

    public boolean br$isLocalServer() {
        return this.m_9805322();
    }

    public String br$getServerAddress() {
        return Optional.ofNullable(this.m_1862495()).map(x -> x.f_7619058).orElse(this.f_6808466);
    }

    public String br$getServerName() {
        return Optional.ofNullable(this.m_1862495()).map(x -> x.f_4296074).orElse(null);
    }

    public Collection<? extends AxoPlayerListEntry> br$getOnlinePlayers() {
        return this.f_7663840 == null ? List.of() : Collections.unmodifiableCollection(this.f_7663840.f_6362094.m_9082306());
    }

    public void br$sendToClient(AxoText msg) {
        this.f_3501374.m_8449802().m_7344462((C_9550253)msg);
    }

    public void br$sendToServer(String msg) {
        this.f_7663840.m_2226526(msg);
    }

    public void br$reinitScreen() {
        if (this.f_0723335 != null) {
            this.f_0723335.m_0116202((C_8105098)this, this.f_0723335.f_5465691, this.f_0723335.f_3080061);
        }
    }

    public AxoResourceManager br$getResourceManager() {
        return this.m_3739907();
    }

    public void execute(@NotNull Runnable command) {
        this.m_2167033(command);
    }

    public Object br$getScreen() {
        return this.f_0723335;
    }

    public void br$notifyLevelRenderer() {
        this.f_4021716.m_6441091();
    }

    public AxoEntity br$getCameraEntity() {
        return this.f_2096674;
    }

    public List<String> br$getSidebar() {
        ArrayList<String> lines = new ArrayList<String>();
        C_8105098 client = C_8105098.m_0408063();
        if (client.f_4601986 == null) {
            return lines;
        }
        C_0814381 scoreboard = client.f_4601986.m_5847414();
        if (scoreboard == null) {
            return lines;
        }
        C_3945557 sidebar = scoreboard.m_8757270(1);
        if (sidebar == null) {
            return lines;
        }
        ArrayList scores = scoreboard.m_0477108(sidebar);
        ArrayList list = scores.stream().filter(input -> input != null && input.m_2012228() != null && !input.m_2012228().startsWith("#")).collect(Collectors.toList());
        scores = list.size() > 15 ? Lists.newArrayList((Iterable)Iterables.skip(list, (int)(scores.size() - 15))) : list;
        for (C_3526030 score : scores) {
            C_4143404 team = scoreboard.m_2322207(score.m_2012228());
            if (team == null) {
                return lines;
            }
            String text = team.m_1445072() + team.m_6964130();
            if (text.trim().isEmpty()) continue;
            lines.add(text);
        }
        lines.add(sidebar.m_0646168());
        Collections.reverse(lines);
        return lines;
    }
}

