/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.config.screen;

import io.github.axolotlclient.AxolotlClientConfig.impl.ui.ButtonWidget;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.Element;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.Screen;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.TextFieldWidget;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.vanilla.ElementListWidget;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.vanilla.EntryListWidget;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.vanilla.widgets.VanillaButtonWidget;
import io.github.axolotlclient.config.profiles.Profiles;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.unmapped.C_3020744;
import net.minecraft.unmapped.C_3390001;
import net.minecraft.unmapped.C_8105098;

public class ProfilesScreen
extends Screen {
    private final C_3020744 parent;

    public ProfilesScreen(C_3020744 parent) {
        super(C_3390001.m_2053009((String)"profiles.configure.list", (Object[])new Object[0]));
        this.parent = parent;
    }

    public void m_7261014(int mouseX, int mouseY, float delta) {
        super.m_7261014(mouseX, mouseY, delta);
        this.m_2717572(this.f_2020658, this.getTitle(), this.f_5465691 / 2, 16 - this.f_2020658.f_6725889 / 2, -1);
    }

    public void m_3593494() {
        this.addDrawableChild((Element)new ProfilesList(this.f_7153641, this.f_5465691, this.f_3080061, 33, this.f_3080061 - 33, 25));
        this.addDrawableChild((Element)new VanillaButtonWidget(this.f_5465691 / 2 - 75, this.f_3080061 - 16 - 10, 150, 20, C_3390001.m_2053009((String)"gui.back", (Object[])new Object[0]), btn -> this.closeScreen()));
    }

    public void closeScreen() {
        Profiles.getInstance().saveProfiles();
        this.f_7153641.m_6408915(this.parent);
    }

    public class ProfilesList
    extends ElementListWidget<Entry> {
        private static final Entry SPACER = new SpacerEntry();
        private final Entry ADD;

        public ProfilesList(C_8105098 minecraft, int width, int height, int top, int bottom, int itemHeight) {
            super(minecraft, width, height, top, bottom, itemHeight);
            this.ADD = new NewEntry();
            this.reload();
        }

        public void reload() {
            this.clearEntries();
            Profiles.getInstance().iterateAvailable(p -> this.addEntry((EntryListWidget.Entry)new ProfileEntry((Profiles.Profile)p)));
            this.addEntry((EntryListWidget.Entry)SPACER);
            this.addEntry((EntryListWidget.Entry)this.ADD);
        }

        protected int getScrollbarPositionX() {
            return this.getRowLeft() + this.getRowWidth() + 10;
        }

        public int getRowWidth() {
            return 340;
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            this.children().stream().filter(e -> e instanceof ProfileEntry).map(e -> (ProfileEntry)((Object)e)).map(e -> e.profileName).forEach(e -> e.setFocused(false));
            return super.mouseClicked(mouseX, mouseY, button);
        }

        public class NewEntry
        extends Entry {
            private final ButtonWidget addButton = new VanillaButtonWidget(0, 0, 150, 20, C_3390001.m_2053009((String)"profiles.profile.add", (Object[])new Object[0]), button -> {
                int i = ProfilesList.this.children().indexOf((Object)this);
                ProfilesList.this.children().add(Math.max(i - 1, 0), new ProfileEntry(Profiles.getInstance().newProfile(C_3390001.m_2053009((String)"profiles.profile.default_new_name", (Object[])new Object[0]))));
                Profiles.getInstance().saveProfiles();
                ProfilesList.this.setScrollAmount(ProfilesList.this.getMaxScroll());
            });
            private final ButtonWidget importButton = new VanillaButtonWidget(0, 0, 150, 20, C_3390001.m_2053009((String)"profiles.profile.import", (Object[])new Object[0]), btn -> {
                btn.active = false;
                Profiles.getInstance().importProfiles().thenRun(() -> {
                    btn.active = true;
                    ProfilesList.this.reload();
                });
            });

            public void render(int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
                int i = ProfilesList.this.getScrollbarPositionX() - width / 2 - 10 - this.addButton.getWidth() + 2;
                int j = top - 2;
                this.addButton.setPosition(i, j);
                this.addButton.render(mouseX, mouseY, partialTick);
                this.importButton.setPosition(this.addButton.getX() + this.addButton.getWidth() + 2, j);
                this.importButton.render(mouseX, mouseY, partialTick);
            }

            public List<? extends Element> children() {
                return List.of(this.addButton, this.importButton);
            }
        }

        @Environment(value=EnvType.CLIENT)
        public static abstract class Entry
        extends ElementListWidget.Entry<Entry> {
        }

        @Environment(value=EnvType.CLIENT)
        public class ProfileEntry
        extends Entry {
            private static final String EXPORT_BUTTON_TITLE = C_3390001.m_2053009((String)"profiles.profile.export", (Object[])new Object[0]);
            private static final String CURRENT_TEXT = C_3390001.m_2053009((String)"profiles.profile.current", (Object[])new Object[0]);
            private static final String LOAD_BUTTON_TITLE = C_3390001.m_2053009((String)"profiles.profile.load", (Object[])new Object[0]);
            private static final String DUPLICATE_BUTTON_TITLE = C_3390001.m_2053009((String)"profiles.profile.duplicate", (Object[])new Object[0]);
            private static final String REMOVE_BUTTON_TITLE = C_3390001.m_2053009((String)"profiles.profile.remove", (Object[])new Object[0]);
            private final TextFieldWidget profileName;
            private final ButtonWidget exportButton;
            private final ButtonWidget loadButton;
            private final ButtonWidget duplicateButton;
            private final ButtonWidget removeButton;
            private final Profiles.Profile profile;

            ProfileEntry(Profiles.Profile profile) {
                this.profile = profile;
                this.profileName = new TextFieldWidget(ProfilesScreen.this.f_2020658, 0, 0, 150, 20, "");
                this.profileName.setText(profile.name());
                this.profileName.setChangedListener(arg_0 -> ((Profiles.Profile)profile).setName(arg_0));
                this.exportButton = new VanillaButtonWidget(0, 0, 50, 20, EXPORT_BUTTON_TITLE, btn -> {
                    btn.active = false;
                    Profiles.getInstance().exportProfile(profile).thenRun(() -> {
                        btn.active = true;
                    });
                });
                this.loadButton = new VanillaButtonWidget(0, 0, 50, 20, LOAD_BUTTON_TITLE, btn -> Profiles.getInstance().switchTo(profile));
                this.duplicateButton = new VanillaButtonWidget(0, 0, 50, 20, DUPLICATE_BUTTON_TITLE, b -> {
                    Profiles.Profile dup = Profiles.getInstance().duplicate(profile);
                    double d = (double)ProfilesList.this.getMaxScroll() - ProfilesList.this.getScrollAmount();
                    ProfilesList.this.children().add(ProfilesList.this.children().indexOf((Object)this) + 1, new ProfileEntry(dup));
                    ProfilesList.this.setScrollAmount((double)ProfilesList.this.getMaxScroll() - d);
                });
                this.removeButton = new VanillaButtonWidget(0, 0, 50, 20, REMOVE_BUTTON_TITLE, b -> {
                    ProfilesList.this.removeEntry((EntryListWidget.Entry)this);
                    Profiles.getInstance().remove(profile);
                    ProfilesList.this.setScrollAmount(ProfilesList.this.getScrollAmount());
                });
            }

            public void render(int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
                int i = ProfilesList.this.getScrollbarPositionX() - this.removeButton.getWidth() - 4;
                int j = top - 2;
                this.removeButton.setPosition(i, j);
                this.removeButton.render(mouseX, mouseY, partialTick);
                this.duplicateButton.setPosition(i -= this.duplicateButton.getWidth(), j);
                this.duplicateButton.render(mouseX, mouseY, partialTick);
                boolean current = Profiles.getInstance().getCurrent() == this.profile;
                this.loadButton.setMessage(current ? CURRENT_TEXT : LOAD_BUTTON_TITLE);
                this.removeButton.active = !current;
                this.loadButton.active = this.removeButton.active;
                this.loadButton.setPosition(i -= this.loadButton.getWidth(), j);
                this.loadButton.render(mouseX, mouseY, partialTick);
                this.exportButton.setPosition(i -= this.exportButton.getWidth(), j);
                this.exportButton.render(mouseX, mouseY, partialTick);
                this.profileName.setWidth(i - left - 4);
                this.profileName.setPosition(left, j);
                this.profileName.render(mouseX, mouseY, partialTick);
            }

            public List<? extends Element> children() {
                return List.of(this.profileName, this.exportButton, this.loadButton, this.duplicateButton, this.removeButton);
            }
        }

        public static class SpacerEntry
        extends Entry {
            public void render(int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            }

            public List<? extends Element> children() {
                return List.of();
            }
        }
    }
}

