/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.auth;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.AxolotlClientConfig.api.options.Option;
import io.github.axolotlclient.AxolotlClientConfig.api.options.OptionCategory;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.BooleanOption;
import io.github.axolotlclient.api.API;
import io.github.axolotlclient.api.types.User;
import io.github.axolotlclient.api.util.UUIDHelper;
import io.github.axolotlclient.mixin.MinecraftClientAccessor;
import io.github.axolotlclient.modules.Module;
import io.github.axolotlclient.modules.auth.Account;
import io.github.axolotlclient.modules.auth.Accounts;
import io.github.axolotlclient.modules.auth.AccountsScreen;
import io.github.axolotlclient.modules.auth.DeviceCodeDisplayScreen;
import io.github.axolotlclient.modules.auth.DeviceFlowData;
import io.github.axolotlclient.modules.auth.MSApi;
import io.github.axolotlclient.modules.auth.skin.SkinManager;
import io.github.axolotlclient.util.ThreadExecuter;
import io.github.axolotlclient.util.notifications.Notifications;
import io.github.axolotlclient.util.options.GenericOption;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import net.minecraft.unmapped.C_0561170;
import net.minecraft.unmapped.C_1441789;
import net.minecraft.unmapped.C_3020744;
import net.minecraft.unmapped.C_3390001;
import net.minecraft.unmapped.C_5946149;
import net.minecraft.unmapped.C_8105098;
import net.minecraft.unmapped.C_8730536;

public class Auth
extends Accounts
implements Module {
    private static final Auth Instance = new Auth();
    public final BooleanOption showButton = new BooleanOption("auth.showButton", Boolean.valueOf(false));
    public final BooleanOption skinManagerAnimations = new BooleanOption("skins.manage.animations", Boolean.valueOf(true));
    private final C_8105098 client = C_8105098.m_0408063();
    private final GenericOption viewAccounts = new GenericOption("viewAccounts", "clickToOpen", () -> this.client.m_6408915((C_3020744)new AccountsScreen(this.client.f_0723335)));
    private final Map<String, C_0561170> textures = new HashMap<String, C_0561170>();
    private final Set<String> loadingTexture = new HashSet<String>();
    private final Map<String, GameProfile> profileCache = new WeakHashMap<String, GameProfile>();
    private final SkinManager skinManager = new SkinManager();

    public void init() {
        this.load();
        this.msApi = new MSApi((Accounts)this, () -> this.client.f_9967940.f_4977087);
        if (this.isContained(this.client.m_3271200().m_2698451())) {
            this.current = this.getAccounts().stream().filter(account -> account.getUuid().equals(this.client.m_3271200().m_2698451())).toList().get(0);
            this.current.setAuthToken(this.client.m_3271200().m_1063667());
            this.current.setName(this.client.m_3271200().m_4631150());
        } else {
            this.current = new Account(this.client.m_3271200().m_4631150(), this.client.m_3271200().m_2698451(), this.client.m_3271200().m_1063667());
        }
        this.category.add(new Option[]{this.showButton, this.viewAccounts});
        AxolotlClient.config().general.add(new OptionCategory[]{this.category});
    }

    protected void login(Account account) {
        if (this.client.f_4601986 != null) {
            return;
        }
        if (account.needsRefresh() && !account.isOffline()) {
            if (account.isExpired()) {
                Notifications.getInstance().addStatus("auth.notif.title", "auth.notif.refreshing", account.getName());
            }
            ((CompletableFuture)account.refresh(this.msApi).thenAccept(a -> {
                if (!a.isExpired()) {
                    this.login((Account)a);
                }
            })).thenRun(() -> ((Auth)this).save());
        } else {
            try {
                API.getInstance().shutdown();
                ((MinecraftClientAccessor)this.client).setSession(new C_8730536(account.getName(), account.getUuid(), account.getAuthToken(), C_8730536.C_5889190.f_7683414.name()));
                this.client.m_4708991().clear();
                this.client.m_4708991();
                this.save();
                this.current = account;
                Notifications.getInstance().addStatus("auth.notif.title", "auth.notif.login.successful", this.current.getName());
                AxolotlClient.LOGGER.info("Successfully logged in as " + this.current.getName(), new Object[0]);
                API.getInstance().startup(account);
            }
            catch (Exception e) {
                AxolotlClient.LOGGER.error("Failed to log in! ", new Object[]{e});
                Notifications.getInstance().addStatus("auth.notif.title", "auth.notif.login.failed", new Object[0]);
            }
        }
    }

    public void loadTextures(String uuid, String name) {
        if (!this.textures.containsKey(uuid) && !this.loadingTexture.contains(uuid)) {
            ThreadExecuter.scheduleTask(() -> {
                GameProfile gameProfile;
                this.loadingTexture.add(uuid);
                if (this.profileCache.containsKey(uuid)) {
                    gameProfile = this.profileCache.get(uuid);
                } else {
                    try {
                        UUID uUID = UUIDHelper.fromUndashed((String)uuid);
                        gameProfile = new GameProfile(uUID, name);
                        this.client.m_7883741().fillProfileProperties(gameProfile, false);
                    }
                    catch (IllegalArgumentException var2) {
                        gameProfile = new GameProfile(null, name);
                    }
                    this.profileCache.put(uuid, gameProfile);
                }
                this.client.m_4177774().m_8307311(gameProfile, (type, identifier, minecraftProfileTexture) -> {
                    if (type == MinecraftProfileTexture.Type.SKIN) {
                        this.textures.put(uuid, identifier);
                        this.loadingTexture.remove(uuid);
                    }
                }, false);
            });
        }
    }

    CompletableFuture<Account> showAccountsExpiredScreen(Account account) {
        C_3020744 current = this.client.f_0723335;
        CompletableFuture<Account> fut = new CompletableFuture<Account>();
        this.client.m_2167033(() -> this.client.m_6408915((C_3020744)new C_1441789((bl, i) -> {
            if (bl) {
                this.msApi.startDeviceAuth().thenRun(() -> fut.complete(account));
            } else {
                fut.cancel(true);
            }
            this.client.m_6408915(current);
        }, C_3390001.m_2053009((String)"auth", (Object[])new Object[0]), C_3390001.m_2053009((String)"auth.accountExpiredNotice", (Object[])new Object[]{account.getName()}), 1)));
        return fut;
    }

    void displayDeviceCode(DeviceFlowData data) {
        this.client.m_2167033(() -> this.client.m_6408915((C_3020744)new DeviceCodeDisplayScreen(this.client.f_0723335, data)));
    }

    public C_0561170 getSkinTexture(Account account) {
        return this.getSkinTexture(account.getUuid(), account.getName());
    }

    public C_0561170 getSkinTexture(User user) {
        return this.getSkinTexture(user.getUuid(), user.getName());
    }

    public C_0561170 getSkinTexture(String uuid, String name) {
        this.loadTextures(uuid, name);
        C_0561170 id = this.textures.get(uuid);
        if (id != null) {
            return id;
        }
        try {
            UUID uUID = UUIDHelper.fromUndashed((String)uuid);
            return C_5946149.m_2817663((UUID)uUID);
        }
        catch (IllegalArgumentException ignored) {
            return C_5946149.m_8990473();
        }
    }

    @Generated
    public static Auth getInstance() {
        return Instance;
    }

    @Generated
    public SkinManager getSkinManager() {
        return this.skinManager;
    }
}

