/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.auth.skin;

import io.github.axolotlclient.AxolotlClientCommon;
import io.github.axolotlclient.AxolotlClientConfig.api.util.Color;
import io.github.axolotlclient.AxolotlClientConfig.api.util.Colors;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.ButtonWidget;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.ClickableWidget;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.Element;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.ParentElement;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.Screen;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.vanilla.ElementListWidget;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.vanilla.EntryListWidget;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.vanilla.widgets.VanillaButtonWidget;
import io.github.axolotlclient.api.SimpleTextInputScreen;
import io.github.axolotlclient.api.util.UUIDHelper;
import io.github.axolotlclient.bridge.util.AxoText;
import io.github.axolotlclient.modules.auth.Account;
import io.github.axolotlclient.modules.auth.Auth;
import io.github.axolotlclient.modules.auth.MSApi;
import io.github.axolotlclient.modules.auth.skin.Asset;
import io.github.axolotlclient.modules.auth.skin.Cape;
import io.github.axolotlclient.modules.auth.skin.LoadingScreen;
import io.github.axolotlclient.modules.auth.skin.Skin;
import io.github.axolotlclient.modules.auth.skin.SkinImportUtil;
import io.github.axolotlclient.modules.auth.skin.SkinWidget;
import io.github.axolotlclient.modules.hud.util.DrawUtil;
import io.github.axolotlclient.util.ButtonWidgetTextures;
import io.github.axolotlclient.util.ClientColors;
import io.github.axolotlclient.util.Watcher;
import io.github.axolotlclient.util.notifications.Notifications;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.unmapped.C_0561170;
import net.minecraft.unmapped.C_1441789;
import net.minecraft.unmapped.C_2899740;
import net.minecraft.unmapped.C_3020744;
import net.minecraft.unmapped.C_3390001;
import net.minecraft.unmapped.C_3754158;
import net.minecraft.unmapped.C_3831727;
import net.minecraft.unmapped.C_4461663;
import net.minecraft.unmapped.C_5786166;
import net.minecraft.unmapped.C_8105098;
import net.minecraft.unmapped.C_8373595;
import net.minecraft.unmapped.C_9550253;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SkinManagementScreen
extends Screen {
    private static final Path SKINS_DIR = FabricLoader.getInstance().getGameDir().resolve("skins");
    private static final int LIST_SKIN_WIDTH = 75;
    private static final int LIST_SKIN_HEIGHT = 110;
    private static final String TEXT_EQUIPPING = C_3390001.m_2053009((String)"skins.manage.equipping", (Object[])new Object[0]);
    private final C_3020744 parent;
    private final Account account;
    private MSApi.MCProfile cachedProfile;
    private SkinListWidget skinList;
    private SkinListWidget capesList;
    private boolean capesTab;
    private SkinWidget current;
    private final Watcher skinDirWatcher;
    private final CompletableFuture<MSApi.MCProfile> loadingFuture;
    private String tooltip = null;

    public SkinManagementScreen(C_3020744 parent, Account account) {
        super(C_3390001.m_2053009((String)"skins.manage", (Object[])new Object[0]));
        this.parent = parent;
        this.account = account;
        this.skinDirWatcher = Watcher.createSelfTicking((Path)SKINS_DIR, () -> {
            AxolotlClientCommon.getInstance().getLogger().info("Reloading screen as local files changed!", new Object[0]);
            this.loadSkinsList();
        });
        this.loadingFuture = (account.needsRefresh() ? account.refresh(Auth.getInstance().getMsApi()) : CompletableFuture.completedFuture(null)).thenComposeAsync(unused -> Auth.getInstance().getMsApi().getProfile(account));
    }

    public void m_7261014(int mouseX, int mouseY, float delta) {
        this.tooltip = null;
        super.m_7261014(mouseX, mouseY, delta);
        if (this.tooltip != null) {
            this.m_5774293(this.tooltip, mouseX, mouseY + 20);
            C_2899740.m_8989115();
        }
    }

    public void m_3593494() {
        int headerHeight = 33;
        int contentHeight = this.f_3080061 - headerHeight * 2;
        class TextWidget
        extends ClickableWidget {
            public TextWidget(int x, int y, int width, int height, String message) {
                super(x, y, width, height, message);
                this.active = false;
            }

            public void drawWidget(int mouseX, int mouseY, float delta) {
                this.m_2717572(SkinManagementScreen.this.f_2020658, this.getMessage(), this.getX() + this.getWidth() / 2, this.getY() + this.getHeight() / 2 - ((SkinManagementScreen)SkinManagementScreen.this).f_2020658.f_6725889 / 2, -1);
            }
        }
        TextWidget titleWidget = new TextWidget(0, headerHeight / 2 - this.f_2020658.f_6725889 / 2, this.f_5465691, this.f_2020658.f_6725889, this.getTitle());
        this.addDrawableChild((Element)titleWidget);
        VanillaButtonWidget back = (VanillaButtonWidget)this.addDrawableChild((Element)new VanillaButtonWidget(this.f_5465691 / 2 - 75, this.f_3080061 - headerHeight / 2 - 10, 150, 20, C_3390001.m_2053009((String)"gui.back", (Object[])new Object[0]), btn -> this.closeScreen()));
        var loadingPlaceholder = new ClickableWidget(0, headerHeight, this.f_5465691, contentHeight, C_3390001.m_2053009((String)"skins.loading", (Object[])new Object[0])){

            protected void drawWidget(int mouseX, int mouseY, float delta) {
                int centerX = this.getX() + this.getWidth() / 2;
                int centerY = this.getY() + this.getHeight() / 2;
                String text = this.getMessage();
                SkinManagementScreen.this.f_2020658.m_4413321(text, (float)centerX - (float)SkinManagementScreen.this.f_2020658.m_0040387(text) / 2.0f, (float)(centerY - 9), -1, false);
                String string = switch ((int)(System.currentTimeMillis() / 300L % 4L)) {
                    case 1, 3 -> "o O o";
                    case 2 -> "o o O";
                    default -> "O o o";
                };
                SkinManagementScreen.this.f_2020658.m_4413321(string, (float)centerX - (float)SkinManagementScreen.this.f_2020658.m_0040387(string) / 2.0f, (float)(centerY + 9), -8355712, false);
            }
        };
        loadingPlaceholder.active = false;
        this.addDrawableChild((Element)loadingPlaceholder);
        this.addDrawableChild((Element)back);
        this.skinList = new SkinListWidget(this.f_7153641, this.f_5465691 / 2, contentHeight - 24, headerHeight + 24, 144);
        this.capesList = new SkinListWidget(this.f_7153641, this.f_5465691 / 2, contentHeight - 24, headerHeight + 24, this.skinList.getEntryContentsHeight() + 24);
        this.skinList.setLeftPos(this.f_5465691 / 2);
        this.capesList.setLeftPos(this.f_5465691 / 2);
        float currentHeight = Math.min((float)this.f_5465691 / 2.0f * 120.0f / 85.0f, (float)contentHeight);
        float currentWidth = currentHeight * 85.0f / 120.0f;
        this.current = new SkinWidget((int)currentWidth, (int)currentHeight, null, this.account);
        this.current.setPosition((int)((float)this.f_5465691 / 4.0f - currentWidth / 2.0f), (int)((float)this.f_3080061 / 2.0f - currentHeight / 2.0f));
        if (!this.capesTab) {
            this.capesList.active = false;
            this.capesList.visible = false;
        } else {
            this.skinList.active = false;
            this.skinList.visible = false;
        }
        ArrayList<VanillaButtonWidget> navBar = new ArrayList<VanillaButtonWidget>();
        VanillaButtonWidget skinsTab = new VanillaButtonWidget(Math.max(this.f_5465691 * 3 / 4 - 102, this.f_5465691 / 2 + 2), headerHeight, Math.min(100, this.f_5465691 / 4 - 2), 20, C_3390001.m_2053009((String)"skins.nav.skins", (Object[])new Object[0]), btn -> {
            navBar.forEach(w -> {
                if (w != btn) {
                    w.active = true;
                }
            });
            btn.active = false;
            this.skinList.active = true;
            this.skinList.visible = true;
            this.capesList.active = false;
            this.capesList.visible = false;
            this.capesTab = false;
        });
        navBar.add(skinsTab);
        VanillaButtonWidget capesTab = new VanillaButtonWidget(this.f_5465691 * 3 / 4 + 2, headerHeight, Math.min(100, this.f_5465691 / 4 - 2), 20, C_3390001.m_2053009((String)"skins.nav.capes", (Object[])new Object[0]), btn -> {
            navBar.forEach(w -> {
                if (w != btn) {
                    w.active = true;
                }
            });
            btn.active = false;
            this.skinList.active = false;
            this.skinList.visible = false;
            this.capesList.active = true;
            this.capesList.visible = true;
            this.capesTab = true;
        });
        navBar.add(capesTab);
        SpriteButton importButton = new SpriteButton(C_3390001.m_2053009((String)"skins.manage.import.local", (Object[])new Object[0]), btn -> {
            btn.active = false;
            ((CompletableFuture)SkinImportUtil.openImportSkinDialog().thenAccept(this::onFileDrop)).thenRun(() -> {
                btn.active = true;
            });
        }, new C_0561170("axolotlclient", "textures/gui/sprites/folder.png"));
        SpriteButton downloadButton = new SpriteButton(C_3390001.m_2053009((String)"skins.manage.import.online", (Object[])new Object[0]), btn -> {
            btn.active = false;
            this.promptForSkinDownload();
        }, new C_0561170("axolotlclient", "textures/gui/sprites/download.png"));
        if (this.f_5465691 - (capesTab.getX() + capesTab.getWidth()) > 28) {
            importButton.setX(this.f_5465691 - importButton.getWidth() - 2);
            downloadButton.setX(importButton.getX() - downloadButton.getWidth() - 2);
            importButton.setY(capesTab.getY() + capesTab.getHeight() - 11);
            downloadButton.setY(importButton.getY());
        } else {
            importButton.setX(capesTab.getX() + capesTab.getWidth() - 11);
            importButton.setY(capesTab.getY() - 13);
            downloadButton.setX(importButton.getX() - 2 - 11);
            downloadButton.setY(importButton.getY());
        }
        skinsTab.active = this.capesTab;
        capesTab.active = !this.capesTab;
        Runnable addWidgets = () -> {
            this.clearChildren();
            this.addDrawableChild((Element)titleWidget);
            this.addDrawableChild((Element)this.current);
            this.addDrawableChild((Element)this.skinList);
            this.addDrawableChild((Element)this.capesList);
            this.addDrawableChild((Element)skinsTab);
            this.addDrawableChild((Element)capesTab);
            this.addDrawableChild((Element)downloadButton);
            this.addDrawableChild((Element)importButton);
            this.addDrawableChild((Element)back);
        };
        if (this.cachedProfile != null) {
            this.initDisplay();
            addWidgets.run();
            return;
        }
        ((CompletableFuture)this.loadingFuture.thenAcceptAsync(profile -> {
            this.cachedProfile = profile;
            this.initDisplay();
            addWidgets.run();
        })).exceptionally(t -> {
            if (t.getCause() instanceof CancellationException) {
                this.f_7153641.m_6408915(this.parent);
                return null;
            }
            AxolotlClientCommon.getInstance().getLogger().error("Failed to load skins!", new Object[]{t});
            String error = C_3390001.m_2053009((String)"skins.error.failed_to_load", (Object[])new Object[0]);
            String errorDesc = C_3390001.m_2053009((String)"skins.error.failed_to_load_desc", (Object[])new Object[0]);
            this.clearChildren();
            this.addDrawableChild((Element)titleWidget);
            this.addDrawableChild((Element)new TextWidget(this.f_5465691 / 2 - this.f_2020658.m_0040387(error) / 2, this.f_3080061 / 2 - this.f_2020658.f_6725889 - 2, this.f_2020658.m_0040387(error), this.f_2020658.f_6725889, error));
            this.addDrawableChild((Element)new TextWidget(this.f_5465691 / 2 - this.f_2020658.m_0040387(errorDesc) / 2, this.f_3080061 / 2 + 1, this.f_2020658.m_0040387(errorDesc), this.f_2020658.f_6725889, errorDesc));
            this.addDrawableChild((Element)back);
            return null;
        });
    }

    private void promptForSkinDownload() {
        this.f_7153641.m_6408915((C_3020744)new SimpleTextInputScreen((C_3020744)this, C_3390001.m_2053009((String)"skins.manage.import.online", (Object[])new Object[0]), C_3390001.m_2053009((String)"skins.manage.import.online.input", (Object[])new Object[0]), s -> UUIDHelper.ensureUuidOpt((String)s).thenAccept(o -> {
            if (o.isPresent()) {
                AxolotlClientCommon.getInstance().getLogger().info("Downloading skin of {} ({})", new Object[]{s, o.get()});
                ((CompletableFuture)Auth.getInstance().getMsApi().getTextures((String)o.get()).exceptionally(th -> {
                    AxolotlClientCommon.getInstance().getLogger().info("Failed to download skin of {} ({})", new Object[]{s, o.get(), th});
                    return null;
                })).thenAccept(t -> {
                    if (t == null) {
                        Notifications.getInstance().addStatus("skins.notification.title", "skins.notification.import.online.failed_to_download", s);
                        return;
                    }
                    try {
                        byte[] bytes = (byte[])t.skin().join();
                        Path out = this.ensureNonexistent(SKINS_DIR.resolve(t.skinKey()));
                        Skin.LocalSkin.writeMetadata((Path)out, Map.of("variant_classic", t.classicModel(), "name", t.name(), "uuid", t.id(), "download_time", Instant.now()));
                        Files.write(out, bytes, new OpenOption[0]);
                        this.f_7153641.m_2167033(this::loadSkinsList);
                        Notifications.getInstance().addStatus("skins.notification.title", "skins.notification.import.online.downloaded", t.name());
                        AxolotlClientCommon.getInstance().getLogger().info("Downloaded skin of {} ({})", new Object[]{t.name(), o.get()});
                    }
                    catch (IOException e) {
                        AxolotlClientCommon.getInstance().getLogger().warn("Failed to write skin file", new Object[]{e});
                        Notifications.getInstance().addStatus("skins.notification.title", "skins.notification.import.online.failed_to_save", t.name());
                    }
                });
            } else {
                Notifications.getInstance().addStatus("skins.notification.title", "skins.notification.import.online.not_found", s);
            }
        })));
    }

    private void initDisplay() {
        this.loadSkinsList();
        this.loadCapesList();
    }

    private void refreshCurrentList() {
        if (this.capesTab) {
            double scroll = this.capesList.getScrollAmount();
            this.loadCapesList();
            this.capesList.setScrollAmount(scroll);
        } else {
            double scroll = this.skinList.getScrollAmount();
            this.loadSkinsList();
            this.skinList.setScrollAmount(scroll);
        }
    }

    private void loadCapesList() {
        ArrayList<Row> rows = new ArrayList<Row>();
        MSApi.MCProfile profile = this.cachedProfile;
        int columns = Math.max(2, (this.f_5465691 / 2 - 25) / 75);
        List capes = profile.capes();
        SkinWidget deselectCape = this.createWidgetForCape(this.current.getSkin(), null);
        Optional<MSApi.MCProfile.OnlineCape> activeCape = capes.stream().filter(Asset::active).findFirst();
        this.current.setCape(activeCape.orElse(null));
        deselectCape.noCape(activeCape.isEmpty());
        for (int i = 0; i < capes.size() + 1; i += columns) {
            Entry widget;
            if (i == 0) {
                widget = this.createEntry(this.capesList.getEntryContentsHeight(), deselectCape, C_3390001.m_2053009((String)"skins.capes.no_cape", (Object[])new Object[0]));
            } else {
                MSApi.MCProfile.OnlineCape cape = (MSApi.MCProfile.OnlineCape)capes.get(i - 1);
                widget = this.createEntryForCape(this.current.getSkin(), (Cape)cape, this.capesList.getEntryContentsHeight());
            }
            ArrayList<ClickableWidget> widgets = new ArrayList<ClickableWidget>();
            widgets.add(widget);
            for (int c = 1; c < columns; ++c) {
                if (i >= capes.size() + 1 - c) continue;
                MSApi.MCProfile.OnlineCape cape2 = (MSApi.MCProfile.OnlineCape)capes.get(i + c - 1);
                Entry widget2 = this.createEntryForCape(this.current.getSkin(), (Cape)cape2, this.capesList.getEntryContentsHeight());
                widgets.add(widget2);
            }
            rows.add(new Row(widgets));
        }
        this.f_7153641.m_2167033(() -> this.capesList.replaceEntries(rows));
    }

    private void loadSkinsList() {
        MSApi.MCProfile profile = this.cachedProfile;
        int columns = Math.max(2, (this.f_5465691 / 2 - 25) / 75);
        ArrayList<Skin> skins = new ArrayList<Skin>(profile.skins());
        Set hashes = skins.stream().map(Asset::sha256).collect(Collectors.toSet());
        Skin defaultSkin = Skin.getDefaultSkin((Account)this.account);
        ArrayList<Skin> local = new ArrayList<Skin>(this.loadLocalSkins());
        Map localHashes = local.stream().collect(Collectors.toMap(Asset::sha256, Function.identity(), (skin, skin2) -> skin));
        local.removeIf(s -> !localHashes.containsValue(s));
        skins.replaceAll(s -> {
            if (s instanceof MSApi.MCProfile.OnlineSkin) {
                Object patt0$temp;
                MSApi.MCProfile.OnlineSkin online = (MSApi.MCProfile.OnlineSkin)s;
                if (localHashes.containsKey(s.sha256()) && (patt0$temp = localHashes.get(s.sha256())) instanceof Skin.LocalSkin) {
                    Skin.LocalSkin file = (Skin.LocalSkin)patt0$temp;
                    local.remove(localHashes.remove(s.sha256()));
                    return new Skin.Shared((Skin.Local)file, online);
                }
            }
            return s;
        });
        skins.addAll(local);
        if (!hashes.contains(defaultSkin.sha256())) {
            skins.add(defaultSkin);
        }
        this.populateSkinList(skins, columns);
    }

    private List<Skin> loadLocalSkins() {
        List<Skin> list;
        block8: {
            Files.createDirectories(SKINS_DIR, new FileAttribute[0]);
            Stream<Path> skins = Files.list(SKINS_DIR);
            try {
                list = skins.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).sorted(Comparator.comparingLong(p -> {
                    try {
                        return Files.getLastModifiedTime(p, new LinkOption[0]).toMillis();
                    }
                    catch (IOException e) {
                        return 0L;
                    }
                }).reversed()).map(Auth.getInstance().getSkinManager()::read).filter(Objects::nonNull).toList();
                if (skins == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (skins != null) {
                        try {
                            skins.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    AxolotlClientCommon.getInstance().getLogger().warn("Failed to read skins dir!", new Object[]{e});
                    return Collections.emptyList();
                }
            }
            skins.close();
        }
        return list;
    }

    private void populateSkinList(List<? extends Skin> skins, int columns) {
        int entryHeight = this.skinList.getEntryContentsHeight();
        ArrayList<Row> rows = new ArrayList<Row>();
        for (int i = 0; i < skins.size(); i += columns) {
            Skin s = skins.get(i);
            if (s != null && s.active()) {
                this.current.setSkin(s);
            }
            Entry widget = this.createEntryForSkin(s, entryHeight);
            ArrayList<ClickableWidget> widgets = new ArrayList<ClickableWidget>();
            widgets.add(widget);
            for (int c = 1; c < columns; ++c) {
                if (i >= skins.size() - c) continue;
                Skin s2 = skins.get(i + c);
                if (s2 != null && s2.active()) {
                    this.current.setSkin(s2);
                }
                Entry widget2 = this.createEntryForSkin(s2, entryHeight);
                widgets.add(widget2);
            }
            rows.add(new Row(widgets));
        }
        this.f_7153641.m_2167033(() -> this.skinList.replaceEntries(rows));
    }

    private Path ensureNonexistent(Path p) {
        if (Files.exists(p, new LinkOption[0])) {
            int counter = 0;
            while (Files.exists(p = p.resolveSibling(p.getFileName().toString() + "_" + ++counter), new LinkOption[0])) {
            }
        }
        return p;
    }

    public void onFileDrop(List<Path> packs) {
        if (packs.isEmpty()) {
            return;
        }
        CompletableFuture[] futs = new CompletableFuture[packs.size()];
        for (int i = 0; i < packs.size(); ++i) {
            Path p = packs.get(i);
            futs[i] = CompletableFuture.runAsync(() -> {
                try {
                    Path target = this.ensureNonexistent(SKINS_DIR.resolve(p.getFileName()));
                    Skin skin = Auth.getInstance().getSkinManager().read(p, false);
                    if (skin != null) {
                        Files.write(target, skin.image(), new OpenOption[0]);
                    } else {
                        AxolotlClientCommon.getInstance().getLogger().info("Skipping dragged file {} because it does not seem to be a valid skin!", new Object[]{p});
                        Notifications.getInstance().addStatus("skins.notification.title", "skins.notification.not_copied", p.getFileName());
                    }
                }
                catch (IOException e) {
                    AxolotlClientCommon.getInstance().getLogger().warn("Failed to copy skin file: ", new Object[]{e});
                }
            }, (Executor)this.f_7153641);
        }
        CompletableFuture.allOf(futs).thenRun(this::loadSkinsList);
    }

    @NotNull
    private Entry createEntryForSkin(Skin skin, int entryHeight) {
        return this.createEntry(entryHeight, new SkinWidget(75, 110, skin, this.account));
    }

    @NotNull
    private Entry createEntryForCape(Skin currentSkin, Cape cape, int entryHeight) {
        return this.createEntry(entryHeight, this.createWidgetForCape(currentSkin, cape), C_3390001.m_2053009((String)cape.alias(), (Object[])new Object[0]));
    }

    private SkinWidget createWidgetForCape(Skin currentSkin, Cape cape) {
        SkinWidget widget2 = new SkinWidget(75, 110, currentSkin, cape, this.account);
        widget2.setRotationY(210.0f);
        return widget2;
    }

    public void clearAndInit() {
        Auth.getInstance().getSkinManager().releaseAll();
        super.clearAndInit();
    }

    public void m_8984281() {
        Auth.getInstance().getSkinManager().releaseAll();
        Watcher.close((Watcher)this.skinDirWatcher);
    }

    public void closeScreen() {
        this.f_7153641.m_6408915(this.parent);
    }

    private SkinListWidget getCurrentList() {
        return this.capesTab ? this.capesList : this.skinList;
    }

    Entry createEntry(int height, SkinWidget widget) {
        return this.createEntry(height, widget, null);
    }

    Entry createEntry(int height, SkinWidget widget, String label) {
        return new Entry(height, widget, label);
    }

    private class SkinListWidget
    extends ElementListWidget<Row> {
        public boolean active;
        public boolean visible;

        public SkinListWidget(C_8105098 minecraft, int width, int height, int y, int entryHeight) {
            super(minecraft, width, SkinManagementScreen.this.f_3080061, y, y + height, entryHeight);
            this.active = true;
            this.visible = true;
            this.setRenderHeader(false, 0);
            this.setRenderBackground(false);
            this.setRenderHorizontalShadows(false);
        }

        protected int getScrollbarPositionX() {
            return this.right - 8;
        }

        public int getRowLeft() {
            return this.left + 3;
        }

        public int getRowWidth() {
            if (this.getMaxScroll() <= 0) {
                return this.width - 4;
            }
            return this.width - 14;
        }

        public int getEntryContentsHeight() {
            return this.itemHeight - 4;
        }

        public void replaceEntries(Collection<Row> newEntries) {
            super.replaceEntries(newEntries);
        }

        public void centerScrollOn(Row entry) {
            super.centerScrollOn((EntryListWidget.Entry)entry);
        }

        public boolean mouseScrolled(double mouseX, double mouseY, double amountX, double amountY) {
            if (!this.visible) {
                return false;
            }
            return super.mouseScrolled(mouseX, mouseY, amountX, amountY);
        }

        public boolean isMouseOver(double mouseX, double mouseY) {
            return this.active && this.visible && super.isMouseOver(mouseX, mouseY);
        }

        public void render(int mouseX, int mouseY, float delta) {
            if (!this.visible) {
                return;
            }
            super.render(mouseX, mouseY, delta);
            this.renderGradient();
        }

        private void renderGradient() {
            C_3754158.m_2374887((int)515);
            C_3754158.m_7027522();
            C_3754158.m_9671730();
            C_3754158.m_0833259((int)770, (int)771, (int)0, (int)1);
            C_3754158.m_6191982();
            C_3754158.m_9665853((int)7425);
            C_3754158.m_2090124();
            C_3754158.m_9671730();
            C_3754158.m_2090124();
            C_5786166 tessellator = C_5786166.m_2065116();
            C_8373595 bufferBuilder = tessellator.m_1454391();
            bufferBuilder.m_0421390(7, C_4461663.f_4312108);
            bufferBuilder.m_3299851((double)this.left, (double)(this.top + 4), 0.0).m_4749889(0.0, 1.0).m_9724942(0, 0, 0, 0).m_4365807();
            bufferBuilder.m_3299851((double)this.right, (double)(this.top + 4), 0.0).m_4749889(1.0, 1.0).m_9724942(0, 0, 0, 0).m_4365807();
            bufferBuilder.m_3299851((double)this.right, (double)this.top, 0.0).m_4749889(1.0, 0.0).m_9724942(0, 0, 0, 255).m_4365807();
            bufferBuilder.m_3299851((double)this.left, (double)this.top, 0.0).m_4749889(0.0, 0.0).m_9724942(0, 0, 0, 255).m_4365807();
            tessellator.m_8222644();
            bufferBuilder.m_0421390(7, C_4461663.f_4312108);
            bufferBuilder.m_3299851((double)this.left, (double)this.bottom, 0.0).m_4749889(0.0, 1.0).m_9724942(0, 0, 0, 255).m_4365807();
            bufferBuilder.m_3299851((double)this.right, (double)this.bottom, 0.0).m_4749889(1.0, 1.0).m_9724942(0, 0, 0, 255).m_4365807();
            bufferBuilder.m_3299851((double)this.right, (double)(this.bottom - 4), 0.0).m_4749889(1.0, 0.0).m_9724942(0, 0, 0, 0).m_4365807();
            bufferBuilder.m_3299851((double)this.left, (double)(this.bottom - 4), 0.0).m_4749889(0.0, 0.0).m_9724942(0, 0, 0, 0).m_4365807();
            tessellator.m_8222644();
            C_3754158.m_7547086();
        }
    }

    private class SpriteButton
    extends VanillaButtonWidget {
        private C_0561170 sprite;

        SpriteButton(String message, ButtonWidget.PressAction action, C_0561170 sprite) {
            super(0, 0, 11, 11, message, action);
            this.sprite = sprite;
        }

        protected void drawWidget(int mouseX, int mouseY, float delta) {
            int i = 1;
            if (!this.active) {
                i = 0;
            } else if (this.hovered) {
                i = 2;
                SkinManagementScreen.this.tooltip = this.getMessage();
            }
            C_0561170 tex = ButtonWidgetTextures.get(i);
            DrawUtil.blitSprite(tex, this.getX(), this.getY(), this.getWidth(), this.getHeight(), new DrawUtil.NineSlice(200, 20, 3));
            SkinManagementScreen.this.f_7153641.m_1218956().m_5325521(this.sprite);
            DrawUtil.m_5935491((int)(this.getX() + 2), (int)(this.getY() + 2), (float)0.0f, (float)0.0f, (int)7, (int)7, (float)7.0f, (float)7.0f);
        }

        protected void drawScrollingText(C_3831727 renderer, int offset, Color color) {
        }
    }

    private class Entry
    extends ClickableWidget
    implements ParentElement {
        private final SkinWidget skinWidget;
        @Nullable
        private final ClickableWidget label;
        private final List<ClickableWidget> actionButtons;
        private final ClickableWidget equipButton;
        private boolean equipping;
        private long equippingStart;
        @Nullable
        private Element focused;
        private boolean dragging;

        public Entry(int height, @Nullable SkinWidget widget, String label) {
            super(0, 0, widget.getWidth(), height, "");
            this.actionButtons = new ArrayList<ClickableWidget>();
            widget.setWidth(this.getWidth() - 4);
            Asset asset = widget.getFocusedAsset();
            if (asset != null) {
                Asset.Online online;
                if (asset instanceof Skin) {
                    Skin skin = (Skin)asset;
                    C_0561170 wideSprite = new C_0561170("axolotlclient", "textures/gui/sprites/wide.png");
                    C_0561170 slimSprite = new C_0561170("axolotlclient", "textures/gui/sprites/slim.png");
                    String slimText = C_3390001.m_2053009((String)"skins.manage.variant.classic", (Object[])new Object[0]);
                    String wideText = C_3390001.m_2053009((String)"skins.manage.variant.slim", (Object[])new Object[0]);
                    this.actionButtons.add((ClickableWidget)new SpriteButton(skin.classicVariant() ? wideText : slimText, btn -> {
                        SpriteButton self = (SpriteButton)btn;
                        skin.classicVariant(!skin.classicVariant());
                        self.sprite = skin.classicVariant() ? slimSprite : wideSprite;
                        self.setMessage(skin.classicVariant() ? wideText : slimText);
                    }, skin.classicVariant() ? slimSprite : wideSprite));
                }
                if (asset instanceof Asset.Local) {
                    Asset.Local local = (Asset.Local)asset;
                    this.actionButtons.add((ClickableWidget)new SpriteButton(C_3390001.m_2053009((String)"skins.manage.delete", (Object[])new Object[0]), btn -> {
                        btn.active = false;
                        this.client.m_6408915((C_3020744)new C_1441789((confirmed, i) -> {
                            this.client.m_6408915((C_3020744)new LoadingScreen(SkinManagementScreen.this.getTitle(), C_3390001.m_2053009((String)"menu.working", (Object[])new Object[0])));
                            if (confirmed) {
                                try {
                                    Files.delete(local.file());
                                    Skin.LocalSkin.deleteMetadata((Path)local.file());
                                }
                                catch (IOException e) {
                                    AxolotlClientCommon.getInstance().getLogger().warn("Failed to delete: ", new Object[]{e});
                                }
                            }
                            this.client.m_6408915((C_3020744)SkinManagementScreen.this);
                            btn.active = true;
                        }, C_3390001.m_2053009((String)"skins.manage.delete.confirm", (Object[])new Object[0]), ((C_9550253)(asset.active() ? AxoText.translatable((String)"skins.manage.delete.confirm.desc_active", (Object[])new Object[0]) : AxoText.translatable((String)"skins.manage.delete.confirm.desc", (Object[])new Object[0])).br$color(Colors.RED.toInt())).m_2117196(), 0));
                    }, new C_0561170("axolotlclient", "textures/gui/sprites/delete.png")));
                }
                if (asset instanceof Asset.Online && (online = (Asset.Online)asset).supportsDownload() && !(asset instanceof Asset.Local)) {
                    this.actionButtons.add((ClickableWidget)new SpriteButton(C_3390001.m_2053009((String)"skins.manage.download", (Object[])new Object[0]), btn -> {
                        btn.active = false;
                        this.download(asset).thenRun(() -> {
                            SkinManagementScreen.this.refreshCurrentList();
                            btn.active = true;
                        });
                    }, new C_0561170("axolotlclient", "textures/gui/sprites/download.png")));
                }
            }
            if (label != null) {
                this.label = new ClickableWidget(0, 0, widget.getWidth(), 16, label){

                    protected void drawWidget(int mouseX, int mouseY, float partialTick) {
                        DrawUtil.drawScrollableText(SkinManagementScreen.this.f_2020658, this.getMessage(), this.getX() + 2, this.getY(), this.getX() + this.getWidth() - 2, this.getY() + this.getHeight(), -1);
                    }
                };
                this.label.active = false;
            } else {
                this.label = null;
            }
            this.equipButton = new VanillaButtonWidget(0, 0, widget.getWidth(), 20, C_3390001.m_2053009((String)(widget.isEquipped() ? "skins.manage.equipped" : "skins.manage.equip"), (Object[])new Object[0]), btn -> {
                this.equippingStart = System.currentTimeMillis();
                this.equipping = true;
                btn.setMessage(TEXT_EQUIPPING);
                btn.active = false;
                Consumer<CompletableFuture> consumer = f -> ((CompletableFuture)f.thenAcceptAsync(p -> {
                    SkinManagementScreen.this.cachedProfile = p;
                    if (this.client.f_0723335 == SkinManagementScreen.this) {
                        SkinManagementScreen.this.refreshCurrentList();
                    } else {
                        this.client.m_2167033(() -> this.client.m_6408915((C_3020744)SkinManagementScreen.this));
                    }
                })).exceptionally(t -> {
                    AxolotlClientCommon.getInstance().getLogger().warn("Failed to equip asset!", new Object[]{t});
                    this.equipping = false;
                    return null;
                });
                if (asset instanceof Skin && !(SkinManagementScreen.this.current.getSkin() instanceof Skin.Local)) {
                    this.client.m_6408915((C_3020744)new C_1441789((confirmed, i) -> {
                        this.client.m_6408915((C_3020744)new LoadingScreen(SkinManagementScreen.this.getTitle(), TEXT_EQUIPPING));
                        if (confirmed) {
                            consumer.accept((CompletableFuture)this.download((Asset)SkinManagementScreen.this.current.getSkin()).thenCompose(a -> widget.equip()));
                        } else {
                            consumer.accept(widget.equip());
                        }
                    }, C_3390001.m_2053009((String)"skins.manage.equip.confirm", (Object[])new Object[0]), C_3390001.m_2053009((String)"skins.manage.equip.download_current", (Object[])new Object[0]), 0));
                } else {
                    consumer.accept(widget.equip());
                }
            });
            this.equipButton.active = !widget.isEquipped();
            this.skinWidget = widget;
        }

        @NotNull
        private CompletableFuture<?> download(Asset asset) {
            return CompletableFuture.runAsync(() -> {
                try {
                    Path out = SKINS_DIR.resolve(asset.sha256());
                    Files.createDirectories(out.getParent(), new FileAttribute[0]);
                    Files.write(out, asset.image(), new OpenOption[0]);
                    if (asset instanceof Skin) {
                        Skin skin = (Skin)asset;
                        Skin.LocalSkin.writeMetadata((Path)out, Map.of("variant_classic", skin.classicVariant()));
                    }
                }
                catch (IOException e) {
                    AxolotlClientCommon.getInstance().getLogger().warn("Failed to download: ", new Object[]{e});
                }
            });
        }

        public final boolean isDragging() {
            return this.dragging;
        }

        public final void setDragging(boolean dragging) {
            this.dragging = dragging;
        }

        @Nullable
        public Element getFocused() {
            return this.focused;
        }

        public void setFocusedChild(@Nullable Element child) {
            if (this.focused != null) {
                this.focused.setFocused(false);
            }
            if (child != null) {
                child.setFocused(true);
            }
            this.focused = child;
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            return super.mouseClicked(mouseX, mouseY, button);
        }

        public boolean mouseReleased(double mouseX, double mouseY, int button) {
            return super.mouseReleased(mouseX, mouseY, button);
        }

        public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
            return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
        }

        public boolean isFocused() {
            return super.isFocused();
        }

        public void setFocused(boolean focused) {
            super.setFocused(focused);
        }

        @NotNull
        public List<? extends Element> children() {
            return Stream.concat(this.actionButtons.stream(), Stream.of(new ClickableWidget[]{this.skinWidget, this.label, this.equipButton})).filter(Objects::nonNull).toList();
        }

        private float applyEasing(float x) {
            return x * x * x;
        }

        protected void drawWidget(int mouseX, int mouseY, float partialTick) {
            int y = this.getY() + 4;
            int x = this.getX() + 2;
            this.skinWidget.setPosition(x, y);
            this.skinWidget.setWidth(this.getWidth() - 4);
            if (this.skinWidget.isEquipped() || this.equipping) {
                long prog = ((Boolean)Auth.getInstance().skinManagerAnimations.get()).booleanValue() ? (this.equipping ? (System.currentTimeMillis() - this.equippingStart) / 20L % 100L : Math.abs(System.currentTimeMillis() / 30L % 200L - 100L)) : 100L;
                float percent = (float)prog / 100.0f;
                float gradientWidth = this.equipping ? percent * Math.min((float)this.getWidth() / 3.0f, (float)this.getHeight() / 3.0f) : Math.min((float)this.getWidth() / 15.0f, (float)this.getHeight() / 6.0f) + this.applyEasing(percent) * Math.min((float)(this.getWidth() * 2) / 15.0f, (float)this.getHeight() / 6.0f);
                GradientHoleRectangleRenderState.render(this.getX() + 2, this.getY() + 2, this.getX() + this.getWidth() - 2, this.skinWidget.getY() + this.skinWidget.getHeight() + 2, gradientWidth, this.equipping ? -65400 : ClientColors.SELECTOR_GREEN.toInt(), 0);
            }
            this.skinWidget.render(mouseX, mouseY, partialTick);
            int actionButtonY = this.getY() + 2;
            for (ClickableWidget button : this.actionButtons) {
                button.setPosition(this.skinWidget.getX() + this.skinWidget.getWidth() - button.getWidth(), actionButtonY);
                if (this.isHovered() || button.isHovered()) {
                    button.render(mouseX, mouseY, partialTick);
                }
                actionButtonY += button.getHeight() + 2;
            }
            if (this.label != null) {
                this.label.setPosition(x, this.skinWidget.getY() + this.skinWidget.getHeight() + 6);
                this.label.render(mouseX, mouseY, partialTick);
                this.label.setWidth(this.getWidth() - 4);
                this.equipButton.setPosition(x, this.label.getY() + this.label.getHeight() + 2);
            } else {
                this.equipButton.setPosition(x, this.skinWidget.getY() + this.skinWidget.getHeight() + 4);
            }
            this.equipButton.setWidth(this.getWidth() - 4);
            this.equipButton.render(mouseX, mouseY, partialTick);
            if (this.isHovered()) {
                DrawUtil.outlineRect(this.getX(), this.getY(), this.getWidth(), this.getHeight(), -1);
            }
        }

        private static class GradientHoleRectangleRenderState {
            private GradientHoleRectangleRenderState() {
            }

            public static void render(int x0, int y0, int x1, int y1, float gradientWidth, int col1, int col2) {
                C_5786166 tess = C_5786166.m_2065116();
                C_8373595 vertexConsumer = tess.m_1454391();
                float z = 0.0f;
                int a1 = ClientColors.ARGB.alpha((int)col1);
                int r1 = ClientColors.ARGB.red((int)col1);
                int g1 = ClientColors.ARGB.green((int)col1);
                int b1 = ClientColors.ARGB.blue((int)col1);
                int a2 = ClientColors.ARGB.alpha((int)col2);
                int r2 = ClientColors.ARGB.red((int)col2);
                int g2 = ClientColors.ARGB.green((int)col2);
                int b2 = ClientColors.ARGB.blue((int)col2);
                C_3754158.m_2090124();
                C_3754158.m_9671730();
                C_3754158.m_6191982();
                C_3754158.m_0833259((int)770, (int)771, (int)1, (int)0);
                C_3754158.m_9665853((int)7425);
                vertexConsumer.m_0421390(7, C_4461663.f_8459667);
                vertexConsumer.m_3299851((double)x0, (double)y0, (double)z).m_9724942(r1, g1, b1, a1).m_4365807();
                vertexConsumer.m_3299851((double)((float)x0 + gradientWidth), (double)((float)y0 + gradientWidth), (double)z).m_9724942(r2, g2, b2, a2).m_4365807();
                vertexConsumer.m_3299851((double)((float)x1 - gradientWidth), (double)((float)y0 + gradientWidth), (double)z).m_9724942(r2, g2, b2, a2).m_4365807();
                vertexConsumer.m_3299851((double)x1, (double)y0, (double)z).m_9724942(r1, g1, b1, a1).m_4365807();
                vertexConsumer.m_3299851((double)x0, (double)y1, (double)z).m_9724942(r1, g1, b1, a1).m_4365807();
                vertexConsumer.m_3299851((double)((float)x0 + gradientWidth), (double)((float)y1 - gradientWidth), (double)z).m_9724942(r2, g2, b2, a2).m_4365807();
                vertexConsumer.m_3299851((double)((float)x0 + gradientWidth), (double)((float)y0 + gradientWidth), (double)z).m_9724942(r2, g2, b2, a2).m_4365807();
                vertexConsumer.m_3299851((double)x0, (double)y0, (double)z).m_9724942(r1, g1, b1, a1).m_4365807();
                vertexConsumer.m_3299851((double)x1, (double)y1, (double)z).m_9724942(r1, g1, b1, a1).m_4365807();
                vertexConsumer.m_3299851((double)((float)x1 - gradientWidth), (double)((float)y1 - gradientWidth), (double)z).m_9724942(r2, g2, b2, a2).m_4365807();
                vertexConsumer.m_3299851((double)((float)x0 + gradientWidth), (double)((float)y1 - gradientWidth), (double)z).m_9724942(r2, g2, b2, a2).m_4365807();
                vertexConsumer.m_3299851((double)x0, (double)y1, (double)z).m_9724942(r1, g1, b1, a1).m_4365807();
                vertexConsumer.m_3299851((double)x1, (double)y0, (double)z).m_9724942(r1, g1, b1, a1).m_4365807();
                vertexConsumer.m_3299851((double)((float)x1 - gradientWidth), (double)((float)y0 + gradientWidth), (double)z).m_9724942(r2, g2, b2, a2).m_4365807();
                vertexConsumer.m_3299851((double)((float)x1 - gradientWidth), (double)((float)y1 - gradientWidth), (double)z).m_9724942(r2, g2, b2, a2).m_4365807();
                vertexConsumer.m_3299851((double)x1, (double)y1, (double)z).m_9724942(r1, g1, b1, a1).m_4365807();
                tess.m_8222644();
                C_3754158.m_9665853((int)7424);
                C_3754158.m_5313301();
                C_3754158.m_2754767();
                C_3754158.m_7547086();
            }
        }
    }

    private class Row
    extends ElementListWidget.Entry<Row> {
        private final List<ClickableWidget> widgets;

        public Row(List<ClickableWidget> entries) {
            this.widgets = entries;
        }

        public void render(int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            int x = left;
            if (this.widgets.isEmpty()) {
                return;
            }
            int count = this.widgets.size();
            int padding = (width - 5 * (count - 1)) / count;
            for (ClickableWidget w : this.widgets) {
                w.setPosition(x, top);
                w.setWidth(padding);
                w.render(mouseX, mouseY, partialTick);
                x += w.getWidth() + 5;
            }
        }

        @NotNull
        public List<? extends Element> children() {
            return this.widgets;
        }

        public void setFocusedChild(@Nullable Element focused) {
            super.setFocusedChild(focused);
            if (focused != null) {
                SkinManagementScreen.this.getCurrentList().centerScrollOn(this);
            }
        }
    }
}

