/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.auth.skin;

import com.google.common.hash.Hashing;
import io.github.axolotlclient.AxolotlClientCommon;
import io.github.axolotlclient.bridge.util.AxoIdentifier;
import io.github.axolotlclient.modules.auth.skin.Cape;
import io.github.axolotlclient.modules.auth.skin.Skin;
import io.github.axolotlclient.util.ClientColors;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import javax.imageio.ImageIO;
import net.minecraft.unmapped.C_0561170;
import net.minecraft.unmapped.C_3779718;
import net.minecraft.unmapped.C_4882708;
import net.minecraft.unmapped.C_8105098;
import net.minecraft.unmapped.C_8892483;

public class SkinManager {
    private final Set<AxoIdentifier> loadedTextures = new ConcurrentSkipListSet<AxoIdentifier>(Comparator.comparing(Object::toString));

    public Skin read(Path p) {
        return this.read(p, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Skin read(Path p, boolean fix) {
        try {
            boolean bl;
            boolean slim;
            byte[] in = Files.readAllBytes(p);
            String sha256 = Hashing.sha256().hashBytes(in).toString();
            try (ByteArrayInputStream bs = new ByteArrayInputStream(in);){
                BufferedImage img = ImageIO.read(bs);
                int height = img.getHeight();
                int width = img.getWidth();
                if (width != 64) {
                    Skin skin = null;
                    return skin;
                }
                if (height == 32) {
                    if (fix) {
                        try (OutputStream out = Files.newOutputStream(p, new OpenOption[0]);){
                            ImageIO.write((RenderedImage)new C_8892483().m_1760968(img), "png", out);
                        }
                    }
                    slim = false;
                } else {
                    if (height != 64) {
                        Skin out = null;
                        return out;
                    }
                    slim = ClientColors.ARGB.alpha((int)img.getRGB(50, 16)) == 0;
                }
                Map metadata = Skin.LocalSkin.readMetadata((Path)p);
                if (metadata != null && metadata.containsKey("variant_classic")) {
                    slim = (Boolean)metadata.get("variant_classic") == false;
                }
            }
            if (!slim) {
                bl = true;
                return new Skin.LocalSkin(bl, p, in, sha256);
            }
            bl = false;
            return new Skin.LocalSkin(bl, p, in, sha256);
        }
        catch (Exception e) {
            AxolotlClientCommon.getInstance().getLogger().warn("Failed to probe skin: ", new Object[]{e});
            return null;
        }
    }

    public AxoIdentifier loadSkin(Skin skin) {
        AxoIdentifier rl = AxoIdentifier.of((String)"axolotlclient", (String)("skins/" + skin.sha256()));
        if (this.loadedTextures.contains(rl)) {
            return rl;
        }
        try (ByteArrayInputStream bs = new ByteArrayInputStream(skin.image());){
            BufferedImage img = ImageIO.read(bs);
            C_3779718 tex = new C_3779718(img.getWidth(), img.getHeight());
            img.getRGB(0, 0, img.getWidth(), img.getHeight(), tex.m_1823577(), 0, img.getWidth());
            tex.m_4420833();
            C_8105098.m_0408063().m_1218956().m_0381205((C_0561170)rl, (C_4882708)tex);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.loadedTextures.add(rl);
        return rl;
    }

    public AxoIdentifier loadCape(Cape cape) {
        AxoIdentifier rl = AxoIdentifier.of((String)"axolotlclient", (String)("capes/" + cape.id()));
        if (this.loadedTextures.contains(rl)) {
            return rl;
        }
        try (ByteArrayInputStream bs = new ByteArrayInputStream(cape.image());){
            BufferedImage img = ImageIO.read(bs);
            C_3779718 tex = new C_3779718(img.getWidth(), img.getHeight());
            img.getRGB(0, 0, img.getWidth(), img.getHeight(), tex.m_1823577(), 0, img.getWidth());
            tex.m_4420833();
            C_8105098.m_0408063().m_1218956().m_0381205((C_0561170)rl, (C_4882708)tex);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.loadedTextures.add(rl);
        return rl;
    }

    public void releaseAll() {
        this.loadedTextures.forEach(id -> C_8105098.m_0408063().m_1218956().m_3775266((C_0561170)id));
        this.loadedTextures.clear();
    }
}

