/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.blur;

import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.AxolotlClientConfig.api.options.Option;
import io.github.axolotlclient.AxolotlClientConfig.api.options.OptionCategory;
import io.github.axolotlclient.AxolotlClientConfig.api.util.Color;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.BooleanOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.ColorOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.IntegerOption;
import io.github.axolotlclient.mixin.MinecraftClientAccessor;
import io.github.axolotlclient.mixin.ShaderEffectAccessor;
import io.github.axolotlclient.modules.AbstractModule;
import io.github.axolotlclient.util.ClientColors;
import io.github.axolotlclient.util.Util;
import java.io.IOException;
import java.io.InputStream;
import lombok.Generated;
import net.minecraft.unmapped.C_0561170;
import net.minecraft.unmapped.C_0731481;
import net.minecraft.unmapped.C_1616310;
import net.minecraft.unmapped.C_1676943;
import net.minecraft.unmapped.C_2691939;
import net.minecraft.unmapped.C_4811147;
import net.minecraft.unmapped.C_7669754;
import net.minecraft.unmapped.C_8105098;
import org.apache.commons.io.IOUtils;

public class MenuBlur
extends AbstractModule {
    private static final MenuBlur Instance = new MenuBlur();
    public final BooleanOption enabled = new BooleanOption("enabled", Boolean.valueOf(false));
    private final C_0561170 shaderLocation = new C_0561170("minecraft:shaders/post/menu_blur.json");
    private final IntegerOption strength = new IntegerOption("strength", Integer.valueOf(8), Integer.valueOf(0), Integer.valueOf(100));
    private final IntegerOption fadeTime = new IntegerOption("fadeTime", Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(10));
    private final ColorOption bgColor = new ColorOption("bgcolor", new Color(0x64000000));
    private final OptionCategory category = OptionCategory.create((String)"menublur");
    private final Color black = new Color(0);
    private long openTime;
    private C_1616310 shader;
    private int lastWidth;
    private int lastHeight;

    public void init() {
        this.category.add(new Option[]{this.enabled, this.strength, this.fadeTime, this.bgColor});
        AxolotlClient.config().rendering.add(new OptionCategory[]{this.category});
        AxolotlClient.runtimeResources.put(this.shaderLocation, new MenuBlurShader());
    }

    public boolean renderScreen() {
        if (((Boolean)this.enabled.get()).booleanValue() && !(C_8105098.m_0408063().f_0723335 instanceof C_7669754) && this.shader != null) {
            C_2691939.m_7865719((int)0, (int)0, (int)Util.getWindow().m_1713651(), (int)Util.getWindow().m_5421693(), (int)ClientColors.blend((Color)this.black, (Color)this.bgColor.get(), (float)this.getProgress()).toInt());
            return true;
        }
        return false;
    }

    private float getProgress() {
        return Math.min((float)(System.currentTimeMillis() - this.openTime) / ((float)((Integer)this.fadeTime.get()).intValue() * 1000.0f), 1.0f);
    }

    public void updateBlur() {
        if (((Boolean)this.enabled.get()).booleanValue() && C_8105098.m_0408063().f_0723335 != null && !(C_8105098.m_0408063().f_0723335 instanceof C_7669754)) {
            if ((this.shader == null || this.client.f_0545414 != this.lastWidth || this.client.f_5990000 != this.lastHeight) && this.client.f_5990000 != 0 && this.client.f_0545414 != 0) {
                try {
                    this.shader = new C_1616310(this.client.m_1218956(), this.client.m_3739907(), this.client.m_4441537(), this.shaderLocation);
                    this.shader.m_0289132(this.client.f_0545414, this.client.f_5990000);
                }
                catch (IOException e) {
                    AxolotlClient.LOGGER.error("Failed to load Menu Blur: ", new Object[]{e});
                    return;
                }
            }
            if (this.shader != null) {
                ((ShaderEffectAccessor)this.shader).getPasses().forEach(shader -> {
                    C_4811147 radius = shader.m_5385513().m_4711234("Radius");
                    C_4811147 progress = shader.m_5385513().m_4711234("Progress");
                    if (radius != null) {
                        radius.m_1456501((float)((Integer)this.strength.get()).intValue());
                    }
                    if (progress != null) {
                        if ((Integer)this.fadeTime.get() > 0) {
                            progress.m_1456501(this.getProgress());
                        } else {
                            progress.m_1456501(1.0f);
                        }
                    }
                });
            }
            this.lastWidth = this.client.f_0545414;
            this.lastHeight = this.client.f_5990000;
            this.renderBlur();
        }
    }

    public void renderBlur() {
        this.shader.m_0877167(((MinecraftClientAccessor)C_8105098.m_0408063()).getTicker().f_7092791);
    }

    public void onScreenOpen() {
        this.openTime = System.currentTimeMillis();
    }

    @Generated
    public static MenuBlur getInstance() {
        return Instance;
    }

    private static class MenuBlurShader
    implements C_1676943 {
        private MenuBlurShader() {
        }

        public C_0561170 m_1808586() {
            return null;
        }

        public InputStream m_3098790() {
            return IOUtils.toInputStream((String)"{\n    \"targets\": [\n        \"swap\"\n    ],\n    \"passes\": [\n        {\n            \"name\": \"menu_blur\",\n            \"intarget\": \"minecraft:main\",\n            \"outtarget\": \"swap\",\n            \"uniforms\": [\n                {\n                    \"name\": \"BlurDir\",\n                    \"values\": [ 1.0, 0.0 ]\n                },\n                {\n                    \"name\": \"Radius\",\n                    \"values\": [ 0.0 ]\n                }\n            ]\n        },\n        {\n            \"name\": \"menu_blur\",\n            \"intarget\": \"swap\",\n            \"outtarget\": \"minecraft:main\",\n            \"uniforms\": [\n                {\n                    \"name\": \"BlurDir\",\n                    \"values\": [ 0.0, 1.0 ]\n                },\n                {\n                    \"name\": \"Radius\",\n                    \"values\": [ 0.0 ]\n                }\n            ]\n        },\n        {\n            \"name\": \"menu_blur\",\n            \"intarget\": \"minecraft:main\",\n            \"outtarget\": \"swap\",\n            \"uniforms\": [\n                {\n                    \"name\": \"BlurDir\",\n                    \"values\": [ 1.0, 0.0 ]\n                },\n                {\n                    \"name\": \"Radius\",\n                    \"values\": [ 0.0 ]\n                }\n            ]\n        },\n        {\n            \"name\": \"menu_blur\",\n            \"intarget\": \"swap\",\n            \"outtarget\": \"minecraft:main\",\n            \"uniforms\": [\n                {\n                    \"name\": \"BlurDir\",\n                    \"values\": [ 0.0, 1.0 ]\n                },\n                {\n                    \"name\": \"Radius\",\n                    \"values\": [ 0.0 ]\n                }\n            ]\n        }\n    ]\n}");
        }

        public boolean m_5807457() {
            return false;
        }

        public <T extends C_0731481> T m_5396002(String key) {
            return null;
        }

        public String m_6204189() {
            return null;
        }
    }
}

