/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.blur;

import com.google.gson.JsonSyntaxException;
import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.AxolotlClientConfig.api.options.Option;
import io.github.axolotlclient.AxolotlClientConfig.api.options.OptionCategory;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.BooleanOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.FloatOption;
import io.github.axolotlclient.mixin.ShaderEffectAccessor;
import io.github.axolotlclient.modules.AbstractModule;
import java.io.IOException;
import java.io.InputStream;
import lombok.Generated;
import net.minecraft.unmapped.C_0561170;
import net.minecraft.unmapped.C_0731481;
import net.minecraft.unmapped.C_1616310;
import net.minecraft.unmapped.C_1676943;
import net.minecraft.unmapped.C_4811147;
import org.apache.commons.io.IOUtils;

public class MotionBlur
extends AbstractModule {
    private static final MotionBlur Instance = new MotionBlur();
    public final BooleanOption enabled = new BooleanOption("enabled", Boolean.valueOf(false));
    public final FloatOption strength = new FloatOption("strength", Float.valueOf(50.0f), Float.valueOf(1.0f), Float.valueOf(99.0f));
    public final BooleanOption inGuis = new BooleanOption("inGuis", Boolean.valueOf(false));
    public final OptionCategory category = OptionCategory.create((String)"motionBlur");
    private final C_0561170 shaderLocation = new C_0561170("minecraft:shaders/post/motion_blur.json");
    public C_1616310 shader;
    private float currentBlur;
    private int lastWidth;
    private int lastHeight;

    private static float getBlur() {
        return ((Float)MotionBlur.getInstance().strength.get()).floatValue() / 100.0f;
    }

    public void init() {
        this.category.add(new Option[]{this.enabled, this.strength, this.inGuis});
        AxolotlClient.config().rendering.add(new OptionCategory[]{this.category});
        AxolotlClient.runtimeResources.put(this.shaderLocation, new MotionBlurShader());
    }

    public void onUpdate() {
        if ((this.shader == null || this.client.f_0545414 != this.lastWidth || this.client.f_5990000 != this.lastHeight) && this.client.f_5990000 != 0 && this.client.f_0545414 != 0) {
            this.currentBlur = MotionBlur.getBlur();
            try {
                this.shader = new C_1616310(this.client.m_1218956(), this.client.m_3739907(), this.client.m_4441537(), this.shaderLocation);
                this.shader.m_0289132(this.client.f_0545414, this.client.f_5990000);
            }
            catch (JsonSyntaxException | IOException e) {
                AxolotlClient.LOGGER.error("Could not load motion blur: ", new Object[]{e});
            }
        }
        if (this.currentBlur != MotionBlur.getBlur()) {
            ((ShaderEffectAccessor)this.shader).getPasses().forEach(shader -> {
                C_4811147 blendFactor = shader.m_5385513().m_4711234("BlendFactor");
                if (blendFactor != null) {
                    blendFactor.m_1456501(MotionBlur.getBlur());
                }
            });
            this.currentBlur = MotionBlur.getBlur();
        }
        this.lastWidth = this.client.f_0545414;
        this.lastHeight = this.client.f_5990000;
    }

    @Generated
    public static MotionBlur getInstance() {
        return Instance;
    }

    private static class MotionBlurShader
    implements C_1676943 {
        private MotionBlurShader() {
        }

        public C_0561170 m_1808586() {
            return null;
        }

        public InputStream m_3098790() {
            return IOUtils.toInputStream((String)String.format("{    \"targets\": [        \"swap\",        \"previous\"    ],    \"passes\": [        {            \"name\": \"motion_blur\",            \"intarget\": \"minecraft:main\",            \"outtarget\": \"swap\",            \"auxtargets\": [                {                    \"name\": \"PrevSampler\",                    \"id\": \"previous\"                }            ],            \"uniforms\": [                {                    \"name\": \"BlendFactor\",                    \"values\": [ %s ]                }            ]        },        {            \"name\": \"blit\",            \"intarget\": \"swap\",            \"outtarget\": \"previous\"        },        {            \"name\": \"blit\",            \"intarget\": \"swap\",            \"outtarget\": \"minecraft:main\"        }    ]}", Float.valueOf(MotionBlur.getBlur())));
        }

        public boolean m_5807457() {
            return false;
        }

        public <T extends C_0731481> T m_5396002(String key) {
            return null;
        }

        public String m_6204189() {
            return null;
        }
    }
}

