/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.hud;

import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.AxolotlClientConfig.api.AxolotlClientConfig;
import io.github.axolotlclient.AxolotlClientConfig.api.options.Option;
import io.github.axolotlclient.AxolotlClientConfig.api.options.OptionCategory;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.BooleanOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.util.ConfigStyles;
import io.github.axolotlclient.bridge.impl.AxoRenderContextImpl;
import io.github.axolotlclient.modules.hud.HudManager;
import io.github.axolotlclient.modules.hud.gui.component.HudEntry;
import io.github.axolotlclient.modules.hud.snapping.SnappingHelper;
import io.github.axolotlclient.modules.hud.util.DrawPosition;
import io.github.axolotlclient.modules.hud.util.Rectangle;
import io.github.axolotlclient.util.WindowAccess;
import java.util.List;
import java.util.Optional;
import net.minecraft.unmapped.C_2348249;
import net.minecraft.unmapped.C_3020744;
import net.minecraft.unmapped.C_3390001;
import net.minecraft.unmapped.C_3754158;
import net.minecraft.unmapped.C_8105098;

public class HudEditScreen
extends C_3020744 {
    private static final BooleanOption snapping = new BooleanOption("snapping", Boolean.valueOf(true));
    private static final OptionCategory hudEditScreenCategory = OptionCategory.create((String)"hudEditScreen");
    private static final int GRAB_TOLERANCE = 5;
    private final long MOVE_CURSOR = WindowAccess.getInstance().createCursor(WindowAccess.Cursor.RESIZE_ALL);
    private final long DEFAULT_CURSOR = WindowAccess.getInstance().createCursor(WindowAccess.Cursor.ARROW);
    private final long NWSE_RESIZE_CURSOR = WindowAccess.getInstance().createCursor(WindowAccess.Cursor.RESIZE_NWSE);
    private final long NESW_RESIZE_CURSOR = WindowAccess.getInstance().createCursor(WindowAccess.Cursor.RESIZE_NESW);
    private final C_3020744 parent;
    private HudEntry current;
    private DrawPosition offset = null;
    private boolean mouseDown;
    private SnappingHelper snap;
    private long currentCursor;
    private ModificationMode mode = ModificationMode.NONE;

    public static boolean isSnappingEnabled() {
        return (Boolean)snapping.get();
    }

    public static void toggleSnapping() {
        snapping.toggle();
    }

    public HudEditScreen() {
        this(null);
    }

    public HudEditScreen(C_3020744 parent) {
        this.updateSnapState();
        this.mouseDown = false;
        this.parent = parent;
    }

    private void updateSnapState() {
        if (((Boolean)snapping.get()).booleanValue() && this.current != null) {
            List bounds = HudManager.getInstance().getAllBounds();
            bounds.remove(this.current.getTrueBounds());
            this.snap = new SnappingHelper(bounds, this.current.getTrueBounds());
        } else if (this.snap != null) {
            this.snap = null;
        }
    }

    private void setCursor(long cursor) {
        if (cursor > 0L && cursor != this.currentCursor) {
            this.currentCursor = cursor;
            WindowAccess.getInstance().setCursor(cursor);
        }
    }

    public void m_7261014(int mouseX, int mouseY, float delta) {
        Optional<HudEntry> entry;
        if (C_8105098.m_0408063().f_4601986 != null) {
            this.m_9889399(0, 0, this.f_5465691, this.f_3080061, -1341125106, 1176576032);
        } else {
            this.m_4184721(0);
        }
        super.m_7261014(mouseX, mouseY, delta);
        C_3754158.m_7547086();
        if (this.current != null && this.mode != ModificationMode.NONE) {
            this.current.setHovered(true);
            entry = Optional.of(this.current);
        } else {
            entry = HudManager.getInstance().getEntryXY(mouseX, mouseY);
            entry.ifPresent(abstractHudEntry -> abstractHudEntry.setHovered(true));
        }
        HudManager.getInstance().renderPlaceholder(AxoRenderContextImpl.getInstance(), delta);
        if (entry.isPresent()) {
            Rectangle bounds = entry.get().getTrueBounds();
            if (this.mode == ModificationMode.NONE && bounds.isMouseOver((double)mouseX, (double)mouseY)) {
                boolean supportsScaling = entry.get().supportsScaling();
                int xBound = Math.max(0, mouseX - bounds.x());
                int yBound = Math.max(0, mouseY - bounds.y());
                int tolerance = 5;
                if (supportsScaling && xBound < tolerance && yBound < tolerance) {
                    this.setCursor(this.NWSE_RESIZE_CURSOR);
                } else if (supportsScaling && Math.abs(xBound - bounds.width()) < tolerance && Math.abs(yBound - bounds.height()) < tolerance) {
                    this.setCursor(this.NWSE_RESIZE_CURSOR);
                } else if (supportsScaling && xBound < tolerance && Math.abs(yBound - bounds.height()) < tolerance) {
                    this.setCursor(this.NESW_RESIZE_CURSOR);
                } else if (supportsScaling && yBound < tolerance && Math.abs(xBound - bounds.width()) < tolerance) {
                    this.setCursor(this.NESW_RESIZE_CURSOR);
                } else {
                    this.setCursor(this.MOVE_CURSOR);
                }
            }
        } else if (this.current == null) {
            this.setCursor(this.DEFAULT_CURSOR);
            this.mode = ModificationMode.NONE;
        }
        if (this.mouseDown && this.snap != null) {
            this.snap.renderSnaps();
        }
    }

    public void m_7362766(int mouseX, int mouseY, int button) {
        super.m_7362766(mouseX, mouseY, button);
        Optional entry = HudManager.getInstance().getEntryXY(mouseX, mouseY);
        if (button == 0) {
            this.mouseDown = true;
            if (entry.isPresent()) {
                this.current = (HudEntry)entry.get();
                this.offset = new DrawPosition(mouseX - this.current.getTruePos().x(), mouseY - this.current.getTruePos().y());
                Rectangle bounds = ((HudEntry)entry.get()).getTrueBounds();
                int xBound = Math.max(0, mouseX - bounds.x());
                int yBound = Math.max(0, mouseY - bounds.y());
                if (this.currentCursor == this.NWSE_RESIZE_CURSOR) {
                    if (xBound < bounds.width() / 2 && yBound < bounds.height() / 2) {
                        this.mode = ModificationMode.TOP_LEFT;
                    } else if (xBound - bounds.width() / 2 > 0 && yBound - bounds.height() / 2 > 0) {
                        this.mode = ModificationMode.BOTTOM_RIGHT;
                    }
                } else if (this.currentCursor == this.NESW_RESIZE_CURSOR) {
                    if (xBound < bounds.width() / 2 && yBound - bounds.height() / 2 > 0) {
                        this.mode = ModificationMode.BOTTOM_LEFT;
                    } else if (xBound - bounds.width() / 2 > 0 && yBound < bounds.height() / 2) {
                        this.mode = ModificationMode.TOP_RIGHT;
                    }
                } else if (this.currentCursor == this.MOVE_CURSOR) {
                    this.updateSnapState();
                    this.mode = ModificationMode.MOVE;
                }
            } else {
                this.mode = ModificationMode.NONE;
                this.current = null;
            }
        } else if (button == 1) {
            entry.ifPresent(hudEntry -> {
                C_3020744 screen = ConfigStyles.createScreen((C_3020744)this, (OptionCategory)hudEntry.getCategory());
                this.mode = ModificationMode.NONE;
                this.setCursor(this.DEFAULT_CURSOR);
                C_8105098.m_0408063().m_6408915(screen);
            });
        }
    }

    public void m_5308748(int mouseX, int mouseY, int button) {
        if (this.current != null) {
            AxolotlClientConfig.getInstance().getConfigManager(this.current.getCategory()).save();
        }
        this.current = null;
        this.snap = null;
        this.mouseDown = false;
        this.mode = ModificationMode.NONE;
        this.setCursor(this.DEFAULT_CURSOR);
        super.m_5308748(mouseX, mouseY, button);
    }

    protected void m_5535405(int mouseX, int mouseY, int button, long mouseLastClicked) {
        if (this.current != null) {
            if (this.mode == ModificationMode.MOVE) {
                this.current.setX(mouseX - this.offset.x() + this.current.offsetTrueWidth());
                this.current.setY(mouseY - this.offset.y() + this.current.offsetTrueHeight());
                if (this.snap != null) {
                    Integer snapY;
                    this.snap.setCurrent(this.current.getTrueBounds());
                    Integer snapX = this.snap.getCurrentXSnap();
                    if (snapX != null) {
                        this.current.setX(snapX + this.current.offsetTrueWidth());
                    }
                    if ((snapY = this.snap.getCurrentYSnap()) != null) {
                        this.current.setY(snapY + this.current.offsetTrueHeight());
                    }
                }
            } else {
                int newHeight;
                int newWidth;
                Rectangle bounds = this.current.getTrueBounds();
                if (this.mode == ModificationMode.TOP_LEFT) {
                    newWidth = mouseX - bounds.xEnd();
                    newHeight = mouseY - bounds.yEnd();
                } else if (this.mode == ModificationMode.BOTTOM_LEFT) {
                    newWidth = mouseX - bounds.xEnd();
                    newHeight = mouseY - bounds.y();
                } else if (this.mode == ModificationMode.TOP_RIGHT) {
                    newWidth = mouseX - bounds.x();
                    newHeight = mouseY - bounds.yEnd();
                } else if (this.mode == ModificationMode.BOTTOM_RIGHT) {
                    newWidth = mouseX - bounds.x();
                    newHeight = mouseY - bounds.y();
                } else {
                    newWidth = bounds.width();
                    newHeight = bounds.height();
                }
                float newScale = this.current.getScale() * Math.max((float)Math.abs(newWidth) / (float)bounds.width(), (float)Math.abs(newHeight) / (float)bounds.height());
                this.current.setScale(Math.max(0.1f, newScale));
                if (this.mode == ModificationMode.TOP_LEFT) {
                    this.current.setX(bounds.xEnd() - this.current.getTrueWidth());
                    this.current.setY(bounds.yEnd() - this.current.getTrueHeight());
                } else if (this.mode == ModificationMode.BOTTOM_LEFT) {
                    this.current.setX(bounds.xEnd() - this.current.getTrueWidth());
                } else if (this.mode == ModificationMode.TOP_RIGHT) {
                    this.current.setY(bounds.yEnd() - this.current.getTrueHeight());
                }
            }
            if (this.current.tickable()) {
                this.current.tick();
            }
        }
    }

    public void m_8984281() {
        super.m_8984281();
        this.setCursor(this.DEFAULT_CURSOR);
        this.mode = ModificationMode.NONE;
        WindowAccess.getInstance().destroyStandardCursor(this.DEFAULT_CURSOR, this.NWSE_RESIZE_CURSOR, this.NESW_RESIZE_CURSOR, this.MOVE_CURSOR);
    }

    protected void m_7971793(C_2348249 button) {
        switch (button.f_5920996) {
            case 3: {
                snapping.toggle();
                button.f_4865617 = C_3390001.m_2053009((String)"hud.snapping", (Object[])new Object[0]) + ": " + C_3390001.m_2053009((String)((Boolean)snapping.get() != false ? "options.on" : "options.off"), (Object[])new Object[0]);
                AxolotlClient.getInstance().getConfigManager().save();
                break;
            }
            case 1: {
                C_3020744 screen = ConfigStyles.createScreen((C_3020744)this, (OptionCategory)AxolotlClient.getInstance().getConfigManager().getRoot());
                C_8105098.m_0408063().m_6408915(screen);
                break;
            }
            case 0: {
                C_8105098.m_0408063().m_6408915(this.parent);
                break;
            }
            case 2: {
                C_8105098.m_0408063().m_6408915(null);
            }
        }
    }

    public void m_3593494() {
        this.mode = ModificationMode.NONE;
        this.f_2213969.add(new C_2348249(3, this.f_5465691 / 2 - 50, this.f_3080061 / 2 + 12, 100, 20, C_3390001.m_2053009((String)"hud.snapping", (Object[])new Object[0]) + ": " + C_3390001.m_2053009((String)((Boolean)snapping.get() != false ? "options.on" : "options.off"), (Object[])new Object[0])));
        this.f_2213969.add(new C_2348249(1, this.f_5465691 / 2 - 75, this.f_3080061 / 2 - 10, 150, 20, C_3390001.m_2053009((String)"hud.clientOptions", (Object[])new Object[0])));
        if (this.parent != null) {
            this.f_2213969.add(new C_2348249(0, this.f_5465691 / 2 - 75, this.f_3080061 - 50 + 22, 150, 20, C_3390001.m_2053009((String)"back", (Object[])new Object[0])));
        } else {
            this.f_2213969.add(new C_2348249(2, this.f_5465691 / 2 - 75, this.f_3080061 - 50 + 22, 150, 20, C_3390001.m_2053009((String)"close", (Object[])new Object[0])));
        }
    }

    static {
        hudEditScreenCategory.add(new Option[]{snapping});
        AxolotlClient.config().hidden.add(new OptionCategory[]{hudEditScreenCategory});
    }

    private static enum ModificationMode {
        NONE,
        MOVE,
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;

    }
}

