/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.hud.gui.hud;

import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.AxolotlClientCommon;
import io.github.axolotlclient.AxolotlClientConfig.api.options.Option;
import io.github.axolotlclient.AxolotlClientConfig.api.util.Color;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.ColorOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.IntegerOption;
import io.github.axolotlclient.bridge.render.AxoRenderContext;
import io.github.axolotlclient.config.profiles.ProfileAware;
import io.github.axolotlclient.mixin.KeyBindAccessor;
import io.github.axolotlclient.modules.hud.ClickInputTracker;
import io.github.axolotlclient.modules.hud.gui.entry.TextHudEntry;
import io.github.axolotlclient.modules.hud.gui.keystrokes.KeystrokePositioningScreen;
import io.github.axolotlclient.modules.hud.gui.keystrokes.KeystrokesScreen;
import io.github.axolotlclient.modules.hud.gui.layout.Justification;
import io.github.axolotlclient.modules.hud.util.DrawPosition;
import io.github.axolotlclient.modules.hud.util.DrawUtil;
import io.github.axolotlclient.modules.hud.util.Rectangle;
import io.github.axolotlclient.util.ClientColors;
import io.github.axolotlclient.util.GsonHelper;
import io.github.axolotlclient.util.Util;
import io.github.axolotlclient.util.events.Events;
import io.github.axolotlclient.util.options.GenericOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import net.minecraft.unmapped.C_0561170;
import net.minecraft.unmapped.C_1331819;
import net.minecraft.unmapped.C_1945050;
import net.minecraft.unmapped.C_3020744;
import net.minecraft.unmapped.C_3390001;
import net.minecraft.unmapped.C_3754158;
import net.minecraft.unmapped.C_4976084;
import net.minecraft.unmapped.C_7778778;
import net.minecraft.unmapped.C_8105098;

public class KeystrokeHud
extends TextHudEntry
implements ProfileAware {
    private static final String KEYSTROKE_SAVE_FILE_NAME = "keystrokes.json";
    public static final C_0561170 ID = new C_0561170("kronhud", "keystrokehud");
    private final ColorOption pressedTextColor = new ColorOption("heldtextcolor", new Color(-16777216));
    private final ColorOption pressedBackgroundColor = new ColorOption("heldbackgroundcolor", new Color(0x64FFFFFF));
    private final ColorOption pressedOutlineColor = new ColorOption("heldoutlinecolor", ClientColors.BLACK);
    private final C_8105098 client;
    private final GenericOption keystrokesOption;
    private final GenericOption configurePositions;
    private final IntegerOption animationTime;
    public ArrayList<Keystroke> keystrokes;

    public KeystrokeHud() {
        super(53, 61, true);
        this.client = (C_8105098)((TextHudEntry)this).client;
        this.keystrokesOption = new GenericOption("keystrokes", "keystrokes.configure", () -> this.client.m_6408915((C_3020744)new KeystrokesScreen(this, this.client.f_0723335)));
        this.configurePositions = new GenericOption("keystrokes.positions", "keystrokes.positions.configure", () -> this.client.m_6408915((C_3020744)new KeystrokePositioningScreen(this.client.f_0723335, this)));
        this.animationTime = new IntegerOption("keystrokes.animation_time", Integer.valueOf(100), Integer.valueOf(0), Integer.valueOf(500));
        Events.KEYBIND_CHANGE.register(key -> {
            if (Util.getWindow() != null) {
                C_7778778.m_7336979();
                C_7778778.m_8884824();
            }
        });
    }

    public Optional<String> getMouseKeyBindName(C_7778778 keyBinding) {
        if (keyBinding.m_4400998().equalsIgnoreCase(this.client.f_9967940.f_3307271.m_4400998())) {
            return Optional.of("LMB");
        }
        if (keyBinding.m_4400998().equalsIgnoreCase(this.client.f_9967940.f_1707488.m_4400998())) {
            return Optional.of("RMB");
        }
        if (keyBinding.m_4400998().equalsIgnoreCase(this.client.f_9967940.f_1435335.m_4400998())) {
            return Optional.of("MMB");
        }
        return Optional.empty();
    }

    public void setDefaultKeystrokes() {
        DrawPosition pos = this.getContentPos();
        this.keystrokes.add(this.createFromKey(new Rectangle(0, 36, 26, 17), pos, this.client.f_9967940.f_3307271));
        this.keystrokes.add(this.createFromKey(new Rectangle(27, 36, 26, 17), pos, this.client.f_9967940.f_1707488));
        this.keystrokes.add(this.createFromKey(new Rectangle(18, 0, 17, 17), pos, this.client.f_9967940.f_9911664));
        this.keystrokes.add(this.createFromKey(new Rectangle(0, 18, 17, 17), pos, this.client.f_9967940.f_7947370));
        this.keystrokes.add(this.createFromKey(new Rectangle(18, 18, 17, 17), pos, this.client.f_9967940.f_6279366));
        this.keystrokes.add(this.createFromKey(new Rectangle(36, 18, 17, 17), pos, this.client.f_9967940.f_2763889));
        this.keystrokes.add(new CustomRenderKeystroke(SpecialKeystroke.SPACE));
    }

    public void setKeystrokes() {
        if (Util.getWindow() == null) {
            this.keystrokes = null;
            return;
        }
        this.keystrokes = new ArrayList();
        this.setDefaultKeystrokes();
        this.loadKeystrokes();
        C_7778778.m_7336979();
        C_7778778.m_8884824();
    }

    public Keystroke createFromKey(Rectangle bounds, DrawPosition offset, C_7778778 key) {
        String name = this.getMouseKeyBindName(key).orElse(C_1331819.m_9293214((int)key.m_6463487()).toUpperCase());
        if (name.length() > 4) {
            name = name.substring(0, 2);
        }
        return this.createFromString(bounds, offset, key, name);
    }

    public Keystroke createFromString(Rectangle bounds, DrawPosition offset, C_7778778 key, String word) {
        return new LabelKeystroke(bounds, offset, key, word);
    }

    public void render(AxoRenderContext context, float delta) {
        C_3754158.m_8373640();
        this.scale(context);
        this.renderComponent(context, delta);
        C_3754158.m_2041265();
    }

    public void renderComponent(AxoRenderContext context, float delta) {
        if (this.keystrokes == null) {
            this.setKeystrokes();
        }
        for (Keystroke stroke : this.keystrokes) {
            stroke.render(context);
        }
    }

    public void renderPlaceholderComponent(AxoRenderContext context, float delta) {
        this.renderComponent(context, delta);
    }

    public boolean tickable() {
        return true;
    }

    public void tick() {
        DrawPosition pos = this.getContentPos();
        if (this.keystrokes == null) {
            this.setKeystrokes();
        }
        for (Keystroke stroke : this.keystrokes) {
            stroke.offset = pos;
        }
    }

    protected boolean getShadowDefault() {
        return false;
    }

    public List<Option<?>> getConfigurationOptions() {
        ArrayList options = new ArrayList();
        options.add((Option<?>)this.enabled);
        options.add((Option<?>)this.scale);
        options.add((Option<?>)this.anchor);
        options.add((Option<?>)this.textColor);
        options.add((Option<?>)this.pressedTextColor);
        options.add((Option<?>)this.shadow);
        options.add((Option<?>)this.background);
        options.add((Option<?>)this.backgroundColor);
        options.add((Option<?>)this.pressedBackgroundColor);
        options.add((Option<?>)this.outline);
        options.add((Option<?>)this.outlineColor);
        options.add((Option<?>)this.pressedOutlineColor);
        options.add((Option<?>)this.roundBackground);
        options.add((Option<?>)this.backgroundRounding);
        options.add((Option<?>)this.animationTime);
        options.add((Option<?>)this.keystrokesOption);
        options.add((Option<?>)this.configurePositions);
        return options;
    }

    public C_0561170 getId() {
        return ID;
    }

    public void reloadConfig() {
        this.keystrokes = null;
    }

    public void saveConfig() {
        this.saveKeystrokes();
    }

    private Keystroke deserializeKey(Map<String, Object> json) {
        if ("option".equals(json.get("type"))) {
            C_7778778 key = KeyBindAccessor.getAllKeyBinds().stream().filter(k -> k.m_4400998().equals(json.getOrDefault("key_name", json.get("option")))).findFirst().orElseThrow();
            return new CustomRenderKeystroke(SpecialKeystroke.byId.get(((String)json.get("special_name")).toLowerCase(Locale.ROOT)), KeystrokeHud.getRectangle((Map)json.get("bounds")), this.getContentPos(), key);
        }
        C_7778778 key = KeyBindAccessor.getAllKeyBinds().stream().filter(k -> k.m_4400998().equals(json.get("key_name"))).findFirst().orElseThrow();
        return new LabelKeystroke(KeystrokeHud.getRectangle((Map)json.get("bounds")), this.getContentPos(), key, (String)json.get("label"), (Boolean)json.get("synchronize_label"), Justification.valueOf((String)((String)json.getOrDefault("justification", "CENTER"))));
    }

    private static Rectangle getRectangle(Map<String, ?> json) {
        return new Rectangle((int)((Long)json.get("x")).longValue(), (int)((Long)json.get("y")).longValue(), (int)((Long)json.get("width")).longValue(), (int)((Long)json.get("height")).longValue());
    }

    public Keystroke newSpecialStroke(SpecialKeystroke stroke) {
        return new CustomRenderKeystroke(stroke);
    }

    public LabelKeystroke newStroke() {
        return new LabelKeystroke(new Rectangle(0, 0, 17, 17), this.getContentPos(), null, "", false, Justification.CENTER);
    }

    public void saveKeystrokes() {
        if (this.keystrokes == null) {
            return;
        }
        try {
            Path path = AxolotlClientCommon.resolveProfileConfigFile((String)KEYSTROKE_SAVE_FILE_NAME);
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.writeString(path, (CharSequence)GsonHelper.GSON.toJson(this.keystrokes.stream().map(Keystroke::serialize).toList()), new OpenOption[0]);
        }
        catch (Exception e) {
            AxolotlClient.LOGGER.warn("Failed to save keystroke configuration!", new Object[]{e});
        }
    }

    public void loadKeystrokes() {
        try {
            Path path = AxolotlClientCommon.resolveProfileConfigFile((String)KEYSTROKE_SAVE_FILE_NAME);
            if (Files.exists(path, new LinkOption[0])) {
                List entries = (List)GsonHelper.read((String)Files.readString(path));
                List<Keystroke> loaded = entries.stream().map(e -> (Map)e).map(this::deserializeKey).toList();
                if (this.keystrokes == null) {
                    this.keystrokes = new ArrayList();
                } else {
                    this.keystrokes.clear();
                }
                this.keystrokes.addAll(loaded);
            } else {
                this.saveKeystrokes();
            }
        }
        catch (Exception e2) {
            AxolotlClient.LOGGER.warn("Failed to load keystroke configuration, using defaults!", new Object[]{e2});
        }
    }

    public abstract class Keystroke {
        protected C_7778778 key;
        protected KeystrokeRenderer render;
        protected final Rectangle bounds;
        protected DrawPosition offset;
        private long start = -1L;
        private boolean wasPressed = false;

        public Keystroke(Rectangle bounds, DrawPosition offset, C_7778778 key, KeystrokeRenderer render) {
            this.bounds = bounds;
            this.offset = offset;
            this.key = key;
            this.render = render;
        }

        public void setX(int x) {
            this.bounds.x(x - this.offset.x());
        }

        public void setY(int y) {
            this.bounds.y(y - this.offset.y());
        }

        public Rectangle getRenderPosition() {
            return this.bounds.offset(this.offset);
        }

        public Color getFGColor() {
            return this.isKeyDown() ? ClientColors.blend((Color)KeystrokeHud.this.textColor.get(), (Color)KeystrokeHud.this.pressedTextColor.get(), (float)this.getPercentPressed()) : ClientColors.blend((Color)KeystrokeHud.this.pressedTextColor.get(), (Color)KeystrokeHud.this.textColor.get(), (float)this.getPercentPressed());
        }

        private float getPercentPressed() {
            return this.start == -1L ? 1.0f : C_4976084.m_7164829((float)((float)(System.currentTimeMillis() - this.start) / (float)this.getAnimTime()), (float)0.0f, (float)1.0f);
        }

        public void render(AxoRenderContext ctx) {
            this.renderStroke(ctx);
            this.render.render(this);
        }

        public void renderStroke(AxoRenderContext matrices) {
            if (this.isKeyDown() != this.wasPressed) {
                this.start = System.currentTimeMillis();
            }
            Rectangle rect = this.getRenderPosition();
            if (((Boolean)KeystrokeHud.this.background.get()).booleanValue()) {
                if (((Boolean)KeystrokeHud.this.roundBackground.get()).booleanValue()) {
                    matrices.br$fillRectRound(rect, this.getColor(), Math.min((float)Math.min(rect.height(), rect.width()) / 2.0f, (float)((Integer)KeystrokeHud.this.backgroundRounding.get()).intValue()));
                } else {
                    matrices.br$fillRect(rect, this.getColor());
                }
            }
            if (((Boolean)KeystrokeHud.this.outline.get()).booleanValue()) {
                if (((Boolean)KeystrokeHud.this.roundBackground.get()).booleanValue()) {
                    matrices.br$outlineRectRound(rect, this.getOutlineColor(), Math.min((float)Math.min(rect.height(), rect.width()) / 2.0f, (float)((Integer)KeystrokeHud.this.backgroundRounding.get()).intValue()));
                } else {
                    matrices.br$outlineRect(rect, this.getOutlineColor());
                }
            }
            if ((float)(System.currentTimeMillis() - this.start) / (float)this.getAnimTime() >= 1.0f) {
                this.start = -1L;
            }
            this.wasPressed = this.isKeyDown();
        }

        private int getAnimTime() {
            return (Integer)KeystrokeHud.this.animationTime.get();
        }

        private boolean isKeyDown() {
            return this.key != null && this.key.m_7042641();
        }

        public Color getColor() {
            return this.isKeyDown() ? ClientColors.blend((Color)KeystrokeHud.this.backgroundColor.get(), (Color)KeystrokeHud.this.pressedBackgroundColor.get(), (float)this.getPercentPressed()) : ClientColors.blend((Color)KeystrokeHud.this.pressedBackgroundColor.get(), (Color)KeystrokeHud.this.backgroundColor.get(), (float)this.getPercentPressed());
        }

        public Color getOutlineColor() {
            return this.isKeyDown() ? ClientColors.blend((Color)KeystrokeHud.this.outlineColor.get(), (Color)KeystrokeHud.this.pressedOutlineColor.get(), (float)this.getPercentPressed()) : ClientColors.blend((Color)KeystrokeHud.this.pressedOutlineColor.get(), (Color)KeystrokeHud.this.outlineColor.get(), (float)this.getPercentPressed());
        }

        public Map<String, Object> serialize() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("key", this.key.m_6463487());
            map.put("bounds", Map.of("x", this.bounds.x(), "y", this.bounds.y(), "width", this.bounds.width(), "height", this.bounds.height()));
            return map;
        }

        public abstract String getLabel();

        public abstract void setLabel(String var1);

        public abstract boolean isLabelEditable();

        @Generated
        public C_7778778 getKey() {
            return this.key;
        }

        @Generated
        public void setKey(C_7778778 key) {
            this.key = key;
        }

        @Generated
        public Rectangle getBounds() {
            return this.bounds;
        }
    }

    public class CustomRenderKeystroke
    extends Keystroke {
        private static final Supplier<String> label = () -> String.valueOf(C_1945050.f_8012292) + C_3390001.m_2053009((String)"keystrokes.stroke.custom_renderer", (Object[])new Object[0]);
        private final SpecialKeystroke parent;

        public CustomRenderKeystroke(SpecialKeystroke stroke, Rectangle bounds, DrawPosition offset, C_7778778 key) {
            super(bounds, offset, key, (Keystroke s) -> stroke.getRenderer().render(KeystrokeHud.this, s));
            this.parent = stroke;
        }

        public CustomRenderKeystroke(SpecialKeystroke stroke) {
            this(stroke, stroke.getRect().copy(), this$0.getContentPos(), stroke.getKey());
        }

        @Override
        public Map<String, Object> serialize() {
            Map<String, Object> json = super.serialize();
            json.put("type", "option");
            json.put("key_name", this.key.m_4400998());
            json.put("special_name", this.parent.getId());
            return json;
        }

        @Override
        public String getLabel() {
            return label.get();
        }

        @Override
        public void setLabel(String label) {
        }

        @Override
        public boolean isLabelEditable() {
            return false;
        }
    }

    public static enum SpecialKeystroke {
        SPACE("space", new Rectangle(0, 54, 53, 7), C_8105098.m_0408063().f_9967940.f_2128824, (hud, stroke) -> {
            Rectangle bounds = stroke.bounds;
            Rectangle spaceBounds = new Rectangle(bounds.x() + stroke.offset.x() + 4, bounds.y() + stroke.offset.y() + bounds.height() / 2 - 1, bounds.width() - 8, 1);
            DrawUtil.fillRect(spaceBounds, stroke.getFGColor());
            if (((Boolean)hud.shadow.get()).booleanValue()) {
                DrawUtil.fillRect(spaceBounds.offset(1, 1), new Color((stroke.getFGColor().toInt() & 0xFCFCFC) >> 2 | stroke.getFGColor().toInt() & 0xFF000000));
            }
        }),
        LMB_CPS("lmb_cps", new Rectangle(0, 36, 26, 17), C_8105098.m_0408063().f_9967940.f_3307271, (hud, stroke) -> {
            Rectangle bounds = stroke.bounds;
            int centerX = bounds.x() + stroke.offset.x() + bounds.width() / 2;
            int y = bounds.y() + stroke.offset.y() + 3;
            int nameY = y + bounds.height() / 4 - hud.client.f_0426313.f_6725889 / 2;
            DrawUtil.drawCenteredString(hud.client.f_0426313, "LMB", centerX, nameY, stroke.getFGColor(), (boolean)((Boolean)hud.shadow.get()));
            int cpsY = y + bounds.height() * 3 / 4 - hud.client.f_0426313.f_6725889 / 2;
            C_3754158.m_8373640();
            C_3754158.m_3172490((float)centerX, (float)cpsY, (float)0.0f);
            C_3754158.m_4552250((float)0.5f, (float)0.5f, (float)1.0f);
            String cpsText = ClickInputTracker.getInstance().leftMouse.clicks() + " CPS";
            C_3754158.m_3172490((float)((float)(-hud.client.f_0426313.m_0040387(cpsText)) / 2.0f), (float)0.0f, (float)0.0f);
            DrawUtil.drawString(cpsText, 0.0f, 0.0f, stroke.getFGColor(), (boolean)((Boolean)hud.shadow.get()));
            C_3754158.m_2041265();
        }),
        RMB_CPS("rmb_cps", new Rectangle(27, 36, 26, 17), C_8105098.m_0408063().f_9967940.f_1707488, (hud, stroke) -> {
            Rectangle bounds = stroke.bounds;
            int centerX = bounds.x() + stroke.offset.x() + bounds.width() / 2;
            int y = bounds.y() + stroke.offset.y() + 3;
            int nameY = y + bounds.height() / 4 - hud.client.f_0426313.f_6725889 / 2;
            DrawUtil.drawCenteredString(hud.client.f_0426313, "RMB", centerX, nameY, stroke.getFGColor(), (boolean)((Boolean)hud.shadow.get()));
            int cpsY = y + bounds.height() * 3 / 4 - hud.client.f_0426313.f_6725889 / 2;
            C_3754158.m_8373640();
            C_3754158.m_3172490((float)centerX, (float)cpsY, (float)0.0f);
            C_3754158.m_4552250((float)0.5f, (float)0.5f, (float)1.0f);
            String cpsText = ClickInputTracker.getInstance().rightMouse.clicks() + " CPS";
            C_3754158.m_3172490((float)((float)(-hud.client.f_0426313.m_0040387(cpsText)) / 2.0f), (float)0.0f, (float)0.0f);
            DrawUtil.drawString(cpsText, 0.0f, 0.0f, stroke.getFGColor(), (boolean)((Boolean)hud.shadow.get()));
            C_3754158.m_2041265();
        });

        private static final Map<String, SpecialKeystroke> byId;
        private final String id;
        private final Rectangle rect;
        private final C_7778778 key;
        private final SpecialKeystrokeRenderer renderer;

        @Generated
        private SpecialKeystroke(String id, Rectangle rect, C_7778778 key, SpecialKeystrokeRenderer renderer) {
            this.id = id;
            this.rect = rect;
            this.key = key;
            this.renderer = renderer;
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public Rectangle getRect() {
            return this.rect;
        }

        @Generated
        public C_7778778 getKey() {
            return this.key;
        }

        @Generated
        public SpecialKeystrokeRenderer getRenderer() {
            return this.renderer;
        }

        static {
            byId = Arrays.stream(SpecialKeystroke.values()).collect(Collectors.toMap(SpecialKeystroke::getId, Function.identity()));
        }

        public static interface SpecialKeystrokeRenderer {
            public void render(KeystrokeHud var1, Keystroke var2);
        }
    }

    public class LabelKeystroke
    extends Keystroke {
        private String label;
        private boolean synchronizeLabel;
        private Justification justification;

        public LabelKeystroke(Rectangle bounds, DrawPosition offset, C_7778778 key, String label) {
            this(bounds, offset, key, label, true, Justification.CENTER);
        }

        public LabelKeystroke(Rectangle bounds, DrawPosition offset, C_7778778 key, String label, boolean synchronizeLabel, Justification justification) {
            super(bounds, offset, key, (Keystroke stroke) -> {});
            this.label = label;
            this.render = stroke -> {
                Rectangle strokeBounds = stroke.bounds;
                int x = strokeBounds.x() + stroke.offset.x() + 2 + this.justification.getXOffset(this.getLabel(), strokeBounds.width() - 3);
                float y = (float)(strokeBounds.y() + stroke.offset.y()) + (float)strokeBounds.height() / 2.0f - 4.0f;
                DrawUtil.drawString(this.getLabel(), (float)x, (float)((int)y), stroke.getFGColor().toInt(), (boolean)((Boolean)KeystrokeHud.this.shadow.get()));
            };
            this.setSynchronizeLabel(synchronizeLabel);
            this.justification = justification;
        }

        @Override
        public Map<String, Object> serialize() {
            Map<String, Object> json = super.serialize();
            json.put("type", "custom");
            json.put("key_name", this.key.m_4400998());
            json.put("label", this.label);
            json.put("synchronize_label", this.synchronizeLabel);
            json.put("justification", this.justification.name());
            return json;
        }

        public void setSynchronizeLabel(boolean synchronizeLabel) {
            if (synchronizeLabel) {
                String name = KeystrokeHud.this.getMouseKeyBindName(this.key).orElse(C_1331819.m_9293214((int)this.key.m_6463487()).toUpperCase());
                if (name.length() > 4) {
                    name = name.substring(0, 2);
                }
                this.label = name;
            }
            this.synchronizeLabel = synchronizeLabel;
        }

        @Override
        public void setKey(C_7778778 key) {
            if (this.synchronizeLabel) {
                String name = KeystrokeHud.this.getMouseKeyBindName(key).orElse(C_1331819.m_9293214((int)key.m_6463487()).toUpperCase());
                if (name.length() > 4) {
                    name = name.substring(0, 2);
                }
                this.label = name;
            }
            super.setKey(key);
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        public boolean isLabelEditable() {
            return true;
        }

        @Override
        @Generated
        public void setLabel(String label) {
            this.label = label;
        }

        @Generated
        public void setJustification(Justification justification) {
            this.justification = justification;
        }

        @Generated
        public boolean isSynchronizeLabel() {
            return this.synchronizeLabel;
        }

        @Generated
        public Justification getJustification() {
            return this.justification;
        }
    }

    public static interface KeystrokeRenderer {
        public void render(Keystroke var1);
    }
}

