/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.hud.gui.hud.vanilla;

import io.github.axolotlclient.AxolotlClientConfig.api.options.Option;
import io.github.axolotlclient.AxolotlClientConfig.api.util.Color;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.BooleanOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.ColorOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.EnumOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.GraphicsOption;
import io.github.axolotlclient.bridge.render.AxoRenderContext;
import io.github.axolotlclient.bridge.util.AxoIdentifier;
import io.github.axolotlclient.modules.hud.gui.component.DynamicallyPositionable;
import io.github.axolotlclient.modules.hud.gui.entry.AbstractHudEntry;
import io.github.axolotlclient.modules.hud.gui.layout.AnchorPoint;
import io.github.axolotlclient.modules.hud.util.DrawUtil;
import io.github.axolotlclient.modules.hud.util.RenderUtil;
import io.github.axolotlclient.util.ClientColors;
import io.github.axolotlclient.util.Util;
import java.util.List;
import net.minecraft.unmapped.C_2691939;
import net.minecraft.unmapped.C_3674802;
import net.minecraft.unmapped.C_3754158;
import net.minecraft.unmapped.C_4018501;
import net.minecraft.unmapped.C_7650729;
import net.minecraft.unmapped.C_7794883;
import net.minecraft.unmapped.C_7873567;
import net.minecraft.unmapped.C_8105098;
import net.minecraft.unmapped.C_8931049;

public class CrosshairHud
extends AbstractHudEntry
implements DynamicallyPositionable {
    public static final AxoIdentifier ID = AxoIdentifier.of((String)"kronhud", (String)"crosshairhud");
    private final EnumOption<Crosshair> type = new EnumOption("crosshair_type", Crosshair.class, (Object)Crosshair.CROSS);
    private final BooleanOption showInF5 = new BooleanOption("showInF5", Boolean.valueOf(false));
    private final BooleanOption applyBlend = new BooleanOption("applyBlend", Boolean.valueOf(true));
    private final BooleanOption overrideF3 = new BooleanOption("overrideF3", Boolean.valueOf(false));
    private final ColorOption defaultColor = new ColorOption("defaultcolor", ClientColors.WHITE);
    private final ColorOption entityColor = new ColorOption("entitycolor", ClientColors.SELECTOR_RED);
    private final ColorOption containerColor = new ColorOption("blockcolor", ClientColors.SELECTOR_BLUE);
    private final GraphicsOption customTextureGraphics = new GraphicsOption("customTextureGraphics", (int[][])new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}});
    private final C_8105098 client;

    public CrosshairHud() {
        super(15, 15);
        this.client = (C_8105098)((AbstractHudEntry)this).client;
    }

    public AxoIdentifier getId() {
        return ID;
    }

    public boolean movable() {
        return false;
    }

    public List<Option<?>> getConfigurationOptions() {
        List options = super.getConfigurationOptions();
        options.add(this.hide);
        options.add(this.type);
        options.add(this.customTextureGraphics);
        options.add(this.showInF5);
        options.add(this.overrideF3);
        options.add(this.applyBlend);
        options.add(this.defaultColor);
        options.add(this.entityColor);
        options.add(this.containerColor);
        return options;
    }

    public boolean overridesF3() {
        return (Boolean)this.overrideF3.get();
    }

    public double getDefaultX() {
        return 0.5;
    }

    public double getDefaultY() {
        return 0.5;
    }

    public void render(AxoRenderContext context, float delta) {
        if (this.client.f_9967940.f_3094045 != 0 && !((Boolean)this.showInF5.get()).booleanValue()) {
            return;
        }
        C_3754158.m_2754767();
        C_3754158.m_8373640();
        this.scale(context);
        Color color = this.getColor();
        C_3754158.m_3323122((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)1.0f);
        if (color == this.defaultColor.get() && ((Boolean)this.applyBlend.get()).booleanValue()) {
            C_3754158.m_9671730();
            C_3754158.m_0833259((int)775, (int)769, (int)1, (int)0);
        }
        int x = this.getPos().x;
        int y = this.getPos().y + 1;
        if (((Crosshair)((Object)this.type.get())).equals((Object)Crosshair.DOT)) {
            RenderUtil.fillBlend(x + this.width / 2 - 1, y + this.height / 2 - 2, 3, 3, color);
        } else if (((Crosshair)((Object)this.type.get())).equals((Object)Crosshair.CROSS)) {
            RenderUtil.fillBlend(x + this.width / 2 - 5, y + this.height / 2 - 1, 6, 1, color);
            RenderUtil.fillBlend(x + this.width / 2 + 1, y + this.height / 2 - 1, 5, 1, color);
            RenderUtil.fillBlend(x + this.width / 2, y + this.height / 2 - 6, 1, 5, color);
            RenderUtil.fillBlend(x + this.width / 2, y + this.height / 2, 1, 5, color);
        } else if (((Crosshair)((Object)this.type.get())).equals((Object)Crosshair.TEXTURE)) {
            C_8105098.m_0408063().m_1218956().m_5325521(C_2691939.f_7113512);
            this.client.f_3501374.m_4354119((int)((Util.getWindow().m_3624537() / (double)this.getScale() - 14.0) / 2.0), (int)((Util.getWindow().m_6423725() / (double)this.getScale() - 14.0) / 2.0), 0, 0, 16, 16);
        } else if (((Crosshair)((Object)this.type.get())).equals((Object)Crosshair.CUSTOM)) {
            Util.bindTexture(this.customTextureGraphics);
            DrawUtil.m_5935491((int)(x + this.width / 2 - 7), (int)(y + this.height / 2 - 7 - 1), (float)0.0f, (float)0.0f, (int)15, (int)15, (float)15.0f, (float)15.0f);
        }
        C_3754158.m_3323122((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        C_3754158.m_0833259((int)770, (int)771, (int)1, (int)0);
        C_3754158.m_5313301();
        C_3754158.m_2041265();
        C_3754158.m_6191982();
    }

    public Color getColor() {
        C_3674802 blockPos;
        C_7873567 world;
        C_7794883 hit = this.client.f_3593768;
        if (hit == null || hit.f_3002973 == null) {
            return this.defaultColor.get();
        }
        if (hit.f_3002973 == C_7794883.C_3219935.f_1385333) {
            return this.entityColor.get();
        }
        if (hit.f_3002973 == C_7794883.C_3219935.f_9738847 && (world = this.client.f_4601986).m_4919395(blockPos = hit.m_1760520()).m_0999604() != null && (world.m_4919395(blockPos).m_0999604() instanceof C_7650729 || world.m_4919395(blockPos).m_0999604() instanceof C_8931049 || world.m_4919395(blockPos).m_0999604() instanceof C_4018501)) {
            return this.containerColor.get();
        }
        return this.defaultColor.get();
    }

    public void renderPlaceholder(AxoRenderContext context, float delta) {
    }

    public AnchorPoint getAnchor() {
        return AnchorPoint.MIDDLE_MIDDLE;
    }

    public static enum Crosshair {
        CROSS,
        DOT,
        TEXTURE,
        CUSTOM;

    }
}

