/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.hud.gui.hud.vanilla;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.github.axolotlclient.AxolotlClientConfig.api.options.Option;
import io.github.axolotlclient.AxolotlClientConfig.api.util.Color;
import io.github.axolotlclient.AxolotlClientConfig.api.util.Colors;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.BooleanOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.ColorOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.IntegerOption;
import io.github.axolotlclient.bridge.render.AxoRenderContext;
import io.github.axolotlclient.modules.hud.gui.entry.TextHudEntry;
import io.github.axolotlclient.modules.hud.gui.layout.AnchorPoint;
import io.github.axolotlclient.modules.hud.util.DrawUtil;
import io.github.axolotlclient.modules.hud.util.Rectangle;
import io.github.axolotlclient.modules.hud.util.RenderUtil;
import io.github.axolotlclient.util.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.unmapped.C_0561170;
import net.minecraft.unmapped.C_0814381;
import net.minecraft.unmapped.C_1028001;
import net.minecraft.unmapped.C_3177907;
import net.minecraft.unmapped.C_3526030;
import net.minecraft.unmapped.C_3754158;
import net.minecraft.unmapped.C_3945557;
import net.minecraft.unmapped.C_4143404;
import net.minecraft.unmapped.C_6476436;
import net.minecraft.unmapped.C_8105098;

public class ScoreboardHud
extends TextHudEntry {
    public static final C_0561170 ID = new C_0561170("kronhud", "scoreboardhud");
    private final C_3945557 placeholder = Util.make(() -> {
        C_0814381 placeholderScoreboard = new C_0814381();
        C_3945557 objective = placeholderScoreboard.m_8272217("Scoreboard", C_1028001.f_9119493);
        C_3526030 dark = placeholderScoreboard.m_4288528("DarkKronicle", objective);
        dark.m_9973427(8780);
        C_3526030 moeh = placeholderScoreboard.m_4288528("moehreag", objective);
        moeh.m_9973427(743);
        C_3526030 kode = placeholderScoreboard.m_4288528("TheKodeToad", objective);
        kode.m_9973427(2948);
        placeholderScoreboard.m_9771012(1, objective);
        return objective;
    });
    private final ColorOption backgroundColor = new ColorOption("backgroundcolor", new Color(0x4C000000));
    private final ColorOption topColor = new ColorOption("topbackgroundcolor", new Color(0x66000000));
    private final IntegerOption topPadding = new IntegerOption("toppadding", Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(4));
    private final BooleanOption scores = new BooleanOption("scores", Boolean.valueOf(true));
    private final ColorOption scoreColor = new ColorOption("scorecolor", new Color(-43691));
    private final IntegerOption textAlpha = new IntegerOption("text_alpha", Integer.valueOf(255), Integer.valueOf(0), Integer.valueOf(255));
    private final C_8105098 client;

    public ScoreboardHud() {
        super(200, 146, true);
        this.client = (C_8105098)((TextHudEntry)this).client;
    }

    public void render(AxoRenderContext context, float delta) {
        C_3754158.m_8373640();
        this.scale(context);
        this.renderComponent(context, delta);
        C_3754158.m_2041265();
    }

    public void renderComponent(AxoRenderContext context, float delta) {
        C_3945557 scoreboardObjective2;
        int t;
        C_0814381 scoreboard = this.client.f_4601986.m_5847414();
        C_3945557 scoreboardObjective = null;
        C_4143404 team = scoreboard.m_4614828(this.client.f_7663840.m_0699887().m_6222303());
        if (team != null && (t = team.m_0174211().m_4025272()) >= 0) {
            scoreboardObjective = scoreboard.m_8757270(3 + t);
        }
        C_3945557 c_3945557 = scoreboardObjective2 = scoreboardObjective != null ? scoreboardObjective : scoreboard.m_8757270(1);
        if (scoreboardObjective2 != null) {
            this.renderScoreboardSidebar(scoreboardObjective2, false);
        }
    }

    public void renderPlaceholderComponent(AxoRenderContext context, float delta) {
        this.renderScoreboardSidebar(this.placeholder, true);
    }

    private void renderScoreboardSidebar(C_3945557 objective, boolean placeholder) {
        int displayNameWidth;
        C_0814381 scoreboard = objective.m_2944653();
        ArrayList scores = scoreboard.m_0477108(objective);
        ArrayList filteredScores = scores.stream().filter(testScore -> testScore.m_2012228() != null && !testScore.m_2012228().startsWith("#")).collect(Collectors.toList());
        scores = filteredScores.size() > 15 ? Lists.newArrayList((Iterable)Iterables.skip(filteredScores, (int)(scores.size() - 15))) : filteredScores;
        ArrayList scoresWText = Lists.newArrayListWithCapacity((int)scores.size());
        String text = objective.m_0646168();
        int maxWidth = displayNameWidth = this.client.f_0426313.m_0040387(text);
        int spacerWidth = this.client.f_0426313.m_0040387(": ");
        for (C_3526030 scoreboardPlayerScore : scores) {
            C_4143404 team = scoreboard.m_2322207(scoreboardPlayerScore.m_2012228());
            String formattedText = C_4143404.m_3771660((C_3177907)team, (String)scoreboardPlayerScore.m_2012228());
            scoresWText.add(new C_6476436((Object)scoreboardPlayerScore, (Object)formattedText));
            maxWidth = Math.max(maxWidth, this.client.f_0426313.m_0040387(formattedText) + ((Boolean)this.scores.get() != false ? spacerWidth + this.client.f_0426313.m_0040387(Integer.toString(scoreboardPlayerScore.m_7979602())) : 0));
        }
        maxWidth += 6;
        int scoresSize = scores.size();
        int scoreHeight = scoresSize * 9;
        int fullHeight = scoreHeight + 11 + (Integer)this.topPadding.get() * 2;
        boolean updated = false;
        if (fullHeight + 1 != this.height) {
            this.setHeight(fullHeight + 1);
            updated = true;
        }
        if (maxWidth + 1 != this.width) {
            this.setWidth(maxWidth + 1);
            updated = true;
        }
        if (updated) {
            this.onBoundsUpdate();
        }
        Rectangle bounds = this.getBounds();
        int renderX = bounds.x() + bounds.width() - maxWidth;
        int renderY = bounds.y() + (bounds.height() / 2 - fullHeight / 2) + 1;
        int scoreX = renderX + 4;
        int scoreY = renderY + scoreHeight + 10;
        int num = 0;
        int textOffset = scoreX - 4;
        for (C_6476436 scoreboardPlayerScoreTextPair : scoresWText) {
            C_3526030 scoreboardPlayerScore2 = (C_3526030)scoreboardPlayerScoreTextPair.m_6146952();
            String scoreText = (String)scoreboardPlayerScoreTextPair.m_5167526();
            String score = String.valueOf(scoreboardPlayerScore2.m_7979602());
            int relativeY = scoreY - ++num * 9 + (Integer)this.topPadding.get() * 2;
            if (((Boolean)this.background.get()).booleanValue() && this.backgroundColor.get().getAlpha() > 0 && !placeholder) {
                if (num == scoresSize) {
                    RenderUtil.drawRectangle(textOffset, relativeY - 1, maxWidth, 10, this.backgroundColor.get().toInt());
                } else if (num == 1) {
                    RenderUtil.drawRectangle(textOffset, relativeY, maxWidth, 10, this.backgroundColor.get());
                } else {
                    RenderUtil.drawRectangle(textOffset, relativeY, maxWidth, 9, this.backgroundColor.get());
                }
            }
            if (((Boolean)this.shadow.get()).booleanValue()) {
                this.client.f_0426313.m_1950885(scoreText, (float)scoreX, (float)relativeY, Colors.WHITE.withAlpha(((Integer)this.textAlpha.get()).intValue()).toInt());
            } else {
                this.client.f_0426313.m_4683674(scoreText, scoreX, relativeY, Colors.WHITE.withAlpha(((Integer)this.textAlpha.get()).intValue()).toInt());
            }
            if (((Boolean)this.scores.get()).booleanValue()) {
                DrawUtil.drawString(score, (float)(scoreX + maxWidth - this.client.f_0426313.m_0040387(score) - 6), (float)relativeY, this.scoreColor.get().toInt(), (boolean)((Boolean)this.shadow.get()));
            }
            if (num != scoresSize) continue;
            if (((Boolean)this.background.get()).booleanValue() && !placeholder) {
                RenderUtil.drawRectangle(textOffset, relativeY - 10 - (Integer)this.topPadding.get() * 2 - 1, maxWidth, 10 + (Integer)this.topPadding.get() * 2, this.topColor.get());
            }
            float title = (float)renderX + (float)(maxWidth - displayNameWidth) / 2.0f;
            if (((Boolean)this.shadow.get()).booleanValue()) {
                this.client.f_0426313.m_1950885(text, title, (float)(relativeY - 9) - (float)((Integer)this.topPadding.get()).intValue(), Colors.WHITE.withAlpha(((Integer)this.textAlpha.get()).intValue()).toInt());
                continue;
            }
            this.client.f_0426313.m_4683674(text, (int)title, relativeY - 9, Colors.WHITE.withAlpha(((Integer)this.textAlpha.get()).intValue()).toInt());
        }
        if (((Boolean)this.outline.get()).booleanValue() && this.outlineColor.get().getAlpha() > 0 && !placeholder) {
            RenderUtil.drawOutline(textOffset, bounds.y(), maxWidth, fullHeight + 1, this.outlineColor.get());
        }
    }

    public List<Option<?>> getConfigurationOptions() {
        List options = super.getConfigurationOptions();
        options.remove(this.backgroundPadding);
        options.remove(this.backgroundRounding);
        options.remove(this.roundBackground);
        options.set(options.indexOf(((TextHudEntry)this).backgroundColor), this.backgroundColor);
        options.add(this.hide);
        options.add(this.topColor);
        options.add(this.scores);
        options.add(this.scoreColor);
        options.add(this.topPadding);
        options.remove(this.textColor);
        options.add(this.textAlpha);
        return options;
    }

    public C_0561170 getId() {
        return ID;
    }

    protected AnchorPoint getDefaultAnchor() {
        return AnchorPoint.MIDDLE_RIGHT;
    }

    public double getDefaultX() {
        return 1.0;
    }

    public double getDefaultY() {
        return 0.5;
    }
}

