/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.hud.gui.keystrokes;

import com.google.common.collect.ImmutableList;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.vanilla.widgets.VanillaButtonWidget;
import java.util.Collection;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import lombok.Generated;
import net.minecraft.unmapped.C_3020744;
import net.minecraft.unmapped.C_4976084;
import org.jetbrains.annotations.Nullable;

class CyclingButtonWidget<T>
extends VanillaButtonWidget {
    private final String optionText;
    private int index;
    private T value;
    private final Values<T> values;
    private final Function<T, String> valueToText;
    private final UpdateCallback<T> callback;

    CyclingButtonWidget(int x, int y, int width, int height, String message, String optionText, int index, T value, Values<T> values, Function<T, String> valueToText, UpdateCallback<T> callback) {
        super(x, y, width, height, message, btn -> {});
        this.optionText = optionText;
        this.index = index;
        this.value = value;
        this.values = values;
        this.valueToText = valueToText;
        this.callback = callback;
    }

    public void onPress() {
        if (C_3020744.m_5142737()) {
            this.cycle(-1);
        } else {
            this.cycle(1);
        }
    }

    private void cycle(int amount) {
        List<T> list = this.values.getCurrent();
        this.index = C_4976084.m_6242245((int)(this.index + amount), (int)list.size());
        T object = list.get(this.index);
        this.internalSetValue(object);
        this.callback.onValueChange(this, object);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double amountX, double amount) {
        if (amount > 0.0) {
            this.cycle(-1);
        } else if (amount < 0.0) {
            this.cycle(1);
        }
        return true;
    }

    public void setValue(T value) {
        List<T> list = this.values.getCurrent();
        int i = list.indexOf(value);
        if (i != -1) {
            this.index = i;
        }
        this.internalSetValue(value);
    }

    private void internalSetValue(T value) {
        String text = this.composeText(value);
        this.setMessage(text);
        this.value = value;
    }

    private String composeText(T value) {
        return this.composeGenericOptionText(value);
    }

    private String composeGenericOptionText(T value) {
        return this.optionText + ": " + this.valueToText.apply(value);
    }

    static <T> Builder<T> builder(Function<T, String> valueToText) {
        return new Builder<T>(valueToText);
    }

    @Generated
    public T getValue() {
        return this.value;
    }

    static interface Values<T> {
        public List<T> getCurrent();

        public List<T> getDefaults();

        public static <T> Values<T> of(Collection<T> values) {
            ImmutableList list = ImmutableList.copyOf(values);
            return new Values<T>((List)list){
                final /* synthetic */ List val$list;
                {
                    this.val$list = list;
                }

                @Override
                public List<T> getCurrent() {
                    return this.val$list;
                }

                @Override
                public List<T> getDefaults() {
                    return this.val$list;
                }
            };
        }

        public static <T> Values<T> of(final BooleanSupplier alternativeToggle, List<T> defaults, List<T> alternatives) {
            ImmutableList list = ImmutableList.copyOf(defaults);
            ImmutableList list2 = ImmutableList.copyOf(alternatives);
            return new Values<T>((List)list2, (List)list){
                final /* synthetic */ List val$list2;
                final /* synthetic */ List val$list;
                {
                    this.val$list2 = list;
                    this.val$list = list2;
                }

                @Override
                public List<T> getCurrent() {
                    return alternativeToggle.getAsBoolean() ? this.val$list2 : this.val$list;
                }

                @Override
                public List<T> getDefaults() {
                    return this.val$list;
                }
            };
        }
    }

    static interface UpdateCallback<T> {
        public void onValueChange(CyclingButtonWidget<T> var1, T var2);
    }

    static class Builder<T> {
        private int initialIndex;
        @Nullable
        private T value;
        private final Function<T, String> valueToText;
        private Values<T> values = Values.of(ImmutableList.of());

        public Builder(Function<T, String> valueToText) {
            this.valueToText = valueToText;
        }

        public Builder<T> values(Collection<T> values) {
            return this.values(Values.of(values));
        }

        @SafeVarargs
        public final Builder<T> values(T ... values) {
            return this.values((Collection<T>)ImmutableList.copyOf((Object[])values));
        }

        public Builder<T> values(Values<T> values) {
            this.values = values;
            return this;
        }

        public Builder<T> initially(T value) {
            this.value = value;
            int i = this.values.getDefaults().indexOf(value);
            if (i != -1) {
                this.initialIndex = i;
            }
            return this;
        }

        public CyclingButtonWidget<T> build(int x, int y, int width, int height, String optionText, UpdateCallback<T> callback) {
            List<T> list = this.values.getDefaults();
            if (list.isEmpty()) {
                throw new IllegalStateException("No values for cycle button");
            }
            T object = this.value != null ? this.value : list.get(this.initialIndex);
            String text = this.valueToText.apply(object);
            String text2 = optionText + ": " + text;
            return new CyclingButtonWidget<T>(x, y, width, height, text2, optionText, this.initialIndex, object, this.values, this.valueToText, callback);
        }
    }
}

