/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.particles;

import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.AxolotlClientConfig.api.options.Option;
import io.github.axolotlclient.AxolotlClientConfig.api.options.OptionCategory;
import io.github.axolotlclient.AxolotlClientConfig.api.util.Color;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.BooleanOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.ColorOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.IntegerOption;
import io.github.axolotlclient.mixin.ParticleAccessor;
import io.github.axolotlclient.modules.AbstractModule;
import io.github.axolotlclient.util.ClientColors;
import io.github.axolotlclient.util.Util;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.WeakHashMap;
import lombok.Generated;
import net.minecraft.unmapped.C_1350658;
import net.minecraft.unmapped.C_4701530;
import org.apache.commons.lang3.StringUtils;

public class Particles
extends AbstractModule {
    private static final Particles Instance = new Particles();
    public final HashMap<C_4701530, HashMap<String, Option<?>>> particleOptions = new HashMap();
    public final WeakHashMap<C_1350658, C_4701530> particleMap = new WeakHashMap();
    private final OptionCategory cat = OptionCategory.create((String)"particles");
    private final BooleanOption enabled = new BooleanOption("enabled", Boolean.valueOf(false));

    public void init() {
        this.cat.add(new Option[]{this.enabled});
        this.addParticleOptions();
        AxolotlClient.config().rendering.add(new OptionCategory[]{this.cat});
    }

    private void addParticleOptions() {
        for (C_4701530 type : Arrays.stream(C_4701530.values()).sorted(new AlphabeticalComparator()).toList()) {
            OptionCategory category = OptionCategory.create((String)StringUtils.capitalize((String)Util.splitAtCapitalLetters(type.m_4736377().replace("_", ""))));
            LinkedHashMap optionsByKey = new LinkedHashMap();
            this.populateMap(optionsByKey, new Option[]{new BooleanOption("showParticle", Boolean.valueOf(true)), new IntegerOption("count", Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(20)), new BooleanOption("customColor", Boolean.valueOf(false)), new ColorOption("color", "particles.color.tooltip", ClientColors.WHITE)});
            if (type == C_4701530.f_9917373 || type == C_4701530.f_5110895) {
                this.populateMap(optionsByKey, new Option[]{new BooleanOption("alwaysCrit", Boolean.valueOf(false))});
            }
            ((HashMap)optionsByKey).values().forEach(xva$0 -> category.add(new Option[]{xva$0}));
            this.particleOptions.put(type, optionsByKey);
            this.cat.add(new OptionCategory[]{category});
        }
    }

    private void populateMap(HashMap<String, Option<?>> map, Option<?> ... options) {
        for (Option<?> option : options) {
            map.put(option.getName(), option);
        }
    }

    public void applyOptions(C_1350658 particle) {
        HashMap<String, Option<?>> options;
        C_4701530 type;
        if (((Boolean)this.enabled.get()).booleanValue() && this.particleMap.containsKey(particle) && this.particleOptions.containsKey(type = this.particleMap.get(particle)) && ((Boolean)((BooleanOption)(options = this.particleOptions.get(type)).get("customColor")).get()).booleanValue()) {
            Color color = ((ColorOption)options.get("color")).get();
            particle.m_9240833((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
            ((ParticleAccessor)particle).setAlpha((float)color.getAlpha() / 255.0f);
        }
    }

    public int getMultiplier(C_4701530 type) {
        if (((Boolean)this.enabled.get()).booleanValue() && this.particleOptions.containsKey(type)) {
            HashMap<String, Option<?>> options = this.particleOptions.get(type);
            return (Integer)((IntegerOption)options.get("count")).get();
        }
        return 1;
    }

    public boolean getAlwaysOn(C_4701530 type) {
        return (Boolean)this.enabled.get() != false && this.particleOptions.containsKey(type) && (Boolean)((BooleanOption)Particles.getInstance().particleOptions.get(type).get("alwaysCrit")).get() != false;
    }

    public boolean getShowParticle(C_4701530 type) {
        return (Boolean)this.enabled.get() != false && this.particleOptions.containsKey(type) ? (Boolean)((BooleanOption)Particles.getInstance().particleOptions.get(type).get("showParticle")).get() : true;
    }

    @Generated
    public static Particles getInstance() {
        return Instance;
    }

    protected static class AlphabeticalComparator
    implements Comparator<C_4701530> {
        protected AlphabeticalComparator() {
        }

        @Override
        public int compare(C_4701530 s1, C_4701530 s2) {
            if (s1.m_4736377().equals(s2.m_4736377())) {
                return 0;
            }
            String[] strings = new String[]{s1.m_4736377(), s2.m_4736377()};
            Arrays.sort(strings, Collections.reverseOrder());
            if (strings[0].equals(s1.m_4736377())) {
                return 1;
            }
            return -1;
        }
    }
}

