/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.screenshotUtils;

import com.google.common.hash.Hashing;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Locale;
import javax.imageio.ImageIO;
import net.minecraft.unmapped.C_0561170;
import net.minecraft.unmapped.C_3779718;
import net.minecraft.unmapped.C_4882708;
import net.minecraft.unmapped.C_8105098;

public interface ImageInstance {
    public C_0561170 id();

    public BufferedImage image();

    public String filename();

    private static void register(C_0561170 id, BufferedImage img) {
        C_8105098.m_0408063().m_7581301(() -> C_8105098.m_0408063().m_1218956().m_0381205(id, (C_4882708)new C_3779718(img)));
    }

    public record RemoteImpl(C_0561170 id, BufferedImage image, String filename, String uploader, Instant sharedAt, String url) implements Remote
    {
        public RemoteImpl(BufferedImage image, String filename, String uploader, Instant sharedAt, String url) {
            this(new C_0561170("axolotlclient", "gallery_remote_" + String.valueOf(Hashing.sha256().hashUnencodedChars((CharSequence)url.toLowerCase(Locale.ROOT).replaceAll("[./]", "_")))), image, filename, uploader, sharedAt, url);
            ImageInstance.register(this.id(), this.image());
        }
    }

    public record SharedImpl(C_0561170 id, BufferedImage image, String filename, Path location, String url, String uploader, Instant sharedAt) implements Local,
    Remote
    {
    }

    public record LocalImpl(C_0561170 id, BufferedImage image, String filename, Path location) implements Local
    {
        public LocalImpl(BufferedImage image, String filename, Path location) {
            this(new C_0561170("gallery_local_" + String.valueOf(Hashing.sha256().hashUnencodedChars((CharSequence)location.toString().toLowerCase(Locale.ROOT).replaceAll("[./]", "_")))), image, filename, location);
            ImageInstance.register(this.id(), this.image());
        }

        public LocalImpl(Path p) throws IOException {
            this(ImageIO.read(Files.newInputStream(p, new OpenOption[0])), p.getFileName().toString(), p);
        }
    }

    public static interface Remote
    extends ImageInstance {
        public String url();

        public String uploader();

        public Instant sharedAt();

        default public ImageInstance toShared(Path saved) {
            return new SharedImpl(this.id(), this.image(), this.filename(), saved, this.url(), this.uploader(), this.sharedAt());
        }
    }

    public static interface Local
    extends ImageInstance {
        public Path location();

        default public ImageInstance toShared(String url, String uploader, Instant sharedAt) {
            return new SharedImpl(this.id(), this.image(), this.filename(), this.location(), url, uploader, sharedAt);
        }
    }
}

