/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.sky;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.modules.AbstractModule;
import io.github.axolotlclient.modules.sky.FSBSkyboxInstance;
import io.github.axolotlclient.modules.sky.MCPSkyboxInstance;
import io.github.axolotlclient.modules.sky.SkyboxManager;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import lombok.Generated;
import net.minecraft.unmapped.C_0561170;
import net.minecraft.unmapped.C_6577431;
import net.minecraft.unmapped.C_8105098;
import net.ornithemc.osl.resource.loader.api.ResourceLoaderEvents;

public class SkyResourceManager
extends AbstractModule {
    private static final SkyResourceManager instance = new SkyResourceManager();
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public void reload(C_6577431 resourceManager) {
        AxolotlClient.LOGGER.debug("Loading custom skies!", new Object[0]);
        for (C_0561170 entry : resourceManager.findResources("fabricskyboxes", "sky", identifier -> identifier.m_8655655().endsWith(".json")).keySet()) {
            if (entry.m_1302635().equals("celestial")) continue;
            try {
                AxolotlClient.LOGGER.debug("Loading sky: " + String.valueOf(entry), new Object[0]);
                JsonObject json = (JsonObject)gson.fromJson(new BufferedReader(new InputStreamReader(resourceManager.m_5942034(entry).m_3098790(), StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n")), JsonObject.class);
                if (!json.has("type") || !json.get("type").getAsString().equals("square-textured")) {
                    AxolotlClient.LOGGER.debug("Skipping " + String.valueOf(entry) + " as we currently cannot load it!", new Object[0]);
                    continue;
                }
                SkyboxManager.getInstance().addSkybox(new FSBSkyboxInstance(json));
                AxolotlClient.LOGGER.debug("Loaded sky: " + String.valueOf(entry), new Object[0]);
            }
            catch (Exception e) {
                AxolotlClient.LOGGER.warn("Failed to load sky: " + String.valueOf(entry), new Object[]{e});
            }
        }
        for (C_0561170 entry : resourceManager.findResources("minecraft", "optifine/sky", identifier -> this.isMCPSky(identifier.m_8655655())).keySet()) {
            AxolotlClient.LOGGER.debug("Loading sky: " + String.valueOf(entry), new Object[0]);
            this.loadMCPSky("optifine", entry, resourceManager);
            AxolotlClient.LOGGER.debug("Loaded sky: " + String.valueOf(entry), new Object[0]);
        }
        for (C_0561170 entry : resourceManager.findResources("minecraft", "mcpatcher/sky", identifier -> this.isMCPSky(identifier.m_8655655())).keySet()) {
            AxolotlClient.LOGGER.debug("Loading sky: " + String.valueOf(entry), new Object[0]);
            this.loadMCPSky("mcpatcher", entry, resourceManager);
            AxolotlClient.LOGGER.debug("Loaded sky: " + String.valueOf(entry), new Object[0]);
        }
    }

    private boolean isMCPSky(String path) {
        return path.endsWith(".properties") && path.substring(path.lastIndexOf("/") + 1).startsWith("sky");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadMCPSky(String loader, C_0561170 id, C_6577431 resourceManager) {
        JsonObject object = new JsonObject();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(resourceManager.m_5942034(id).m_3098790(), StandardCharsets.UTF_8));
            try {
                String string;
                while ((string = reader.readLine()) != null) {
                    try {
                        if (string.startsWith("#")) continue;
                        String[] option = string.split("=");
                        if (option[0].equals("source")) {
                            if (!option[1].contains(":")) {
                                if (option[1].startsWith("assets")) {
                                    option[1] = option[1].replace("./", "").replace("assets/minecraft/", "");
                                }
                                if (id.m_8655655().contains("world")) {
                                    option[1] = loader + "/sky/world" + id.m_8655655().split("world")[1].split("/")[0] + "/" + option[1].replace("./", "");
                                }
                            }
                            try {
                                resourceManager.m_5942034(new C_0561170(option[1]));
                            }
                            catch (FileNotFoundException e) {
                                AxolotlClient.LOGGER.warn("Sky " + String.valueOf(id) + " does not have a valid texture attached to it: ", new Object[]{option[1]});
                                AxolotlClient.LOGGER.warn("Please fix your packs.", new Object[0]);
                                reader.close();
                                return;
                            }
                        }
                        if (option[0].equals("startFadeIn") || option[0].equals("endFadeIn") || option[0].equals("startFadeOut") || option[0].equals("endFadeOut")) {
                            option[1] = option[1].replace(":", "").replace("\\", "");
                        }
                        object.addProperty(option[0], option[1]);
                    }
                    catch (Exception exception) {}
                }
                SkyboxManager.getInstance().addSkybox(new MCPSkyboxInstance(object));
                return;
            }
            finally {
                try {
                    reader.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
        catch (Exception e) {
            AxolotlClient.LOGGER.debug("Error while loading sky", new Object[]{e});
        }
    }

    public void init() {
        ResourceLoaderEvents.START_RESOURCE_RELOAD.register(() -> SkyboxManager.getInstance().clearSkyboxes());
        ResourceLoaderEvents.END_RESOURCE_RELOAD.register(() -> this.reload(C_8105098.m_0408063().m_3739907()));
    }

    @Generated
    public static SkyResourceManager getInstance() {
        return instance;
    }
}

