/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.zoom;

import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.AxolotlClientConfig.api.options.Option;
import io.github.axolotlclient.AxolotlClientConfig.api.options.OptionCategory;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.BooleanOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.FloatOption;
import io.github.axolotlclient.modules.AbstractModule;
import io.github.axolotlclient.util.Util;
import lombok.Generated;
import net.minecraft.unmapped.C_7778778;
import net.minecraft.unmapped.C_8105098;
import net.ornithemc.osl.keybinds.api.KeyBindingEvents;
import org.lwjgl.input.Keyboard;

public class Zoom
extends AbstractModule {
    public static final FloatOption zoomDivisor = new FloatOption("zoomDivisor", Float.valueOf(4.0f), Float.valueOf(1.0f), Float.valueOf(16.0f));
    public static final FloatOption zoomSpeed = new FloatOption("zoomSpeed", Float.valueOf(7.5f), Float.valueOf(1.0f), Float.valueOf(10.0f));
    public static final BooleanOption zoomScrolling = new BooleanOption("zoomScrolling", Boolean.valueOf(false));
    public static final BooleanOption decreaseSensitivity = new BooleanOption("decreaseSensitivity", Boolean.valueOf(true));
    public static final BooleanOption smoothCamera = new BooleanOption("smoothCamera", Boolean.valueOf(false));
    private static final Zoom Instance = new Zoom();
    public static boolean active;
    private static float originalSensitivity;
    private static boolean originalSmoothCamera;
    private static C_7778778 keyBinding;
    private static C_7778778 increase;
    private static C_7778778 decrease;
    private static double targetFactor;
    private static double divisor;
    private static float lastAnimatedFactor;
    private static float animatedFactor;
    private static double lastReturnedFov;
    public final OptionCategory zoom = OptionCategory.create((String)"zoom");

    public static double getFov(float current, float tickDelta) {
        double result = (double)current * (((Float)zoomSpeed.get()).floatValue() == 10.0f ? targetFactor : (double)Util.lerp(lastAnimatedFactor, animatedFactor, tickDelta));
        if (lastReturnedFov != 0.0 && lastReturnedFov != result) {
            C_8105098.m_0408063().f_4021716.m_6441091();
        }
        lastReturnedFov = result;
        return result;
    }

    public static void update() {
        if (Zoom.shouldStart()) {
            Zoom.start();
        } else if (Zoom.shouldStop()) {
            Zoom.stop();
        }
    }

    private static boolean shouldStart() {
        return Zoom.keyHeld() && !active;
    }

    private static void start() {
        active = true;
        Zoom.setDivisor(((Float)zoomDivisor.get()).floatValue());
        Zoom.setOptions();
    }

    private static boolean shouldStop() {
        return !Zoom.keyHeld() && active;
    }

    private static void stop() {
        active = false;
        targetFactor = 1.0;
        Zoom.restoreOptions();
    }

    private static boolean keyHeld() {
        return keyBinding.m_7042641();
    }

    private static void setDivisor(double value) {
        divisor = value;
        targetFactor = 1.0 / value;
    }

    public static void setOptions() {
        originalSensitivity = C_8105098.m_0408063().f_9967940.f_8101413;
        if (((Boolean)smoothCamera.get()).booleanValue()) {
            originalSmoothCamera = C_8105098.m_0408063().f_9967940.f_4083654;
            C_8105098.m_0408063().f_9967940.f_4083654 = true;
        }
        Zoom.updateSensitivity();
    }

    public static void restoreOptions() {
        C_8105098.m_0408063().f_9967940.f_8101413 = originalSensitivity;
        C_8105098.m_0408063().f_9967940.f_4083654 = originalSmoothCamera;
    }

    private static void updateSensitivity() {
        if (((Boolean)decreaseSensitivity.get()).booleanValue()) {
            C_8105098.m_0408063().f_9967940.f_8101413 = (float)((double)originalSensitivity / divisor);
        }
    }

    public static boolean scroll(double amount) {
        if (active && ((Boolean)zoomScrolling.get()).booleanValue() && amount != 0.0) {
            Zoom.setDivisor(Math.max(1.0, divisor + amount / Math.abs(amount)));
            Zoom.updateSensitivity();
            return true;
        }
        return false;
    }

    public void init() {
        this.zoom.add(new Option[]{zoomDivisor});
        this.zoom.add(new Option[]{zoomSpeed});
        this.zoom.add(new Option[]{zoomScrolling});
        this.zoom.add(new Option[]{decreaseSensitivity});
        this.zoom.add(new Option[]{smoothCamera});
        AxolotlClient.config().rendering.add(new OptionCategory[]{this.zoom});
        keyBinding = new C_7778778("key.zoom", Keyboard.KEY_C, "category.axolotlclient");
        active = false;
        increase = new C_7778778("key.zoom.increase", Keyboard.KEY_NONE, "category.axolotlclient");
        decrease = new C_7778778("key.zoom.decrease", Keyboard.KEY_NONE, "category.axolotlclient");
        KeyBindingEvents.REGISTER_KEYBINDS.register(r -> {
            r.register(keyBinding);
            r.register(increase);
            r.register(decrease);
        });
    }

    public void tick() {
        lastAnimatedFactor = animatedFactor;
        animatedFactor += (float)((targetFactor - (double)animatedFactor) * (double)(((Float)zoomSpeed.get()).floatValue() / 10.0f));
        if (increase.m_7042641()) {
            Zoom.scroll(((Float)zoomSpeed.get()).floatValue() / 2.0f);
        } else if (decrease.m_7042641()) {
            Zoom.scroll(-((Float)zoomSpeed.get()).floatValue() / 2.0f);
        }
    }

    @Generated
    public static Zoom getInstance() {
        return Instance;
    }

    static {
        targetFactor = 1.0;
        lastAnimatedFactor = 1.0f;
        animatedFactor = 1.0f;
    }
}

