/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.util;

import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.AxolotlClientConfig.api.util.Color;
import io.github.axolotlclient.AxolotlClientConfig.api.util.Graphics;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.GraphicsOption;
import io.github.axolotlclient.mixin.MinecraftClientAccessor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.function.Supplier;
import javax.imageio.ImageIO;
import net.minecraft.unmapped.C_0561170;
import net.minecraft.unmapped.C_3779718;
import net.minecraft.unmapped.C_4882708;
import net.minecraft.unmapped.C_7799337;
import net.minecraft.unmapped.C_8105098;
import net.minecraft.unmapped.C_9550253;
import org.jetbrains.annotations.ApiStatus;

public class Util {
    public static String lastgame;
    public static String game;
    @ApiStatus.Internal
    public static C_7799337 window;

    public static int getTicksBetween(int start, int end) {
        if (end < start) {
            end += 24000;
        }
        return end - start;
    }

    public static int toGlCoordsX(int x) {
        if (window == null) {
            window = new C_7799337(C_8105098.m_0408063());
        }
        return x * window.m_8052133();
    }

    public static int toGlCoordsY(int y) {
        if (window == null) {
            window = new C_7799337(C_8105098.m_0408063());
        }
        int scale = window.m_8052133();
        return C_8105098.m_0408063().f_5990000 - y * scale - scale;
    }

    public static int toMCCoordsX(int x) {
        if (window == null) {
            window = new C_7799337(C_8105098.m_0408063());
        }
        return x * window.m_1713651() / C_8105098.m_0408063().f_0545414;
    }

    public static int toMCCoordsY(int y) {
        if (window == null) {
            window = new C_7799337(C_8105098.m_0408063());
        }
        return window.m_5421693() - y * window.m_5421693() / C_8105098.m_0408063().f_5990000 - 1;
    }

    public static C_7799337 getWindow() {
        if (window == null) {
            try {
                window = new C_7799337(C_8105098.m_0408063());
            }
            catch (Exception e) {
                return null;
            }
        }
        return window;
    }

    public static void addMessageToChatHud(C_9550253 msg) {
        C_8105098.m_0408063().f_3501374.m_8449802().m_7344462(msg);
    }

    public static String splitAtCapitalLetters(String string) {
        if (string == null || string.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (char c : string.toCharArray()) {
            if (Character.isUpperCase(c) && c != string.charAt(0)) {
                builder.append(" ");
            }
            builder.append(c);
        }
        return builder.toString();
    }

    public static <T> T make(Supplier<T> factory) {
        return factory.get();
    }

    public static boolean currentServerAddressContains(String address) {
        if (C_8105098.m_0408063().m_9805322() || C_8105098.m_0408063().m_3844208()) {
            return false;
        }
        if (C_8105098.m_0408063().m_1862495() != null) {
            return C_8105098.m_0408063().m_1862495().f_7619058.contains(address);
        }
        return ((MinecraftClientAccessor)C_8105098.m_0408063()).getServerAddress() != null && ((MinecraftClientAccessor)C_8105098.m_0408063()).getServerAddress().contains(address);
    }

    public static float lerp(float start, float end, float percent) {
        return start + (end - start) * percent;
    }

    public static C_0561170 getTexture(GraphicsOption option) {
        return Util.getTexture((Graphics)option.get(), "graphics_" + option.getName());
    }

    public static C_0561170 getTexture(Graphics graphics, String name) {
        C_0561170 id = new C_0561170("axolotlclient", name.toLowerCase(Locale.ROOT));
        return Util.getTexture(graphics, id);
    }

    public static C_0561170 getTexture(Graphics graphics, C_0561170 id) {
        try {
            C_3779718 texture;
            if (C_8105098.m_0408063().m_1218956().m_1605001(id) == null) {
                texture = new C_3779718(ImageIO.read(new ByteArrayInputStream(graphics.getPixelData())));
                C_8105098.m_0408063().m_1218956().m_0381205(id, (C_4882708)texture);
            } else {
                texture = (C_3779718)C_8105098.m_0408063().m_1218956().m_1605001(id);
                int[] pix = texture.m_1823577();
                for (int x = 0; x < graphics.getWidth(); ++x) {
                    for (int y = 0; y < graphics.getHeight(); ++y) {
                        int rows = y * graphics.getWidth() + x;
                        pix[rows] = graphics.getPixelColor(x, y);
                    }
                }
            }
            texture.m_4420833();
        }
        catch (IOException e) {
            AxolotlClient.LOGGER.error("Failed to bind texture for " + String.valueOf(id) + ": ", new Object[]{e});
        }
        return id;
    }

    public static void bindTexture(GraphicsOption option) {
        C_0561170 id = Util.getTexture(option);
        C_8105098.m_0408063().m_1218956().m_5325521(id);
    }

    public static String getFormatCode(Color color) {
        return String.format("\u00a7#%06X", color.getRed() << 16 | color.getGreen() << 8 | color.getBlue());
    }
}

