/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.api;

import io.github.axolotlclient.modules.hud.util.DrawUtil;
import io.github.axolotlclient.util.Util;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.unmapped.C_2348249;
import net.minecraft.unmapped.C_2691939;
import net.minecraft.unmapped.C_3390001;
import net.minecraft.unmapped.C_3754158;
import net.minecraft.unmapped.C_3831727;
import net.minecraft.unmapped.C_8105098;

public class ContextMenu {
    private final List<C_2348249> children;
    private int x;
    private int y;
    private int width;
    private int height = 0;
    private boolean rendering;

    protected ContextMenu(List<C_2348249> items) {
        this.children = items;
        int width = 0;
        int height = 0;
        for (C_2348249 d : this.children) {
            d.f_8532347 = height;
            height += 11;
            width = Math.max(width, d.m_8567079());
        }
        this.width = width;
        this.height = height;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void addEntry(C_2348249 entry) {
        this.children.add(entry);
    }

    public void render(C_8105098 client, int mouseX, int mouseY) {
        if (!this.rendering) {
            this.y = mouseY;
            this.x = mouseX;
            this.rendering = true;
        }
        int yStart = (int)Math.min((double)(this.y + 2), Util.getWindow().m_6423725() - (double)this.height - 2.0);
        int xStart = (int)Math.min((double)(this.x + 2), Util.getWindow().m_3624537() - (double)this.width - 2.0);
        int y = yStart + 1;
        this.width = 0;
        for (C_2348249 d : this.children) {
            d.f_3923091 = xStart + 1;
            d.f_8532347 = y;
            y += 11;
            this.width = Math.max(this.width, d.m_8567079());
        }
        this.height = y;
        C_3754158.m_8373640();
        C_3754158.m_3172490((float)0.0f, (float)0.0f, (float)200.0f);
        C_2691939.m_7865719((int)xStart, (int)yStart, (int)(xStart + this.width + 1), (int)y, (int)-585228510);
        DrawUtil.outlineRect(xStart, yStart, this.width + 1, y - yStart + 1, -1);
        for (C_2348249 c : this.children) {
            c.m_5692328(this.width);
            c.m_5350167(client, mouseX, mouseY);
        }
        C_3754158.m_2041265();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        Pressable c;
        List<Pressable> stream = this.children.stream().filter(b -> b instanceof Pressable).map(b -> (Pressable)b).toList();
        boolean clicked = false;
        Iterator<Pressable> iterator = stream.iterator();
        while (iterator.hasNext() && !(clicked = (c = iterator.next()).onPress(mouseX, mouseY, button))) {
        }
        return clicked;
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseX <= (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY <= (double)(this.y + this.height);
    }

    public static class Builder {
        private final List<C_2348249> elements = new ArrayList<C_2348249>();

        public Builder entry(String name, PressAction action) {
            this.elements.add(new ContextMenuEntryWithAction(C_3390001.m_2053009((String)name, (Object[])new Object[0]), action));
            return this;
        }

        public Builder entry(C_2348249 widget) {
            this.elements.add(widget);
            return this;
        }

        public Builder spacer() {
            this.elements.add(new ContextMenuEntry("-----"));
            return this;
        }

        public Builder title(String title) {
            this.elements.add(new ContextMenuEntry(title));
            return this;
        }

        public ContextMenu build() {
            return new ContextMenu(this.elements);
        }
    }

    private static interface Pressable {
        public boolean onPress(double var1, double var3, int var5);
    }

    public static class ContextMenuEntryWithAction
    extends C_2348249
    implements Pressable {
        final PressAction action;
        private final C_8105098 client = C_8105098.m_0408063();

        public ContextMenuEntryWithAction(String message, PressAction onPress) {
            super(0, 0, 0, C_8105098.m_0408063().f_0426313.m_0040387(message) + 4, 11, message);
            this.action = onPress;
        }

        public void m_5350167(C_8105098 client, int mouseX, int mouseY) {
            boolean bl = this.f_8690685 = mouseX >= this.f_3923091 && mouseY >= this.f_8532347 && mouseX < this.f_3923091 + this.f_9527567 && mouseY < this.f_8532347 + this.f_7845401;
            if (this.m_7131232()) {
                ContextMenuEntryWithAction.m_7865719((int)this.f_3923091, (int)this.f_8532347, (int)(this.f_3923091 + this.m_8567079()), (int)(this.f_8532347 + this.f_7845401), (int)0x55FFFFFF);
            }
            C_3754158.m_3323122((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int i = this.f_3831222 ? 0xFFFFFF : 0xA0A0A0;
            this.drawScrollableText(C_8105098.m_0408063().f_0426313, 2, i);
        }

        protected void drawScrollableText(C_3831727 textRenderer, int xOffset, int color) {
            int x = this.f_3923091 + xOffset;
            int xEnd = this.f_3923091 + this.m_8567079() - xOffset;
            DrawUtil.drawScrollableText(textRenderer, this.f_4865617, x, this.f_8532347, xEnd, this.f_8532347 + this.f_7845401, color);
        }

        @Override
        public boolean onPress(double mouseX, double mouseY, int button) {
            if (this.m_9491400(this.client, (int)mouseX, (int)mouseY) && button == 0) {
                this.m_1301911(this.client.m_7555106());
                this.action.onPress(this);
                return true;
            }
            return false;
        }
    }

    public static class ContextMenuEntry
    extends C_2348249
    implements Pressable {
        public ContextMenuEntry(String content) {
            super(0, 0, 0, C_8105098.m_0408063().f_0426313.m_0040387(content), 11, content);
        }

        public void m_5350167(C_8105098 client, int mouseX, int mouseY) {
            this.m_2717572(client.f_0426313, this.f_4865617, this.f_3923091 + this.m_8567079() / 2, this.f_8532347, 0xDDDDDD);
        }

        @Override
        public boolean onPress(double mouseX, double mouseY, int button) {
            return false;
        }
    }

    public static interface PressAction {
        public void onPress(C_2348249 var1);
    }
}

