/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.api;

import io.github.axolotlclient.api.AddFriendScreen;
import io.github.axolotlclient.api.UserListWidget;
import io.github.axolotlclient.api.chat.ChatScreen;
import io.github.axolotlclient.api.requests.ChannelRequest;
import io.github.axolotlclient.api.requests.FriendRequest;
import io.github.axolotlclient.api.types.Channel;
import io.github.axolotlclient.api.types.User;
import io.github.axolotlclient.api.util.AlphabeticalComparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.unmapped.C_1630332;
import net.minecraft.unmapped.C_2348249;
import net.minecraft.unmapped.C_3020744;
import net.minecraft.unmapped.C_3390001;
import net.minecraft.unmapped.C_7724922;

public class FriendsScreen
extends C_3020744 {
    private final C_3020744 parent;
    private UserListWidget widget;
    private C_2348249 chatButton;
    private C_2348249 removeButton;
    private C_2348249 onlineTab;
    private C_2348249 allTab;
    private C_2348249 pendingTab;
    private C_2348249 blockedTab;
    private C_2348249 denyButton;
    private C_2348249 acceptButton;
    private C_2348249 unblockButton;
    private C_2348249 cancelButton;
    private Tab current = Tab.ONLINE;

    protected FriendsScreen(C_3020744 parent, Tab tab) {
        this(parent);
        this.current = tab;
    }

    public FriendsScreen(C_3020744 parent) {
        this.parent = parent;
    }

    public void m_7261014(int mouseX, int mouseY, float delta) {
        this.m_7817195();
        this.widget.m_9734698(mouseX, mouseY, delta);
        this.m_2717572(this.f_2020658, C_3390001.m_2053009((String)"api.screen.friends", (Object[])new Object[0]), this.f_5465691 / 2, 20, 0xFFFFFF);
        super.m_7261014(mouseX, mouseY, delta);
    }

    protected void m_6992336(char c, int i) {
        C_1630332.C_8277969 entry;
        int j = this.widget.getSelected();
        C_1630332.C_8277969 c_8277969 = entry = j < 0 ? null : this.widget.m_7118949(j);
        if (i == 63) {
            this.refresh();
        } else if (j >= 0) {
            if (i == 200) {
                if (FriendsScreen.m_5142737()) {
                    if (j > 0 && entry instanceof UserListWidget.UserListEntry) {
                        this.select(this.widget.getSelected() - 1);
                        this.widget.m_9909453(-this.widget.m_6703043());
                    }
                } else if (j > 0) {
                    this.select(this.widget.getSelected() - 1);
                    this.widget.m_9909453(-this.widget.m_6703043());
                    if (this.widget.m_7118949(this.widget.getSelected()) instanceof C_7724922) {
                        if (this.widget.getSelected() > 0) {
                            this.select(this.widget.m_3791031() - 1);
                            this.widget.m_9909453(-this.widget.m_6703043());
                        } else {
                            this.select(-1);
                        }
                    }
                } else {
                    this.select(-1);
                }
            } else if (i == 208) {
                if (FriendsScreen.m_5142737()) {
                    this.select(j + 1);
                    this.widget.m_9909453(this.widget.m_6703043());
                } else if (j < this.widget.m_3791031()) {
                    this.select(this.widget.getSelected() + 1);
                    this.widget.m_9909453(this.widget.m_6703043());
                    if (this.widget.m_7118949(this.widget.getSelected()) instanceof C_7724922) {
                        if (this.widget.getSelected() < this.widget.m_3791031() - 1) {
                            this.select(this.widget.m_3791031() + 1);
                            this.widget.m_9909453(this.widget.m_6703043());
                        } else {
                            this.select(-1);
                        }
                    }
                } else {
                    this.select(-1);
                }
            } else if (i != 28 && i != 156) {
                super.m_6992336(c, i);
            } else {
                this.m_7971793((C_2348249)this.f_2213969.get(2));
            }
        } else {
            super.m_6992336(c, i);
        }
    }

    private void refresh() {
        this.f_7153641.m_6408915((C_3020744)new FriendsScreen(this.parent));
    }

    public void select(int i) {
        this.widget.setSelected(i);
        this.updateButtonActivationStates();
    }

    public void openChat() {
        if (!this.chatButton.f_3831222) {
            return;
        }
        UserListWidget.UserListEntry entry = this.widget.getSelectedEntry();
        if (entry != null) {
            this.chatButton.f_3831222 = false;
            ChannelRequest.getOrCreateDM((User)entry.getUser()).thenAccept(c -> this.f_7153641.m_2167033(() -> this.f_7153641.m_6408915((C_3020744)new ChatScreen(this, (Channel)c))));
        }
    }

    private void acceptRequest() {
        UserListWidget.UserListEntry entry = this.widget.getSelectedEntry();
        if (entry != null) {
            this.acceptButton.f_3831222 = false;
            FriendRequest.getInstance().acceptFriendRequest(entry.getUser()).thenRun(() -> this.f_7153641.m_2167033(this::refresh));
        }
    }

    private void denyRequest() {
        UserListWidget.UserListEntry entry = this.widget.getSelectedEntry();
        if (entry != null) {
            this.denyButton.f_3831222 = false;
            FriendRequest.getInstance().denyFriendRequest(entry.getUser()).thenRun(() -> this.f_7153641.m_2167033(this::refresh));
        }
    }

    protected void m_7362766(int i, int j, int k) {
        super.m_7362766(i, j, k);
        this.widget.m_7379893(i, j, k);
    }

    protected void m_5308748(int i, int j, int k) {
        super.m_5308748(i, j, k);
        this.widget.m_9825864(i, j, k);
    }

    protected void m_7971793(C_2348249 buttonWidget) {
        switch (buttonWidget.f_5920996) {
            case 0: {
                this.f_7153641.m_6408915(this.parent);
                break;
            }
            case 1: {
                this.openChat();
                break;
            }
            case 2: {
                this.acceptRequest();
                break;
            }
            case 3: {
                this.denyRequest();
                break;
            }
            case 4: {
                UserListWidget.UserListEntry entry = this.widget.getSelectedEntry();
                if (entry == null) break;
                this.removeButton.f_3831222 = false;
                FriendRequest.getInstance().removeFriend(entry.getUser()).thenRun(() -> this.f_7153641.m_2167033(this::refresh));
                break;
            }
            case 5: {
                this.f_7153641.m_6408915((C_3020744)new AddFriendScreen(this));
                break;
            }
            case 6: {
                this.f_7153641.m_6408915((C_3020744)new FriendsScreen(this.parent, Tab.ONLINE));
                break;
            }
            case 7: {
                this.f_7153641.m_6408915((C_3020744)new FriendsScreen(this.parent, Tab.ALL));
                break;
            }
            case 8: {
                this.f_7153641.m_6408915((C_3020744)new FriendsScreen(this.parent, Tab.PENDING));
                break;
            }
            case 9: {
                this.f_7153641.m_6408915((C_3020744)new FriendsScreen(this.parent, Tab.BLOCKED));
                break;
            }
            case 10: {
                buttonWidget.f_3831222 = false;
                FriendRequest.getInstance().unblockUser(this.widget.getSelectedEntry().getUser()).thenRun(() -> this.f_7153641.m_2167033(this::refresh));
                break;
            }
            case 11: {
                buttonWidget.f_3831222 = false;
                FriendRequest.getInstance().cancelFriendRequest(this.widget.getSelectedEntry().getUser()).thenRun(() -> this.f_7153641.m_2167033(this::refresh));
            }
        }
    }

    public void m_3593494() {
        this.widget = new UserListWidget(this, this.f_7153641, this.f_5465691, this.f_3080061, 32, this.f_3080061 - 64, 35);
        if (this.current == Tab.ALL || this.current == Tab.ONLINE) {
            FriendRequest.getInstance().getFriends().whenCompleteAsync((list, t) -> this.widget.setUsers(list.stream().filter(user -> {
                if (this.current == Tab.ONLINE) {
                    return user.getStatus().isOnline();
                }
                return true;
            }).sorted((u1, u2) -> new AlphabeticalComparator().compare(u1.getName(), u2.getName())).collect(Collectors.toList())));
        } else if (this.current == Tab.PENDING) {
            FriendRequest.getInstance().getFriendRequests().whenCompleteAsync((con, th) -> {
                ((List)con.getLeft()).stream().sorted((u1, u2) -> new AlphabeticalComparator().compare(u1.getName(), u2.getName())).forEach(user -> this.widget.addEntry(new UserListWidget.UserListEntry((User)user, C_3390001.m_2053009((String)"api.friends.pending.incoming", (Object[])new Object[0]))));
                ((List)con.getRight()).stream().sorted((u1, u2) -> new AlphabeticalComparator().compare(u1.getName(), u2.getName())).forEach(user -> this.widget.addEntry(new UserListWidget.UserListEntry((User)user, C_3390001.m_2053009((String)"api.friends.pending.outgoing", (Object[])new Object[0])).outgoing()));
            });
        } else if (this.current == Tab.BLOCKED) {
            FriendRequest.getInstance().getBlocked().whenCompleteAsync((list, th) -> this.widget.setUsers(list.stream().sorted((u1, u2) -> new AlphabeticalComparator().compare(u1.getName(), u2.getName())).collect(Collectors.toList())));
        }
        this.blockedTab = new C_2348249(9, this.f_5465691 / 2 + 24, this.f_3080061 - 52, 57, 20, C_3390001.m_2053009((String)"api.friends.tab.blocked", (Object[])new Object[0]));
        this.f_2213969.add(this.blockedTab);
        this.pendingTab = new C_2348249(8, this.f_5465691 / 2 - 34, this.f_3080061 - 52, 57, 20, C_3390001.m_2053009((String)"api.friends.tab.pending", (Object[])new Object[0]));
        this.f_2213969.add(this.pendingTab);
        this.allTab = new C_2348249(7, this.f_5465691 / 2 - 94, this.f_3080061 - 52, 57, 20, C_3390001.m_2053009((String)"api.friends.tab.all", (Object[])new Object[0]));
        this.f_2213969.add(this.allTab);
        this.onlineTab = new C_2348249(6, this.f_5465691 / 2 - 154, this.f_3080061 - 52, 57, 20, C_3390001.m_2053009((String)"api.friends.tab.online", (Object[])new Object[0]));
        this.f_2213969.add(this.onlineTab);
        this.f_2213969.add(new C_2348249(5, this.f_5465691 / 2 + 88, this.f_3080061 - 52, 66, 20, C_3390001.m_2053009((String)"api.friends.add", (Object[])new Object[0])));
        this.removeButton = new C_2348249(4, this.f_5465691 / 2 - 50, this.f_3080061 - 28, 100, 20, C_3390001.m_2053009((String)"api.friends.remove", (Object[])new Object[0]));
        this.f_2213969.add(this.removeButton);
        this.denyButton = new C_2348249(3, this.f_5465691 / 2 - 50, this.f_3080061 - 28, 48, 20, C_3390001.m_2053009((String)"api.friends.request.deny", (Object[])new Object[0]));
        this.f_2213969.add(this.denyButton);
        this.acceptButton = new C_2348249(2, this.f_5465691 / 2 + 2, this.f_3080061 - 28, 48, 20, C_3390001.m_2053009((String)"api.friends.request.accept", (Object[])new Object[0]));
        this.f_2213969.add(this.acceptButton);
        this.unblockButton = new C_2348249(10, this.f_5465691 / 2 - 50, this.f_3080061 - 28, 100, 20, C_3390001.m_2053009((String)"api.users.unblock", (Object[])new Object[0]));
        this.f_2213969.add(this.unblockButton);
        this.cancelButton = new C_2348249(11, this.f_5465691 / 2 - 50, this.f_3080061 - 28, 100, 20, C_3390001.m_2053009((String)"gui.cancel", (Object[])new Object[0]));
        this.f_2213969.add(this.cancelButton);
        this.chatButton = new C_2348249(1, this.f_5465691 / 2 - 154, this.f_3080061 - 28, 100, 20, C_3390001.m_2053009((String)"api.friends.chat", (Object[])new Object[0]));
        this.f_2213969.add(this.chatButton);
        this.f_2213969.add(new C_2348249(0, this.f_5465691 / 2 + 4 + 50, this.f_3080061 - 28, 100, 20, C_3390001.m_2053009((String)"gui.back", (Object[])new Object[0])));
        this.updateButtonActivationStates();
    }

    private void updateButtonActivationStates() {
        UserListWidget.UserListEntry entry = this.widget.getSelectedEntry();
        this.chatButton.f_3831222 = entry != null && (this.current == Tab.ALL || this.current == Tab.ONLINE);
        this.removeButton.f_1990467 = true;
        this.removeButton.f_3831222 = entry != null;
        this.unblockButton.f_3831222 = this.removeButton.f_3831222;
        this.denyButton.f_1990467 = false;
        this.cancelButton.f_1990467 = false;
        this.unblockButton.f_1990467 = false;
        this.acceptButton.f_1990467 = false;
        if (this.current == Tab.ONLINE) {
            this.onlineTab.f_3831222 = false;
            this.blockedTab.f_3831222 = true;
            this.pendingTab.f_3831222 = true;
            this.allTab.f_3831222 = true;
        } else if (this.current == Tab.ALL) {
            this.allTab.f_3831222 = false;
            this.blockedTab.f_3831222 = true;
            this.pendingTab.f_3831222 = true;
            this.onlineTab.f_3831222 = true;
        } else if (this.current == Tab.PENDING) {
            this.pendingTab.f_3831222 = false;
            this.blockedTab.f_3831222 = true;
            this.allTab.f_3831222 = true;
            this.onlineTab.f_3831222 = true;
            this.removeButton.f_1990467 = false;
            if (entry != null && entry.isOutgoingRequest()) {
                this.cancelButton.f_1990467 = true;
            } else {
                this.denyButton.f_1990467 = true;
                this.acceptButton.f_1990467 = true;
            }
            this.acceptButton.f_3831222 = entry != null;
            this.denyButton.f_3831222 = this.acceptButton.f_3831222;
        } else if (this.current == Tab.BLOCKED) {
            this.blockedTab.f_3831222 = false;
            this.pendingTab.f_3831222 = true;
            this.allTab.f_3831222 = true;
            this.onlineTab.f_3831222 = true;
            this.removeButton.f_1990467 = false;
            this.unblockButton.f_1990467 = true;
        }
    }

    public void m_3356138() {
        super.m_3356138();
        this.widget.m_1002325();
    }

    public static enum Tab {
        ONLINE,
        ALL,
        PENDING,
        BLOCKED;

    }
}

