/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.api;

import io.github.axolotlclient.api.FriendsScreen;
import io.github.axolotlclient.api.types.PkSystem;
import io.github.axolotlclient.api.types.User;
import io.github.axolotlclient.modules.auth.Auth;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import net.minecraft.unmapped.C_1630332;
import net.minecraft.unmapped.C_1945050;
import net.minecraft.unmapped.C_2691939;
import net.minecraft.unmapped.C_3754158;
import net.minecraft.unmapped.C_8105098;

public class UserListWidget
extends C_1630332 {
    private final FriendsScreen screen;
    private final List<UserListEntry> entries = new ArrayList<UserListEntry>();
    private int selectedEntry = -1;

    public UserListWidget(FriendsScreen screen, C_8105098 client, int width, int height, int top, int bottom, int entryHeight) {
        super(client, width, height, top, bottom, entryHeight);
        this.screen = screen;
    }

    public void setUsers(List<User> users) {
        users.forEach(user -> this.addEntry(new UserListEntry((User)user)));
    }

    public void addEntry(UserListEntry entry) {
        this.entries.add(entry.init(this.screen));
    }

    protected int m_3791031() {
        return this.entries.size();
    }

    public int m_6519286() {
        return super.m_6519286() + 85;
    }

    protected int m_3021017() {
        return super.m_3021017() + 30;
    }

    protected boolean m_5993229(int i) {
        return i == this.selectedEntry;
    }

    public C_1630332.C_8277969 m_7118949(int i) {
        return this.entries.get(i);
    }

    public UserListEntry getSelectedEntry() {
        if (this.getSelected() < 0) {
            return null;
        }
        return this.entries.get(this.getSelected());
    }

    public int getSelected() {
        return this.selectedEntry;
    }

    public void setSelected(int i) {
        this.selectedEntry = i;
    }

    public static class UserListEntry
    extends C_2691939
    implements C_1630332.C_8277969 {
        private final User user;
        private final C_8105098 client = C_8105098.m_0408063();
        private long time;
        private String note;
        private FriendsScreen screen;
        private boolean outgoingRequest;

        public UserListEntry(User user, String note) {
            this(user);
            this.note = String.valueOf(C_1945050.f_8012292) + note;
        }

        public UserListEntry(User user) {
            this.user = user;
        }

        public UserListEntry init(FriendsScreen screen) {
            this.screen = screen;
            return this;
        }

        public UserListEntry outgoing() {
            this.outgoingRequest = true;
            return this;
        }

        public void m_1433237(int i, int j, int k) {
        }

        public void m_2013749(int index, int x, int y, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered) {
            if (this.user.isSystem()) {
                String fronters = this.user.getSystem().getFronters().stream().map(PkSystem.Member::getDisplayName).collect(Collectors.joining("/"));
                String tag = String.valueOf(C_1945050.f_8012292) + C_1945050.f_7540461.toString() + "(" + this.user.getSystem().getName() + "/" + this.user.getName() + ")";
                this.client.f_0426313.m_4683674(fronters + " " + tag, x + 3, y + 1, -1);
            } else {
                this.client.f_0426313.m_4683674(this.user.getName(), x + 3 + 33, y + 1, -1);
            }
            if (this.user.getStatus().isOnline() && this.user.getStatus().getActivity() != null) {
                this.client.f_0426313.m_4683674(this.user.getStatus().getTitle(), x + 3 + 33, y + 12, 0x808080);
                this.client.f_0426313.m_4683674(this.user.getStatus().getDescription(), x + 3 + 40, y + 23, 0x808080);
            } else if (this.user.getStatus().getLastOnline() != null) {
                this.client.f_0426313.m_4683674(this.user.getStatus().getLastOnline(), x + 3 + 33, y + 12, 0x808080);
            }
            if (this.note != null) {
                this.client.f_0426313.m_4683674(this.note, x + entryWidth - this.client.f_0426313.m_0040387(this.note) - 4, y + entryHeight - 10, 0x808080);
            }
            C_3754158.m_3323122((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.client.m_1218956().m_5325521(Auth.getInstance().getSkinTexture(this.user.getUuid(), this.user.getName()));
            C_3754158.m_9671730();
            UserListEntry.m_4673442((int)(x - 1), (int)(y - 1), (float)8.0f, (float)8.0f, (int)8, (int)8, (int)33, (int)33, (float)64.0f, (float)64.0f);
            UserListEntry.m_4673442((int)(x - 1), (int)(y - 1), (float)40.0f, (float)8.0f, (int)8, (int)8, (int)33, (int)33, (float)64.0f, (float)64.0f);
            C_3754158.m_5313301();
        }

        public boolean m_3739705(int i, int j, int k, int l, int m, int n) {
            this.screen.select(i);
            if (C_8105098.m_6224581() - this.time < 250L && this.client.f_4601986 == null) {
                this.screen.openChat();
            }
            this.time = C_8105098.m_6224581();
            return false;
        }

        public void m_4703785(int i, int j, int k, int l, int m, int n) {
        }

        @Generated
        public User getUser() {
            return this.user;
        }

        @Generated
        public boolean isOutgoingRequest() {
            return this.outgoingRequest;
        }
    }
}

