/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.api.chat;

import io.github.axolotlclient.api.API;
import io.github.axolotlclient.api.ContextMenu;
import io.github.axolotlclient.api.chat.ChatScreen;
import io.github.axolotlclient.api.requests.ChannelRequest;
import io.github.axolotlclient.api.requests.FriendRequest;
import io.github.axolotlclient.api.types.Channel;
import io.github.axolotlclient.api.types.Relation;
import io.github.axolotlclient.api.types.User;
import io.github.axolotlclient.api.util.AlphabeticalComparator;
import io.github.axolotlclient.modules.auth.Auth;
import io.github.axolotlclient.modules.hud.util.DrawUtil;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.minecraft.unmapped.C_1630332;
import net.minecraft.unmapped.C_2691939;
import net.minecraft.unmapped.C_3020744;
import net.minecraft.unmapped.C_3754158;
import net.minecraft.unmapped.C_8105098;

public class ChatUserListWidget
extends C_1630332 {
    private final List<UserListEntry> entries = new ArrayList<UserListEntry>();
    private final ChatScreen screen;
    private int selectedEntry = -1;

    public ChatUserListWidget(ChatScreen screen, C_8105098 client, int width, int height, int top, int bottom, int entryHeight) {
        super(client, width, height, top, bottom, entryHeight);
        this.screen = screen;
    }

    public void setUsers(List<User> users, Channel channel) {
        users.stream().sorted((u1, u2) -> new AlphabeticalComparator().compare(u1.getName(), u2.getName())).forEach(user -> this.addEntry(new UserListEntry((User)user, channel)));
    }

    protected int m_3021017() {
        return this.f_8129586 + this.f_2695432 / 2 - this.m_6519286() / 2 + 2 + this.f_2695432 - 8;
    }

    protected int m_3791031() {
        return this.entries.size();
    }

    public int m_6519286() {
        return this.f_2695432 - 5;
    }

    public void addEntry(UserListEntry entry) {
        this.entries.add(entry.init(this.screen));
    }

    public C_1630332.C_8277969 m_7118949(int i) {
        return this.entries.get(i);
    }

    protected boolean m_5993229(int i) {
        return i == this.selectedEntry;
    }

    protected void m_6989976(int i, int j) {
        super.m_6989976(i, j);
        C_3754158.m_7547086();
        this.f_3511485.m_1218956().m_5325521(C_2691939.f_9745145);
    }

    public class UserListEntry
    extends C_2691939
    implements C_1630332.C_8277969 {
        private final User user;
        private final C_8105098 client = C_8105098.m_0408063();
        private final Channel channel;
        private long time;
        private ChatScreen screen;

        public UserListEntry(User user, Channel channel) {
            this.user = user;
            this.channel = channel;
        }

        public UserListEntry init(ChatScreen screen) {
            this.screen = screen;
            return this;
        }

        public void m_1433237(int i, int j, int k) {
        }

        public void m_2013749(int index, int x, int y, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered) {
            if (hovered) {
                UserListEntry.m_7865719((int)(x - 2), (int)(y - 1), (int)(x + entryWidth - 3), (int)(y + entryHeight + 1), (int)0x55FFFFFF);
            }
            DrawUtil.drawScrollableText(this.client.f_0426313, this.user.getName(), x + 3 + entryHeight, y + 1, x + entryWidth - 6, y + 1 + this.client.f_0426313.f_6725889 + 2, -1);
            DrawUtil.drawScrollableText(this.client.f_0426313, this.user.getStatus().getTitle(), x + 3 + entryHeight, y + 12, x + entryWidth - 6, y + 12 + this.client.f_0426313.f_6725889 + 2, 0x808080);
            this.client.m_1218956().m_5325521(Auth.getInstance().getSkinTexture(this.user.getUuid(), this.user.getName()));
            C_3754158.m_9671730();
            C_3754158.m_6326777((float)1.0f, (float)1.0f, (float)1.0f);
            UserListEntry.m_4673442((int)x, (int)y, (float)8.0f, (float)8.0f, (int)8, (int)8, (int)entryHeight, (int)entryHeight, (float)64.0f, (float)64.0f);
            UserListEntry.m_4673442((int)x, (int)y, (float)40.0f, (float)8.0f, (int)8, (int)8, (int)entryHeight, (int)entryHeight, (float)64.0f, (float)64.0f);
            C_3754158.m_5313301();
        }

        public boolean m_3739705(int index, int mouseX, int mouseY, int button, int x, int y) {
            ChatUserListWidget.this.selectedEntry = index;
            if (button == 0) {
                if (C_8105098.m_6224581() - this.time >= 250L || this.client.f_4601986 == null) {
                    // empty if block
                }
                this.time = C_8105098.m_6224581();
            } else if (button == 1 && !this.user.equals((Object)API.getInstance().getSelf())) {
                ContextMenu.Builder menu = ContextMenu.builder().title(this.user.getName()).spacer();
                if (!this.channel.isDM()) {
                    menu.entry("api.friends.chat", buttonWidget -> ChannelRequest.getOrCreateDM((User)this.user).whenCompleteAsync((channel, throwable) -> this.client.m_2167033(() -> this.client.m_6408915((C_3020744)new ChatScreen(this.screen.getParent(), (Channel)channel))))).spacer();
                }
                if (this.user.getRelation() != Relation.BLOCKED) {
                    if (this.user.getRelation() != Relation.FRIEND) {
                        menu.entry("api.friends.add", b -> FriendRequest.getInstance().addFriend(this.user.getUuid())).spacer();
                    }
                    menu.entry("api.users.block", buttonWidget -> FriendRequest.getInstance().blockUser(this.user));
                } else {
                    menu.entry("api.users.unblock", buttonWidget -> FriendRequest.getInstance().unblockUser(this.user));
                }
                if (this.channel.getOwner().equals((Object)API.getInstance().getSelf())) {
                    menu.spacer().entry("api.channel.remove_user", b -> ChannelRequest.removeUserFromChannel((Channel)this.channel, (User)this.user));
                }
                this.screen.setContextMenu(menu.build());
                return true;
            }
            return false;
        }

        public void m_4703785(int i, int j, int k, int l, int m, int n) {
        }

        @Generated
        public User getUser() {
            return this.user;
        }
    }
}

