/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.api.chat;

import io.github.axolotlclient.api.API;
import io.github.axolotlclient.api.ChatsSidebar;
import io.github.axolotlclient.api.ContextMenu;
import io.github.axolotlclient.api.ContextMenuScreen;
import io.github.axolotlclient.api.chat.ChatScreen;
import io.github.axolotlclient.api.handlers.ChatHandler;
import io.github.axolotlclient.api.requests.ChannelRequest;
import io.github.axolotlclient.api.types.Channel;
import io.github.axolotlclient.api.types.ChatMessage;
import io.github.axolotlclient.api.types.User;
import io.github.axolotlclient.modules.auth.Auth;
import io.github.axolotlclient.modules.hud.util.DrawUtil;
import io.github.axolotlclient.util.ClientColors;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import lombok.Generated;
import net.minecraft.unmapped.C_1441789;
import net.minecraft.unmapped.C_1630332;
import net.minecraft.unmapped.C_1716360;
import net.minecraft.unmapped.C_3020744;
import net.minecraft.unmapped.C_3390001;
import net.minecraft.unmapped.C_3754158;
import net.minecraft.unmapped.C_6237110;
import net.minecraft.unmapped.C_8105098;

public class ChatWidget
extends C_1630332 {
    private final List<ChatMessage> messages = new ArrayList<ChatMessage>();
    private final List<ChatLine> entries = new ArrayList<ChatLine>();
    private final Channel channel;
    private final C_8105098 client;
    private final ContextMenuScreen screen;
    private int selectedEntry = -1;

    public ChatWidget(Channel channel, int x, int y, int width, int height, ContextMenuScreen screen) {
        super(C_8105098.m_0408063(), width, height, y, y + height, 13);
        this.channel = channel;
        this.client = C_8105098.m_0408063();
        super.m_3867153(x + 5);
        this.m_9693623(false, 0);
        this.screen = screen;
        channel.getMessages().forEach(this::addMessage);
        ChatHandler.getInstance().setMessagesConsumer(chatMessages -> chatMessages.forEach(this::addMessage));
        ChatHandler.getInstance().setMessageConsumer(this::addMessage);
        ChatHandler.getInstance().setEnableNotifications(message -> !message.channelId().equals(channel.getId()));
        this.m_9909453(this.m_6867946());
        this.f_3108331 = false;
    }

    protected int m_3021017() {
        return this.f_8129586 + this.f_2695432 - 6;
    }

    public int m_6519286() {
        return this.f_2695432 - 60;
    }

    public int getX() {
        return this.f_8129586;
    }

    protected boolean m_5993229(int i) {
        return i == this.selectedEntry;
    }

    private void addMessage(ChatMessage message) {
        boolean scrollToBottom;
        List list = this.client.f_0426313.m_0466830(message.content(), this.m_6519286());
        boolean bl = scrollToBottom = this.m_0467656() == this.m_6867946();
        if (!this.messages.isEmpty()) {
            ChatMessage prev = this.messages.get(this.messages.size() - 1);
            if (!prev.sender().equals((Object)message.sender()) || !prev.senderDisplayName().equals(message.senderDisplayName())) {
                this.entries.add(new NameChatLine(message));
            } else if (message.timestamp().getEpochSecond() - prev.timestamp().getEpochSecond() > 150L) {
                this.entries.add(new NameChatLine(message));
            }
        } else {
            this.entries.add(new NameChatLine(message));
        }
        list.forEach(t -> this.entries.add(new ChatLine((String)t, message)));
        this.messages.add(message);
        this.entries.sort(Comparator.comparingLong(c -> c.getOrigin().timestamp().getEpochSecond()));
        if (scrollToBottom) {
            this.m_9909453(this.m_6867946());
        }
        this.messages.sort(Comparator.comparingLong(value -> value.timestamp().getEpochSecond()));
    }

    private void loadMessages() {
        long before = !this.messages.isEmpty() ? this.messages.get(0).timestamp().getEpochSecond() : Instant.now().getEpochSecond();
        ChatHandler.getInstance().getMessagesBefore(this.channel, before);
    }

    public void m_9909453(int i) {
        this.f_1867063 += (float)i;
        if (this.f_1867063 < 0.0f) {
            this.loadMessages();
        }
        this.m_7189774();
        this.f_9208105 = -2;
    }

    public void remove() {
        ChatHandler.getInstance().setMessagesConsumer(ChatHandler.DEFAULT_MESSAGES_CONSUMER);
        ChatHandler.getInstance().setMessageConsumer(ChatHandler.DEFAULT_MESSAGE_CONSUMER);
        ChatHandler.getInstance().setEnableNotifications(ChatHandler.DEFAULT);
    }

    protected void m_2972483(int i, int j, int k, int l) {
        DrawUtil.enableScissor(this.f_8129586, this.f_9975269, this.f_7901480, this.f_9145833);
        super.m_2972483(i, j, k, l);
        DrawUtil.disableScissor();
    }

    public void m_9734698(int mouseX, int mouseY, float delta) {
        if (this.screen.getSelf() instanceof ChatsSidebar) {
            if (this.f_1810131) {
                this.f_9602731 = mouseX;
                this.f_1139530 = mouseY;
                this.m_7189774();
                int m = this.f_8129586 + this.f_2695432 / 2 - this.m_6519286() / 2 + 2;
                int n = this.f_9975269 + 4 - (int)this.f_1867063;
                this.m_2972483(m, n, mouseX, mouseY);
            }
        } else {
            super.m_9734698(mouseX, mouseY, delta);
        }
    }

    public C_1630332.C_8277969 m_7118949(int i) {
        return this.entries.get(i);
    }

    protected int m_3791031() {
        return this.entries.size();
    }

    public class NameChatLine
    extends ChatLine {
        private final String formattedTime;

        public NameChatLine(ChatMessage message) {
            super(new C_1716360(message.senderDisplayName()).m_7551367(new C_6237110().m_5934684(Boolean.valueOf(true))).m_2117196(), message);
            DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("d/M/yyyy H:mm");
            this.formattedTime = DATE_FORMAT.format(message.timestamp().atZone(ZoneId.systemDefault()));
        }

        @Override
        protected void renderExtras(int x, int y, int mouseX, int mouseY) {
            C_3754158.m_5313301();
            C_3754158.m_7547086();
            this.client.m_1218956().m_5325521(Auth.getInstance().getSkinTexture(this.getOrigin().sender().getUuid(), this.getOrigin().sender().getName()));
            NameChatLine.m_4673442((int)(x - 22), (int)y, (float)8.0f, (float)8.0f, (int)8, (int)8, (int)18, (int)18, (float)64.0f, (float)64.0f);
            NameChatLine.m_4673442((int)(x - 22), (int)y, (float)40.0f, (float)8.0f, (int)8, (int)8, (int)18, (int)18, (float)64.0f, (float)64.0f);
            C_3754158.m_9671730();
            this.client.f_0426313.m_4683674(this.formattedTime, this.client.f_0426313.m_0040387(this.getContent()) + x + 5, y, ClientColors.GRAY.toInt());
        }
    }

    public class ChatLine
    extends DrawUtil
    implements C_1630332.C_8277969 {
        protected final C_8105098 client = C_8105098.m_0408063();
        private final String content;
        private final ChatMessage origin;

        public ChatLine(String content, ChatMessage origin) {
            this.content = content;
            this.origin = origin;
        }

        public void m_1433237(int i, int j, int k) {
        }

        public boolean m_3739705(int index, int mouseX, int mouseY, int button, int x, int y) {
            if (button == 0) {
                ChatWidget.this.selectedEntry = index;
                return true;
            }
            if (button == 1) {
                ContextMenu.Builder builder = ContextMenu.builder().title(this.origin.sender().getName()).spacer();
                if (!this.origin.sender().equals((Object)API.getInstance().getSelf())) {
                    builder.entry("api.friends.chat", buttonWidget -> ChannelRequest.getOrCreateDM((User)this.origin.sender()).whenCompleteAsync((channel, throwable) -> this.client.m_2167033(() -> this.client.m_6408915((C_3020744)new ChatScreen(ChatWidget.this.screen.getParent(), (Channel)channel))))).spacer();
                }
                builder.entry("api.chat.report.message", buttonWidget -> {
                    C_3020744 previous = this.client.f_0723335;
                    this.client.m_6408915((C_3020744)new C_1441789((b, i) -> {
                        if (b) {
                            ChatHandler.getInstance().reportMessage(this.origin);
                        }
                        this.client.m_6408915(previous);
                    }, C_3390001.m_2053009((String)"api.channels.confirm_report", (Object[])new Object[0]), C_3390001.m_2053009((String)"api.channels.confirm_report.desc", (Object[])new Object[]{this.origin.content()}), 0));
                }).spacer().entry("action.copy", buttonWidget -> C_3020744.m_5360526((String)this.origin.content()));
                ChatWidget.this.screen.setContextMenu(builder.build());
                return true;
            }
            return false;
        }

        public void m_4703785(int i, int j, int k, int l, int m, int n) {
        }

        protected void renderExtras(int x, int y, int mouseX, int mouseY) {
        }

        public void m_2013749(int index, int x, int y, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered) {
            for (int i = 0; i < ChatWidget.this.entries.size(); ++i) {
                ChatLine l = ChatWidget.this.entries.get(i);
                if (!l.getOrigin().equals((Object)this.origin) || ChatWidget.this.m_3816410(mouseX, mouseY) != i) continue;
                hovered = true;
                break;
            }
            if (hovered && !ChatWidget.this.screen.hasContextMenu()) {
                ChatLine.m_7865719((int)(x - 2 - 22), (int)(y - 2), (int)(x + entryWidth + 20), (int)(y + entryHeight - 1), (int)0x33FFFFFF);
                if (index < ChatWidget.this.entries.size() - 1 && ChatWidget.this.entries.get(index + 1).getOrigin().equals((Object)this.origin)) {
                    ChatLine.m_7865719((int)(x - 2 - 22), (int)(y + entryHeight - 1), (int)(x + entryWidth + 20), (int)(y + entryHeight + 2), (int)0x33FFFFFF);
                }
                if (index < ChatWidget.this.entries.size() - 1 && !ChatWidget.this.entries.get(index + 1).getOrigin().equals((Object)this.origin) || index == ChatWidget.this.entries.size() - 1) {
                    ChatLine.m_7865719((int)(x - 2 - 22), (int)(y + entryHeight - 1), (int)(x + entryWidth + 20), (int)(y + entryHeight), (int)0x33FFFFFF);
                }
            }
            this.renderExtras(x, y, mouseX, mouseY);
            this.client.f_0426313.m_4683674(this.content, x, y, -1);
        }

        @Generated
        public String getContent() {
            return this.content;
        }

        @Generated
        public ChatMessage getOrigin() {
            return this.origin;
        }
    }
}

