/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.api.multiplayer;

import com.google.common.hash.Hashing;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.github.axolotlclient.AxolotlClientConfig.api.util.Color;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.vanilla.EntryListWidget;
import io.github.axolotlclient.api.multiplayer.FriendsMultiplayerScreen;
import io.github.axolotlclient.api.multiplayer.ServerInfoUtil;
import io.github.axolotlclient.api.types.PkSystem;
import io.github.axolotlclient.api.types.Status;
import io.github.axolotlclient.api.types.User;
import io.github.axolotlclient.modules.auth.Auth;
import io.github.axolotlclient.util.Util;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.base64.Base64;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import lombok.Generated;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.unmapped.C_0561170;
import net.minecraft.unmapped.C_0979881;
import net.minecraft.unmapped.C_1533205;
import net.minecraft.unmapped.C_1945050;
import net.minecraft.unmapped.C_2691939;
import net.minecraft.unmapped.C_3390001;
import net.minecraft.unmapped.C_3754158;
import net.minecraft.unmapped.C_3779718;
import net.minecraft.unmapped.C_4882708;
import net.minecraft.unmapped.C_8105098;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class FriendsMultiplayerSelectionList
extends EntryListWidget<Entry> {
    private static final int PROTOCOL_VERSION = 47;
    private static final C_0561170 UNKNOWN_SERVER_TEXTURE = new C_0561170("textures/misc/unknown_server.png");
    static final C_0561170 SERVER_SELECTION_TEXTURE = new C_0561170("textures/gui/server_selection.png");
    static final C_0561170 ICONS = new C_0561170("textures/gui/icons.png");
    static final Logger LOGGER = LogManager.getLogger();
    static final ThreadPoolExecutor THREAD_POOL = new ScheduledThreadPoolExecutor(5, new ThreadFactoryBuilder().setNameFormat("Friends Server Pinger #%d").setDaemon(true).setUncaughtExceptionHandler((t, e) -> LOGGER.error("Caught previously unhandled exception :", e)).build());
    static final String CANT_RESOLVE_TEXT = Util.getFormatCode(new Color(-65536)) + C_3390001.m_2053009((String)"multiplayer.status.cannot_resolve", (Object[])new Object[0]);
    static final String CANT_CONNECT_TEXT = Util.getFormatCode(new Color(-65536)) + C_3390001.m_2053009((String)"multiplayer.status.cannot_connect", (Object[])new Object[0]);
    static final String INCOMPATIBLE_STATUS = C_3390001.m_2053009((String)"multiplayer.status.incompatible", (Object[])new Object[0]);
    static final String NO_CONNECTION_STATUS = C_3390001.m_2053009((String)"multiplayer.status.no_connection", (Object[])new Object[0]);
    static final String PINGING_STATUS = C_3390001.m_2053009((String)"multiplayer.status.pinging", (Object[])new Object[0]);
    static final String NOT_PUBLISHED_STATUS = String.valueOf(C_1945050.f_9213701) + C_3390001.m_2053009((String)"api.worldhost.joinability.not_published", (Object[])new Object[0]);
    private final FriendsMultiplayerScreen screen;
    private final List<Entry> friendEntries = new ArrayList<Entry>();
    private final LoadingHeader loadingHeader = new LoadingHeader();
    private static final int STATUS_ICON_HEIGHT = 8;
    private static final int STATUS_ICON_WIDTH = 10;

    public FriendsMultiplayerSelectionList(FriendsMultiplayerScreen screen, C_8105098 minecraft, int width, int height, int y, int itemHeight) {
        super(minecraft, screen.f_5465691, screen.f_3080061, y, y + height, itemHeight);
        this.screen = screen;
        this.addEntry(this.loadingHeader);
    }

    private void refreshEntries() {
        this.clearEntries();
        this.friendEntries.forEach(x$0 -> this.addEntry((EntryListWidget.Entry)x$0));
    }

    public void setSelected(@Nullable Entry entry) {
        super.setSelected((EntryListWidget.Entry)entry);
        this.screen.onSelectedChange();
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        Entry entry = (Entry)this.getSelectedOrNull();
        return entry != null && entry.keyPressed(keyCode, scanCode, modifiers) || super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void updateList(List<User> friends) {
        this.friendEntries.clear();
        for (User friend : friends) {
            if (!friend.getStatus().isOnline()) continue;
            this.friendEntries.add(this.createEntry(friend));
        }
        this.refreshEntries();
    }

    private Entry createEntry(User friend) {
        if (friend.getStatus().getActivity() != null && friend.getStatus().getActivity().hasMetadata()) {
            if (friend.getStatus().getActivity().hasMetadata("external_server")) {
                return this.externalServerEntry(this.screen, friend);
            }
            return this.e4mcServerFriendEntry(this.screen, friend);
        }
        return new StatusFriendEntry(this.screen, friend);
    }

    public void updateEntry(User user) {
        this.friendEntries.stream().filter(e1 -> {
            if (e1 instanceof StatusFriendEntry) {
                StatusFriendEntry statusFriendEntry = (StatusFriendEntry)e1;
                return statusFriendEntry.getUser().equals((Object)user);
            }
            if (e1 instanceof ServerEntry) {
                ServerEntry serverEntry = (ServerEntry)e1;
                return serverEntry.getUser().equals((Object)user);
            }
            return false;
        }).findFirst().ifPresent(e -> {
            this.friendEntries.set(this.friendEntries.indexOf(e), this.createEntry(user));
            this.refreshEntries();
        });
    }

    public int getRowWidth() {
        return 305;
    }

    private ExternalServerFriendEntry externalServerEntry(FriendsMultiplayerScreen screen, User friend) {
        Status.Activity.ExternalServerMetadata metadata = (Status.Activity.ExternalServerMetadata)friend.getStatus().getActivity().metadata().attributes();
        return new ExternalServerFriendEntry(screen, metadata, new C_1533205(metadata.serverName(), metadata.address(), false), friend);
    }

    private E4mcServerFriendEntry e4mcServerFriendEntry(FriendsMultiplayerScreen screen, User friend) {
        Status.Activity activity = friend.getStatus().getActivity();
        Status.Activity.E4mcMetadata metadata = activity.hasMetadata("world_host") ? ((Status.Activity.WorldHostMetadata)activity.metadata().attributes()).asE4mcMetadata() : (Status.Activity.E4mcMetadata)activity.metadata().attributes();
        return new E4mcServerFriendEntry(screen, metadata, ServerInfoUtil.getServerData(friend.getName(), metadata), friend);
    }

    @Environment(value=EnvType.CLIENT)
    public static class LoadingHeader
    extends Entry {
        private final C_8105098 minecraft = C_8105098.m_0408063();

        public void render(int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            int i = top + height / 2 - 4;
            String string = switch ((int)(C_8105098.m_6224581() / 300L % 4L)) {
                case 1, 3 -> "o O o";
                case 2 -> "o o O";
                default -> "O o o";
            };
            this.minecraft.f_0426313.m_1950885(string, (float)this.minecraft.f_0723335.f_5465691 / 2.0f - (float)this.minecraft.f_0426313.m_0040387(string) / 2.0f, (float)i, -8355712);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static abstract class Entry
    extends EntryListWidget.Entry<Entry>
    implements AutoCloseable {
        private boolean focused;

        @Override
        public void close() {
        }

        public boolean canJoin() {
            return false;
        }

        public C_1533205 getServerData() {
            return null;
        }

        public boolean isFocused() {
            return this.focused;
        }

        public void setFocused(boolean b) {
            this.focused = b;
        }
    }

    public class ExternalServerFriendEntry
    extends ServerEntry {
        private final Status.Activity.ExternalServerMetadata statusDescription;

        private ExternalServerFriendEntry(FriendsMultiplayerScreen screen, Status.Activity.ExternalServerMetadata statusDescription, C_1533205 serverData, User friend) {
            super(screen, serverData, friend);
            this.statusDescription = statusDescription;
            this.refreshStatus();
        }

        @Override
        public boolean canJoin() {
            return this.statusDescription.address() != null;
        }
    }

    public class E4mcServerFriendEntry
    extends ServerEntry {
        private final Status.Activity.E4mcMetadata statusDescription;

        protected E4mcServerFriendEntry(FriendsMultiplayerScreen screen, Status.Activity.E4mcMetadata statusDescription, C_1533205 serverData, User friend) {
            super(screen, serverData, friend);
            this.statusDescription = statusDescription;
            this.refreshStatus();
        }

        @Override
        protected boolean isPublished() {
            return this.statusDescription.domain() != null;
        }

        @Override
        protected void refreshStatus() {
            super.refreshStatus();
            this.serverData.serverInfo.f_2449978 = this.statusDescription.serverInfo().levelName();
        }
    }

    public class StatusFriendEntry
    extends Entry {
        private final User user;

        protected StatusFriendEntry(FriendsMultiplayerScreen screen, User friend) {
            this.user = friend;
        }

        public void render(int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            if (this.user.isSystem()) {
                String fronters = this.user.getSystem().getFronters().stream().map(PkSystem.Member::getDisplayName).collect(Collectors.joining("/"));
                String tag = String.valueOf(C_1945050.f_8012292) + C_1945050.f_7540461.toString() + "(" + this.user.getSystem().getName() + "/" + this.user.getName() + ")" + String.valueOf(C_1945050.f_1149207);
                ((FriendsMultiplayerSelectionList)FriendsMultiplayerSelectionList.this).client.f_0426313.m_4683674(fronters + " " + tag, left + 3, top + 1, -1);
            } else {
                ((FriendsMultiplayerSelectionList)FriendsMultiplayerSelectionList.this).client.f_0426313.m_4683674(this.user.getName(), left + 3 + 32, top + 1, -1);
            }
            if (this.user.getStatus().isOnline() && this.user.getStatus().getActivity() != null) {
                ((FriendsMultiplayerSelectionList)FriendsMultiplayerSelectionList.this).client.f_0426313.m_4683674(this.user.getStatus().getTitle(), left + 3 + 32, top + 12, 0x808080);
                ((FriendsMultiplayerSelectionList)FriendsMultiplayerSelectionList.this).client.f_0426313.m_4683674(this.user.getStatus().getDescription(), left + 3 + 40, top + 23, 0x808080);
            } else if (this.user.getStatus().getLastOnline() != null) {
                ((FriendsMultiplayerSelectionList)FriendsMultiplayerSelectionList.this).client.f_0426313.m_4683674(this.user.getStatus().getLastOnline(), left + 3 + 32, top + 12, 0x808080);
            }
            FriendsMultiplayerSelectionList.this.client.m_1218956().m_5325521(Auth.getInstance().getSkinTexture(this.user));
            C_3754158.m_9671730();
            C_3754158.m_3323122((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            C_2691939.m_4673442((int)(left - 1), (int)(top - 1), (float)8.0f, (float)8.0f, (int)8, (int)8, (int)32, (int)32, (float)64.0f, (float)64.0f);
            C_2691939.m_4673442((int)(left - 1), (int)(top - 1), (float)40.0f, (float)8.0f, (int)8, (int)8, (int)32, (int)32, (float)64.0f, (float)64.0f);
            C_3754158.m_5313301();
        }

        @Generated
        public User getUser() {
            return this.user;
        }
    }

    protected class ServerEntry
    extends Entry {
        private static final int ICON_WIDTH = 32;
        private static final int ICON_HEIGHT = 32;
        private static final int SPACING = 5;
        private static final int STATUS_ICON_WIDTH = 10;
        private static final int STATUS_ICON_HEIGHT = 8;
        private final FriendsMultiplayerScreen screen;
        private final C_8105098 minecraft;
        protected final ServerInfoEx serverData;
        private final C_0561170 iconId;
        private C_3779718 icon;
        private String lastIconBytes;
        private long lastClickTime;
        @Nullable
        private List<String> onlinePlayersTooltip;
        private Sprite statusIcon;
        @Nullable
        private String statusIconTooltip;
        protected final User user;

        protected ServerEntry(FriendsMultiplayerScreen screen, C_1533205 serverData, User user) {
            this.screen = screen;
            this.minecraft = C_8105098.m_0408063();
            this.serverData = new ServerInfoEx(serverData);
            this.iconId = new C_0561170("servers/" + String.valueOf(Hashing.sha1().hashUnencodedChars((CharSequence)(serverData.f_7619058 != null ? serverData.f_7619058 : user.getUuid() + "_" + serverData.f_4296074))) + "/icon");
            this.user = user;
        }

        @Override
        public C_1533205 getServerData() {
            return this.serverData.serverInfo();
        }

        protected void refreshStatus() {
            this.onlinePlayersTooltip = null;
            if (!this.isPublished()) {
                this.serverData.setPingResult(PingResult.UNREACHABLE);
            }
            switch (this.serverData.pingResult().ordinal()) {
                case 0: 
                case 1: {
                    this.statusIcon = Sprite.PING_1_SPRITE;
                    this.statusIconTooltip = PINGING_STATUS;
                    break;
                }
                case 3: {
                    this.statusIcon = Sprite.INCOMPATIBLE_SPRITE;
                    String tooltipString = this.serverData.serverInfo.f_2418160;
                    this.onlinePlayersTooltip = tooltipString != null ? List.of(tooltipString.split("\n")) : null;
                    this.statusIconTooltip = INCOMPATIBLE_STATUS;
                    break;
                }
                case 2: {
                    this.statusIcon = Sprite.UNREACHABLE_SPRITE;
                    if (!this.isPublished()) break;
                    this.statusIconTooltip = NO_CONNECTION_STATUS;
                    break;
                }
                case 4: {
                    this.statusIcon = this.serverData.serverInfo.f_0578448 < 150L ? Sprite.PING_5_SPRITE : (this.serverData.serverInfo.f_0578448 < 300L ? Sprite.PING_4_SPRITE : (this.serverData.serverInfo.f_0578448 < 600L ? Sprite.PING_3_SPRITE : (this.serverData.serverInfo.f_0578448 < 1000L ? Sprite.PING_2_SPRITE : Sprite.PING_1_SPRITE)));
                    this.statusIconTooltip = C_3390001.m_2053009((String)"multiplayer.status.ping", (Object[])new Object[]{this.serverData.serverInfo.f_0578448});
                    String tooltipStr = this.serverData.serverInfo.f_2418160;
                    this.onlinePlayersTooltip = tooltipStr != null ? List.of(tooltipStr.split("\n")) : null;
                }
            }
        }

        public void render(int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            String bs;
            int i;
            if (this.serverData.pingResult() == PingResult.INITIAL) {
                this.serverData.setPingResult(PingResult.PINGING);
                this.serverData.serverInfo.f_2449978 = "";
                this.serverData.serverInfo.f_8782169 = "";
                THREAD_POOL.submit(() -> {
                    try {
                        this.screen.getPinger().m_5385403(this.serverData.serverInfo);
                    }
                    catch (UnknownHostException var2) {
                        this.serverData.setPingResult(PingResult.UNREACHABLE);
                        this.serverData.serverInfo.f_2449978 = CANT_RESOLVE_TEXT;
                        this.minecraft.m_2167033(this::refreshStatus);
                    }
                    catch (Exception var3) {
                        this.serverData.setPingResult(PingResult.UNREACHABLE);
                        this.serverData.serverInfo.f_2449978 = CANT_CONNECT_TEXT;
                        this.minecraft.m_2167033(this::refreshStatus);
                    }
                });
            }
            if (this.serverData.pingResult == PingResult.PINGING && this.serverData.serverInfo.f_0578448 != -2L) {
                this.serverData.setPingResult(this.serverData.serverInfo.f_9567457 == 47 ? PingResult.SUCCESSFUL : PingResult.INCOMPATIBLE);
            }
            this.refreshStatus();
            this.minecraft.f_0426313.m_1950885(this.serverData.serverInfo.f_4296074, (float)(left + 32 + 3), (float)(top + 1), -1);
            List list = this.minecraft.f_0426313.m_0466830(this.serverData.serverInfo.f_2449978, width - 32 - 2);
            for (i = 0; i < Math.min(list.size(), 2); ++i) {
                this.minecraft.f_0426313.m_1950885((String)list.get(i), (float)(left + 32 + 3), (float)(top + 12 + 9 * i), -8355712);
            }
            C_3754158.m_3323122((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            FriendsMultiplayerSelectionList.this.client.m_1218956().m_5325521(this.icon != null ? this.iconId : UNKNOWN_SERVER_TEXTURE);
            C_2691939.m_5935491((int)left, (int)top, (float)0.0f, (float)0.0f, (int)32, (int)32, (float)32.0f, (float)32.0f);
            FriendsMultiplayerSelectionList.this.client.m_1218956().m_5325521(Auth.getInstance().getSkinTexture(this.user));
            C_3754158.m_9671730();
            C_2691939.m_4673442((int)(left + 32 - 10), (int)(top + 32 - 10), (float)8.0f, (float)8.0f, (int)8, (int)8, (int)10, (int)10, (float)64.0f, (float)64.0f);
            C_2691939.m_4673442((int)(left + 32 - 10), (int)(top + 32 - 10), (float)40.0f, (float)8.0f, (int)8, (int)8, (int)10, (int)10, (float)64.0f, (float)64.0f);
            C_3754158.m_5313301();
            if (this.serverData.pingResult() == PingResult.PINGING) {
                i = (int)(C_8105098.m_6224581() / 100L + (long)(index * 2) & 7L);
                if (i > 4) {
                    i = 8 - i;
                }
                this.statusIcon = switch (i) {
                    case 1 -> Sprite.PINGING_2_SPRITE;
                    case 2 -> Sprite.PINGING_3_SPRITE;
                    case 3 -> Sprite.PINGING_4_SPRITE;
                    case 4 -> Sprite.PINGING_5_SPRITE;
                    default -> Sprite.PINGING_1_SPRITE;
                };
            }
            i = left + width - 10 - 5;
            if (this.statusIcon != null) {
                this.statusIcon.draw(i, top);
            }
            if (!Objects.equals(bs = this.serverData.serverInfo.m_6218080(), this.lastIconBytes)) {
                if (this.uploadIcon(bs)) {
                    this.lastIconBytes = bs;
                } else {
                    this.serverData.serverInfo.m_1622917(null);
                }
            }
            Object component = !this.isPublished() ? NOT_PUBLISHED_STATUS : (this.serverData.pingResult() == PingResult.INCOMPATIBLE ? String.valueOf(C_1945050.f_9213701) + this.serverData.serverInfo.f_3146804 + String.valueOf(C_1945050.f_1149207) : this.serverData.serverInfo.f_8782169);
            int j = this.minecraft.f_0426313.m_0040387((String)component);
            int k = i - j - 5;
            this.minecraft.f_0426313.m_1950885((String)component, (float)k, (float)(top + 1), -8355712);
            if (this.statusIconTooltip != null && mouseX >= i && mouseX <= i + 10 && mouseY >= top && mouseY <= top + 8) {
                this.screen.setDeferredTooltip(this.statusIconTooltip);
            } else if (this.onlinePlayersTooltip != null && mouseX >= k && mouseX <= k + j && mouseY >= top && mouseY <= top - 1 + 9) {
                this.screen.setDeferredTooltip(this.onlinePlayersTooltip);
            }
            if (this.minecraft.f_9967940.f_6270799 || hovering) {
                int l = mouseX - left;
                int m = mouseY - top;
                if (this.canJoin()) {
                    C_2691939.m_7865719((int)left, (int)top, (int)(left + 32), (int)(top + 32), (int)-1601138544);
                    if (l < 32 && l > 16) {
                        Sprite.JOIN_HIGHLIGHTED_SPRITE.draw(left, top);
                    } else {
                        Sprite.JOIN_SPRITE.draw(left, top);
                    }
                }
            }
        }

        protected boolean isPublished() {
            return true;
        }

        @Override
        public boolean canJoin() {
            return this.serverData.pingResult() == PingResult.SUCCESSFUL && this.isPublished();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean uploadIcon(String iconBytes) {
            if (iconBytes == null) {
                this.minecraft.m_1218956().m_3775266(this.iconId);
                this.icon = null;
            } else {
                ByteBuf buf = Unpooled.copiedBuffer((CharSequence)iconBytes, (Charset)StandardCharsets.UTF_8);
                ByteBuf decoded = Base64.decode((ByteBuf)buf);
                try {
                    BufferedImage image = C_0979881.m_2641486((InputStream)new ByteBufInputStream(decoded));
                    if (image.getWidth() != 64 || image.getHeight() != 64) {
                        throw new IllegalArgumentException("Icon must be 64x64, but was " + image.getWidth() + "x" + image.getHeight());
                    }
                    if (this.icon == null) {
                        this.icon = new C_3779718(image);
                        this.minecraft.m_1218956().m_0381205(this.iconId, (C_4882708)this.icon);
                    }
                    image.getRGB(0, 0, image.getWidth(), image.getHeight(), this.icon.m_1823577(), 0, image.getWidth());
                    this.icon.m_4420833();
                }
                catch (Throwable var3) {
                    LOGGER.error("Invalid icon for server {} ({})", (Object)this.serverData.serverInfo.f_4296074, (Object)this.serverData.serverInfo.f_7619058, (Object)var3);
                    boolean bl = false;
                    return bl;
                }
                finally {
                    buf.release();
                    decoded.release();
                }
            }
            return true;
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            double d = mouseX - (double)FriendsMultiplayerSelectionList.this.getRowLeft();
            double e = mouseY - (double)FriendsMultiplayerSelectionList.this.getRowTop(FriendsMultiplayerSelectionList.this.children().indexOf(this));
            if (d <= 32.0 && d < 32.0 && d > 16.0 && this.canJoin()) {
                this.screen.setSelected(this);
                this.screen.joinSelectedServer();
                return true;
            }
            this.screen.setSelected(this);
            if (C_8105098.m_6224581() - this.lastClickTime < 250L && this.canJoin()) {
                this.screen.joinSelectedServer();
            }
            this.lastClickTime = C_8105098.m_6224581();
            return super.mouseClicked(mouseX, mouseY, button);
        }

        @Override
        public void close() {
            this.minecraft.m_1218956().m_3775266(this.iconId);
        }

        @Generated
        public User getUser() {
            return this.user;
        }
    }

    private static enum Sprite {
        UNREACHABLE_SPRITE(0, 5),
        INCOMPATIBLE_SPRITE(0, 5),
        PING_1_SPRITE(0, 4),
        PING_2_SPRITE(0, 3),
        PING_3_SPRITE(0, 2),
        PING_4_SPRITE(0, 3),
        PING_5_SPRITE(0, 0),
        PINGING_1_SPRITE(10, 0),
        PINGING_2_SPRITE(10, 1),
        PINGING_3_SPRITE(10, 2),
        PINGING_4_SPRITE(10, 3),
        PINGING_5_SPRITE(10, 4),
        JOIN_HIGHLIGHTED_SPRITE(0, 32, 32, 32, SERVER_SELECTION_TEXTURE),
        JOIN_SPRITE(0, 0, 32, 32, SERVER_SELECTION_TEXTURE);

        private final int u;
        private final int v;
        private final int texWidth;
        private final int texHeight;
        private final C_0561170 atlas;

        private Sprite(int u, int v, int texWidth, int texHeight, C_0561170 texture) {
            this.u = u;
            this.v = v;
            this.texWidth = texWidth;
            this.texHeight = texHeight;
            this.atlas = texture;
        }

        private Sprite(int u, int v) {
            this(u, 176 + v * 8, 10, 8, ICONS);
        }

        public void draw(int x, int y) {
            C_3754158.m_3323122((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            C_8105098.m_0408063().m_1218956().m_5325521(this.atlas);
            C_2691939.m_5935491((int)x, (int)y, (float)this.u, (float)this.v, (int)this.texWidth, (int)this.texHeight, (float)256.0f, (float)256.0f);
        }
    }

    protected static enum PingResult {
        INITIAL,
        PINGING,
        UNREACHABLE,
        INCOMPATIBLE,
        SUCCESSFUL;

    }

    protected static final class ServerInfoEx {
        private final C_1533205 serverInfo;
        private PingResult pingResult;

        private ServerInfoEx(C_1533205 serverInfo) {
            this.serverInfo = serverInfo;
            this.pingResult = PingResult.INITIAL;
        }

        public C_1533205 serverInfo() {
            return this.serverInfo;
        }

        public PingResult pingResult() {
            return this.pingResult;
        }

        @Generated
        public void setPingResult(PingResult pingResult) {
            this.pingResult = pingResult;
        }
    }
}

