/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.hud.gui.hud;

import io.github.axolotlclient.AxolotlClientConfig.api.options.Option;
import io.github.axolotlclient.AxolotlClientConfig.api.util.Color;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.BooleanOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.ColorOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.IntegerOption;
import io.github.axolotlclient.bridge.render.AxoRenderContext;
import io.github.axolotlclient.mixin.ChatHudAccessor;
import io.github.axolotlclient.modules.hud.gui.entry.TextHudEntry;
import io.github.axolotlclient.modules.hud.util.DrawPosition;
import java.util.List;
import net.minecraft.unmapped.C_0561170;
import net.minecraft.unmapped.C_1716360;
import net.minecraft.unmapped.C_2848808;
import net.minecraft.unmapped.C_3754158;
import net.minecraft.unmapped.C_4976084;
import net.minecraft.unmapped.C_7225666;
import net.minecraft.unmapped.C_7669754;
import net.minecraft.unmapped.C_8105098;
import net.minecraft.unmapped.C_9550253;
import net.minecraft.unmapped.C_9590849;

public class ChatHud
extends TextHudEntry {
    public static final C_0561170 ID = new C_0561170("axolotlclient", "chathud");
    public final BooleanOption background = new BooleanOption("background", Boolean.valueOf(true));
    public final ColorOption bgColor = new ColorOption("bgcolor", Color.parse((String)"#80000000"));
    public final IntegerOption chatHistory = new IntegerOption("chatHistoryLength", Integer.valueOf(100), Integer.valueOf(10), Integer.valueOf(5000));
    public final ColorOption scrollbarColor = new ColorOption("scrollbarColor", Color.parse((String)"#70CCCCCC"));
    public final IntegerOption lineSpacing = new IntegerOption("lineSpacing", Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(10));
    public final BooleanOption keepMessagesOnDisconnect = new BooleanOption("keep_messages_on_disconnect", Boolean.valueOf(false));
    public final BooleanOption animateChat = new BooleanOption("animate_chat", Boolean.valueOf(false));
    public int ticks;
    private int lastHeight;
    private float percentComplete;
    public int newLines;
    private long prevMillis = System.currentTimeMillis();
    public float animationPercent;
    private final C_8105098 client;

    private void updatePercentage(long diff) {
        if (this.percentComplete < 1.0f) {
            this.percentComplete += 0.004f * (float)diff;
        }
        this.percentComplete = C_4976084.m_7164829((float)this.percentComplete, (float)0.0f, (float)1.0f);
    }

    public ChatHud() {
        super(320, 80, false);
        this.client = (C_8105098)((TextHudEntry)this).client;
    }

    public static int getHeight(float chatHeight) {
        int i = 180;
        int j = 20;
        return C_4976084.m_7192202((float)(chatHeight * (float)(i - j) + (float)j));
    }

    public void resetAnimation() {
        this.percentComplete = 0.0f;
    }

    public void render(AxoRenderContext context, float delta) {
        long current = System.currentTimeMillis();
        long diff = current - this.prevMillis;
        this.prevMillis = current;
        this.updatePercentage(diff);
        float t = this.percentComplete - 1.0f;
        this.animationPercent = C_4976084.m_7164829((float)(1.0f - (float)Math.pow(t, 4.0)), (float)0.0f, (float)1.0f);
        int scrolledLines = ((ChatHudAccessor)this.client.f_3501374.m_8449802()).getScrolledLines();
        List<C_7225666> visibleMessages = ((ChatHudAccessor)this.client.f_3501374.m_8449802()).getVisibleMessages();
        if (this.client.f_9967940.f_6177536 != C_9590849.C_4285597.f_7311895) {
            C_3754158.m_8373640();
            this.scale(context);
            DrawPosition pos = this.getPos();
            int i = this.getVisibleLineCount();
            int j = 0;
            int k = visibleMessages.size();
            if (k > 0) {
                int n;
                int m;
                float g = this.getScale();
                int l = C_4976084.m_4705638((float)((float)this.getWidth() / g));
                C_3754158.m_8373640();
                if (((Boolean)this.animateChat.get()).booleanValue() && !((ChatHudAccessor)this.client.f_3501374.m_8449802()).hasUnreadNewMessages()) {
                    C_3754158.m_3172490((float)0.0f, (float)((9.0f - 9.0f * this.animationPercent) * this.getScale()), (float)0.0f);
                }
                for (m = 0; m + scrolledLines < visibleMessages.size() && m < i; ++m) {
                    int opacity;
                    C_7225666 chatHudLine = visibleMessages.get(m + scrolledLines);
                    if (chatHudLine == null || (n = this.ticks - chatHudLine.m_1145422()) >= 200 && !this.isChatFocused()) continue;
                    double d = C_4976084.m_0987703((double)((1.0 - (double)n / 200.0) * 10.0), (double)0.0, (double)1.0);
                    d *= d;
                    if (((Boolean)this.animateChat.get()).booleanValue() && m + scrolledLines < this.newLines) {
                        d *= (double)this.animationPercent;
                    }
                    ++j;
                    int alpha = Math.max(this.bgColor.get().getAlpha(), this.textColor.get().getAlpha());
                    int n2 = opacity = this.isChatFocused() ? alpha : (int)((double)alpha * d);
                    if (opacity <= 3) continue;
                    int y = pos.y + this.getHeight() - m * (9 + (Integer)this.lineSpacing.get());
                    if (((Boolean)this.background.get()).booleanValue()) {
                        Color bg = this.bgColor.get();
                        if (!this.isChatFocused()) {
                            bg = bg.withAlpha((int)((double)bg.getAlpha() * d));
                        }
                        context.br$fillRect(pos.x, y - (9 + (Integer)this.lineSpacing.get()), l + 4, 9 + (Integer)this.lineSpacing.get(), bg.toInt());
                    }
                    String string = chatHudLine.m_7102466().m_2117196();
                    C_3754158.m_9671730();
                    Color text = this.textColor.get();
                    if (!this.isChatFocused()) {
                        text = text.withAlpha((int)((double)text.getAlpha() * d));
                    }
                    context.br$drawString(string, pos.x, y - 8, text, ((Boolean)this.shadow.get()).booleanValue());
                    C_3754158.m_6191982();
                    C_3754158.m_5313301();
                }
                if (this.isChatFocused()) {
                    m = this.getFontHeight();
                    C_3754158.m_3172490((float)-3.0f, (float)0.0f, (float)0.0f);
                    int r = k * m + k;
                    n = j * m + j;
                    int y = pos.y + this.getHeight() - scrolledLines * n / k;
                    if (((ChatHudAccessor)this.client.f_3501374.m_8449802()).getMessages().size() > this.getVisibleLineCount()) {
                        int height = n * n / r;
                        context.br$fillRect(pos.x, y, 2, -height, this.scrollbarColor.get().toInt());
                    }
                }
                C_3754158.m_2041265();
            }
            C_3754158.m_2041265();
        }
    }

    public void renderComponent(AxoRenderContext context, float delta) {
    }

    public void renderPlaceholderComponent(AxoRenderContext context, float delta) {
        DrawPosition pos = this.getPos();
        if (C_8105098.m_0408063().f_7663840 != null) {
            this.client.f_0426313.m_1950885("<" + C_8105098.m_0408063().f_7663840.m_0699887().m_2117196() + "> OOh! There's my Chat now!", (float)(pos.x + 1), (float)(pos.y + this.getHeight() - 9), -1);
        } else {
            this.client.f_0426313.m_1950885("This is where your new and fresh looking chat will be!", (float)(pos.x + 1), (float)(pos.y + this.getHeight() - 9), -1);
        }
    }

    public int getVisibleLineCount() {
        return ChatHud.getHeight(this.isChatFocused() ? this.client.f_9967940.f_1078661 : this.client.f_9967940.f_4089725) / 9;
    }

    public boolean isChatFocused() {
        return this.client.f_0723335 instanceof C_7669754;
    }

    protected int getFontHeight() {
        return C_4976084.m_7192202((float)C_8105098.m_0408063().f_0426313.f_6725889);
    }

    public C_9550253 getTextAt(int x, int y) {
        List<C_7225666> visibleMessages = ((ChatHudAccessor)this.client.f_3501374.m_8449802()).getVisibleMessages();
        int offsetOnHudX = C_4976084.m_7192202((float)((float)x / this.getScale() - (float)this.getPos().x));
        int offsetOnHudY = C_4976084.m_7192202((float)(-((float)y / this.getScale() - (float)(this.getPos().y + this.height))));
        int scrolledLines = ((ChatHudAccessor)this.client.f_3501374.m_8449802()).getScrolledLines();
        if (offsetOnHudX >= 0 && offsetOnHudY >= 0) {
            int m;
            int l = Math.min(this.getVisibleLineCount(), visibleMessages.size());
            if (offsetOnHudX <= C_4976084.m_7192202((float)((float)this.getWidth() / this.getScale())) && offsetOnHudY < (this.getFontHeight() + (Integer)this.lineSpacing.get()) * l + l && (m = offsetOnHudY / (this.getFontHeight() + (Integer)this.lineSpacing.get()) + scrolledLines) >= 0 && m < visibleMessages.size()) {
                C_7225666 chatHudLine = visibleMessages.get(m);
                int n = 0;
                for (C_9550253 text : chatHudLine.m_7102466()) {
                    if (!(text instanceof C_1716360) || (n += this.client.f_0426313.m_0040387(C_2848808.m_4320233((String)((C_1716360)text).m_0284473(), (boolean)false))) <= offsetOnHudX) continue;
                    return text;
                }
            }
        }
        return null;
    }

    public boolean tickable() {
        return true;
    }

    public boolean overridesF3() {
        return true;
    }

    public void tick() {
        if (this.lastHeight != ChatHud.getHeight(this.client.f_9967940.f_4089725)) {
            this.setHeight(ChatHud.getHeight(this.client.f_9967940.f_4089725));
            this.onBoundsUpdate();
            this.lastHeight = this.getHeight();
        }
    }

    public double getDefaultX() {
        return 0.01;
    }

    public double getDefaultY() {
        return 0.9;
    }

    public C_0561170 getId() {
        return ID;
    }

    public List<Option<?>> getConfigurationOptions() {
        List options = super.getConfigurationOptions();
        options.add(this.background);
        options.add(this.bgColor);
        options.add(this.lineSpacing);
        options.add(this.scrollbarColor);
        options.add(this.chatHistory);
        options.add(this.animateChat);
        options.add(this.keepMessagesOnDisconnect);
        return options;
    }
}

