/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.hud.gui.hud;

import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.AxolotlClientConfig.api.options.Option;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.BooleanOption;
import io.github.axolotlclient.bridge.impl.AxoRenderContextImpl;
import io.github.axolotlclient.bridge.render.AxoRenderContext;
import io.github.axolotlclient.modules.hud.gui.entry.TextHudEntry;
import io.github.axolotlclient.modules.hud.util.DrawPosition;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import net.minecraft.unmapped.C_0561170;
import net.minecraft.unmapped.C_2691939;
import net.minecraft.unmapped.C_3754158;
import net.minecraft.unmapped.C_3779718;
import net.minecraft.unmapped.C_7532262;
import net.minecraft.unmapped.C_8105098;
import net.ornithemc.osl.resource.loader.api.ModResourcePack;

public class PackDisplayHud
extends TextHudEntry {
    public static final C_0561170 ID = new C_0561170("axolotlclient", "packdisplayhud");
    private final List<PackWidget> widgets = new ArrayList<PackWidget>();
    private final List<C_7532262> packs = new ArrayList<C_7532262>();
    private final BooleanOption iconsOnly = new BooleanOption("iconsonly", Boolean.valueOf(false));
    private PackWidget placeholder;

    public PackDisplayHud() {
        super(120, 18, true);
    }

    public void setPacks(List<C_7532262> packs) {
        this.widgets.clear();
        this.packs.clear();
        this.packs.addAll(packs.stream().filter(p -> !(p instanceof ModResourcePack)).toList());
    }

    public void renderComponent(AxoRenderContext context, float f) {
        DrawPosition pos = this.getContentPos();
        if (this.widgets.isEmpty()) {
            this.init();
        }
        int y = pos.y() + 1;
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            this.widgets.get(i).render(pos.x + 1, y);
            y += 17;
        }
        if (y - pos.y() != this.getContentHeight()) {
            this.setContentHeight(y - pos.y());
            this.onBoundsUpdate();
        }
    }

    public void init() {
        this.packs.forEach(pack -> {
            try {
                if (pack.m_3372708() != null) {
                    if (this.packs.size() == 1) {
                        this.widgets.add(new PackWidget((C_7532262)pack));
                    } else if (!pack.m_4900708().equalsIgnoreCase("Default")) {
                        this.widgets.add(new PackWidget((C_7532262)pack));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        AtomicInteger w = new AtomicInteger(20);
        this.widgets.forEach(packWidget -> {
            int textW = C_8105098.m_0408063().f_0426313.m_0040387(packWidget.getName()) + 20;
            if (textW > w.get()) {
                w.set(textW);
            }
        });
        this.setContentWidth(w.get());
        this.setContentHeight(this.widgets.size() * 17 + 1);
        this.onBoundsUpdate();
    }

    public void renderPlaceholderComponent(AxoRenderContext context, float delta) {
        boolean updateBounds = false;
        if (this.getContentHeight() < 18) {
            this.setContentHeight(18);
            updateBounds = true;
        }
        if (this.getContentWidth() < 56) {
            this.setContentWidth(56);
            updateBounds = true;
        }
        if (updateBounds) {
            this.onBoundsUpdate();
        }
        if (this.placeholder == null) {
            this.placeholder = new PackWidget(C_8105098.m_0408063().m_7716675().f_6120754);
        }
        this.placeholder.render(this.getContentPos().x + 1, this.getContentPos().y + 1);
    }

    public List<Option<?>> getConfigurationOptions() {
        List options = super.getConfigurationOptions();
        options.add(this.iconsOnly);
        return options;
    }

    public C_0561170 getId() {
        return ID;
    }

    private class PackWidget {
        private final String name;
        private int texture;

        public PackWidget(C_7532262 pack) {
            this.name = pack.m_4900708();
            try {
                this.texture = new C_3779718(pack.m_3372708()).m_6799083();
            }
            catch (Exception e) {
                AxolotlClient.LOGGER.warn("Pack " + pack.m_4900708() + " somehow threw an error! Please investigate... Does it have an icon?", new Object[0]);
            }
        }

        public void render(int x, int y) {
            if (!((Boolean)PackDisplayHud.this.iconsOnly.get()).booleanValue()) {
                C_3754158.m_3323122((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                C_3754158.m_2768959((int)this.texture);
                C_2691939.m_5935491((int)x, (int)y, (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
            }
            AxoRenderContextImpl.getInstance().br$drawString(this.name, x + 18, y + 8 - 4, PackDisplayHud.this.textColor.get().toInt(), ((Boolean)PackDisplayHud.this.shadow.get()).booleanValue());
        }

        @Generated
        public String getName() {
            return this.name;
        }
    }
}

