/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.hud.gui.hud.vanilla;

import io.github.axolotlclient.AxolotlClientConfig.api.options.Option;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.BooleanOption;
import io.github.axolotlclient.bridge.render.AxoRenderContext;
import io.github.axolotlclient.modules.hud.gui.entry.TextHudEntry;
import io.github.axolotlclient.modules.hud.util.DrawPosition;
import io.github.axolotlclient.modules.hud.util.DrawUtil;
import java.util.List;
import net.minecraft.unmapped.C_0561170;
import net.minecraft.unmapped.C_8105098;

public class DebugCountersHud
extends TextHudEntry {
    public static final C_0561170 ID = new C_0561170("axolotlclient", "debugcountershud");
    private final BooleanOption showCCount = new BooleanOption("debugcounters.ccount", Boolean.valueOf(true));
    private final BooleanOption showECount = new BooleanOption("debugcounters.ecount", Boolean.valueOf(false));
    private final BooleanOption showPCount = new BooleanOption("debugcounters.pcount", Boolean.valueOf(false));
    private final C_8105098 client;

    public DebugCountersHud() {
        super(115, 32, true);
        this.client = (C_8105098)((TextHudEntry)this).client;
    }

    public void renderComponent(AxoRenderContext context, float delta) {
        if (this.client.f_4601986 == null) {
            this.renderPlaceholderComponent(context, delta);
        }
        DrawPosition pos = this.getContentPos();
        int lineY = pos.y() + 2;
        int lineX = pos.x() + 1;
        int xEnd = lineX + 50;
        if (((Boolean)this.showCCount.get()).booleanValue()) {
            xEnd = Math.max(xEnd, DrawUtil.drawString(this.client.f_4021716.m_4313156(), (float)lineX, (float)lineY, this.textColor.get().toInt(), (boolean)((Boolean)this.shadow.get())));
            lineY += 10;
        }
        if (((Boolean)this.showECount.get()).booleanValue()) {
            xEnd = Math.max(xEnd, DrawUtil.drawString(this.client.f_4021716.m_2254866(), (float)lineX, (float)lineY, this.textColor.get().toInt(), (boolean)((Boolean)this.shadow.get())));
            lineY += 10;
        }
        if (((Boolean)this.showPCount.get()).booleanValue()) {
            xEnd = Math.max(xEnd, DrawUtil.drawString("P: " + this.client.f_9322491.m_0882495(), (float)lineX, (float)lineY, this.textColor.get().toInt(), (boolean)((Boolean)this.shadow.get())));
            lineY += 10;
        }
        boolean boundsChanged = false;
        if (lineY != this.getContentHeight() + pos.y()) {
            boundsChanged = true;
            this.setContentHeight(lineY - pos.y());
        }
        if (xEnd != pos.x() + this.getContentWidth()) {
            boundsChanged = true;
            this.setContentWidth(xEnd - pos.x());
        }
        if (boundsChanged) {
            this.onBoundsUpdate();
        }
    }

    public void renderPlaceholderComponent(AxoRenderContext context, float delta) {
        DrawPosition pos = this.getContentPos();
        int lineY = pos.y() + 2;
        int lineX = pos.x() + 1;
        int xEnd = lineX + 50;
        if (((Boolean)this.showCCount.get()).booleanValue()) {
            xEnd = Math.max(xEnd, DrawUtil.drawString("C: 186/15000 (s) D: 10, pC: 000, pU: 00, aB: 20", (float)lineX, (float)lineY, this.textColor.get().toInt(), (boolean)((Boolean)this.shadow.get())));
            lineY += 10;
        }
        if (((Boolean)this.showECount.get()).booleanValue()) {
            xEnd = Math.max(xEnd, DrawUtil.drawString("E: 695/3001, SD: 12", (float)lineX, (float)lineY, this.textColor.get().toInt(), (boolean)((Boolean)this.shadow.get())));
            lineY += 10;
        }
        if (((Boolean)this.showPCount.get()).booleanValue()) {
            xEnd = Math.max(xEnd, DrawUtil.drawString("P: 200", (float)lineX, (float)lineY, this.textColor.get().toInt(), (boolean)((Boolean)this.shadow.get())));
            lineY += 10;
        }
        boolean boundsChanged = false;
        if (lineY != this.getContentHeight() + pos.y()) {
            boundsChanged = true;
            this.setContentHeight(lineY - pos.y());
        }
        if (xEnd != pos.x() + this.getContentWidth()) {
            boundsChanged = true;
            this.setContentWidth(xEnd - pos.x());
        }
        if (boundsChanged) {
            this.onBoundsUpdate();
        }
    }

    public C_0561170 getId() {
        return ID;
    }

    public List<Option<?>> getConfigurationOptions() {
        List options = super.getConfigurationOptions();
        options.add(this.hide);
        options.add(this.showCCount);
        options.add(this.showECount);
        options.add(this.showPCount);
        return options;
    }
}

