/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.hud.snapping;

import io.github.axolotlclient.AxolotlClientConfig.api.util.Color;
import io.github.axolotlclient.modules.hud.util.DrawUtil;
import io.github.axolotlclient.modules.hud.util.Rectangle;
import io.github.axolotlclient.util.ClientColors;
import io.github.axolotlclient.util.Util;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import net.minecraft.unmapped.C_7799337;

public class SnappingHelper {
    private static final Color LINE_COLOR = ClientColors.SELECTOR_BLUE;
    private final int distance = 4;
    private final HashSet<Integer> x = new HashSet();
    private final HashSet<Integer> y = new HashSet();
    private final C_7799337 window;
    private Rectangle current;

    public SnappingHelper(List<Rectangle> rects, Rectangle current) {
        this.addAllRects(rects);
        this.current = current;
        this.window = Util.getWindow();
    }

    public static Optional<Integer> getNearby(int pos, HashSet<Integer> set, int distance) {
        for (Integer integer : set) {
            if (integer - distance > pos || integer + distance < pos) continue;
            return Optional.of(integer);
        }
        return Optional.empty();
    }

    public void addAllRects(List<Rectangle> rects) {
        for (Rectangle rect : rects) {
            this.addRect(rect);
        }
    }

    public void addRect(Rectangle rect) {
        this.x.add(rect.x);
        this.x.add(rect.x + rect.width);
        this.y.add(rect.y);
        this.y.add(rect.y + rect.height);
    }

    public void renderSnaps() {
        Integer cury;
        Integer curx = this.getRawXSnap();
        if (curx != null) {
            DrawUtil.fillRect(new Rectangle(curx.intValue(), 0, 1, (int)this.window.m_6423725()), LINE_COLOR);
        }
        if ((cury = this.getRawYSnap()) != null) {
            DrawUtil.fillRect(new Rectangle(0, cury.intValue(), (int)this.window.m_3624537(), 1), LINE_COLOR);
        }
    }

    public Integer getRawXSnap() {
        Integer xSnap = SnappingHelper.getNearby(this.current.x, this.x, 4).orElse(null);
        if (xSnap != null) {
            return xSnap;
        }
        xSnap = SnappingHelper.getNearby(this.current.x + this.current.width, this.x, 4).orElse(null);
        if (xSnap != null) {
            return xSnap;
        }
        xSnap = this.getHalfXSnap();
        if (xSnap != null) {
            return xSnap;
        }
        return null;
    }

    public Integer getRawYSnap() {
        Integer ySnap = SnappingHelper.getNearby(this.current.y, this.y, 4).orElse(null);
        if (ySnap != null) {
            return ySnap;
        }
        ySnap = SnappingHelper.getNearby(this.current.y + this.current.height, this.y, 4).orElse(null);
        if (ySnap != null) {
            return ySnap;
        }
        ySnap = this.getHalfYSnap();
        if (ySnap != null) {
            return ySnap;
        }
        return null;
    }

    public Integer getHalfXSnap() {
        int pos;
        int width = (int)this.window.m_3624537() / 2;
        if (width - 4 <= (pos = this.current.x + Math.round((float)this.current.width / 2.0f)) && width + 4 >= pos) {
            return width;
        }
        return null;
    }

    public Integer getHalfYSnap() {
        int pos;
        int height = (int)this.window.m_6423725() / 2;
        if (height - 4 <= (pos = this.current.y + Math.round((float)this.current.height / 2.0f)) && height + 4 >= pos) {
            return height;
        }
        return null;
    }

    public void renderAll() {
        for (Integer xval : this.x) {
            DrawUtil.fillRect(new Rectangle(xval.intValue(), 0, 1, (int)this.window.m_6423725()), ClientColors.WHITE);
        }
        for (Integer yval : this.y) {
            DrawUtil.fillRect(new Rectangle(0, yval.intValue(), (int)this.window.m_3624537(), 1), ClientColors.WHITE);
        }
    }

    public Integer getCurrentXSnap() {
        Integer xSnap = SnappingHelper.getNearby(this.current.x, this.x, 4).orElse(null);
        if (xSnap != null) {
            return xSnap;
        }
        xSnap = SnappingHelper.getNearby(this.current.x + this.current.width, this.x, 4).orElse(null);
        if (xSnap != null) {
            return xSnap - this.current.width;
        }
        xSnap = this.getHalfXSnap();
        if (xSnap != null) {
            return xSnap - this.current.width / 2;
        }
        return null;
    }

    public Integer getCurrentYSnap() {
        Integer ySnap = SnappingHelper.getNearby(this.current.y, this.y, 4).orElse(null);
        if (ySnap != null) {
            return ySnap;
        }
        ySnap = SnappingHelper.getNearby(this.current.y + this.current.height, this.y, 4).orElse(null);
        if (ySnap != null) {
            return ySnap - this.current.height;
        }
        ySnap = this.getHalfYSnap();
        if (ySnap != null) {
            return ySnap - this.current.height / 2;
        }
        return null;
    }

    @Generated
    public void setCurrent(Rectangle current) {
        this.current = current;
    }
}

