/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.hud.util;

import io.github.axolotlclient.AxolotlClientConfig.api.util.Color;
import io.github.axolotlclient.modules.hud.util.Rectangle;
import net.minecraft.unmapped.C_0561170;
import net.minecraft.unmapped.C_2691939;
import net.minecraft.unmapped.C_3754158;
import net.minecraft.unmapped.C_3831727;
import net.minecraft.unmapped.C_4461663;
import net.minecraft.unmapped.C_5786166;
import net.minecraft.unmapped.C_8105098;
import net.minecraft.unmapped.C_8373595;

public class DrawUtil
extends C_2691939 {
    public static void fillRect(Rectangle rectangle, Color color) {
        DrawUtil.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, color.toInt());
    }

    public static void fillRect(int x, int y, int width, int height, int color) {
        C_2691939.m_7865719((int)x, (int)y, (int)(x + width), (int)(y + height), (int)color);
    }

    public static void outlineRect(Rectangle rectangle, Color color) {
        DrawUtil.outlineRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, color.toInt());
    }

    public static void outlineRect(int x, int y, int width, int height, int color) {
        DrawUtil.fillRect(x, y, 1, height - 1, color);
        DrawUtil.fillRect(x + width - 1, y + 1, 1, height - 1, color);
        DrawUtil.fillRect(x + 1, y, width - 1, 1, color);
        DrawUtil.fillRect(x, y + height - 1, width - 1, 1, color);
    }

    public static void drawCenteredString(C_3831727 renderer, String text, int x, int y, Color color, boolean shadow) {
        DrawUtil.drawCenteredString(renderer, text, x, y, color.toInt(), shadow);
    }

    public static void drawCenteredString(C_3831727 renderer, String text, int x, int y, int color, boolean shadow) {
        DrawUtil.drawString(text, (float)(x - renderer.m_0040387(text) / 2), (float)y, color, shadow);
    }

    public static int drawString(String text, float x, float y, int color, boolean shadow) {
        C_3754158.m_7547086();
        return C_8105098.m_0408063().f_0426313.m_4413321(text, x, y, color, shadow);
    }

    public static int drawString(String text, float x, float y, Color color, boolean shadow) {
        return DrawUtil.drawString(text, x, y, color.toInt(), shadow);
    }

    public static void drawScrollableText(C_3831727 textRenderer, String text, int left, int top, int right, int bottom, int color) {
        int i = textRenderer.m_0040387(text);
        int j = (top + bottom - 9) / 2 + 1;
        int k = right - left;
        if (i > k) {
            int l = i - k;
            double d = (double)C_8105098.m_6224581() / 1000.0;
            double e = Math.max((double)l * 0.5, 3.0);
            double f = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * d / e)) / 2.0 + 0.5;
            double g = f * (double)l;
            DrawUtil.enableScissor(left, top, right, bottom);
            textRenderer.m_1950885(text, (float)(left - (int)g), (float)j, color);
            DrawUtil.disableScissor();
        } else {
            DrawUtil.drawCenteredString(textRenderer, text, (left + right) / 2, j, color, true);
        }
    }

    public static void enableScissor(int x1, int y1, int x2, int y2) {
        io.github.axolotlclient.AxolotlClientConfig.impl.util.DrawUtil.pushScissor((int)x1, (int)y1, (int)(x2 - x1), (int)(y2 - y1));
    }

    public static void disableScissor() {
        io.github.axolotlclient.AxolotlClientConfig.impl.util.DrawUtil.popScissor();
    }

    public static void blitSprite(C_0561170 texture, int x, int y, int width, int height, GuiSpriteScaling guiSpriteScaling) {
        DrawUtil.blitSprite(texture, x, y, width, height, -1, guiSpriteScaling);
    }

    public static void blitSprite(C_0561170 resourceLocation, int x, int y, int width, int height, int color, GuiSpriteScaling guiSpriteScaling) {
        if (guiSpriteScaling instanceof Stretch) {
            DrawUtil.blitSprite(resourceLocation, x, y, width, height, color);
        } else if (guiSpriteScaling instanceof Tile) {
            Tile tile = (Tile)guiSpriteScaling;
            DrawUtil.blitTiledSprite(resourceLocation, x, y, width, height, 0, 0, tile.width(), tile.height(), tile.width(), tile.height(), color);
        } else if (guiSpriteScaling instanceof NineSlice) {
            NineSlice nineSlice = (NineSlice)guiSpriteScaling;
            DrawUtil.blitNineSlicedSprite(resourceLocation, nineSlice, x, y, width, height, color);
        }
    }

    public static void blitSprite(C_0561170 resourceLocation, int texWidth, int texHeight, int u, int v, int x, int y, int width, int height, GuiSpriteScaling guiSpriteScaling) {
        if (guiSpriteScaling instanceof Stretch) {
            DrawUtil.blitSprite(resourceLocation, texWidth, texHeight, u, v, x, y, width, height, -1);
        } else {
            DrawUtil.enableScissor(x, y, x + width, y + height);
            DrawUtil.blitSprite(resourceLocation, x - u, y - v, texWidth, texHeight, -1);
            DrawUtil.disableScissor();
        }
    }

    public static void blitSprite(C_0561170 texture, int x, int y, int width, int height) {
        DrawUtil.blitSprite(texture, x, y, width, height, -1);
    }

    public static void blitSprite(C_0561170 texture, int x, int y, int width, int height, int color) {
        if (width != 0 && height != 0) {
            DrawUtil.innerBlit(texture, x, x + width, y, y + height, 0.0f, 1.0f, 0.0f, 1.0f, color);
        }
    }

    private static void blitSprite(C_0561170 texture, int texWidth, int texHeight, int u, int v, int x, int y, int width, int height, int color) {
        if (width != 0 && height != 0) {
            DrawUtil.innerBlit(texture, x, x + width, y, y + height, (float)u / (float)texWidth, (float)(u + width) / (float)texWidth, (float)v / (float)texHeight, (float)(v + height) / (float)texHeight, color);
        }
    }

    private static void blitNineSlicedSprite(C_0561170 texture, NineSlice nineSlice, int x, int y, int width, int height, int color) {
        Border border = nineSlice.border();
        int borderLeft = Math.min(border.left(), width / 2);
        int borderRight = Math.min(border.right(), width / 2);
        int borderTop = Math.min(border.top(), height / 2);
        int borderBottom = Math.min(border.bottom(), height / 2);
        if (width == nineSlice.width() && height == nineSlice.height()) {
            DrawUtil.blitSprite(texture, nineSlice.width(), nineSlice.height(), 0, 0, x, y, width, height, color);
        } else if (height == nineSlice.height()) {
            DrawUtil.blitSprite(texture, nineSlice.width(), nineSlice.height(), 0, 0, x, y, borderLeft, height, color);
            DrawUtil.blitNineSliceInnerSegment(texture, nineSlice, x + borderLeft, y, width - borderRight - borderLeft, height, borderLeft, 0, nineSlice.width() - borderRight - borderLeft, nineSlice.height(), nineSlice.width(), nineSlice.height(), color);
            DrawUtil.blitSprite(texture, nineSlice.width(), nineSlice.height(), nineSlice.width() - borderRight, 0, x + width - borderRight, y, borderRight, height, color);
        } else if (width == nineSlice.width()) {
            DrawUtil.blitSprite(texture, nineSlice.width(), nineSlice.height(), 0, 0, x, y, width, borderTop, color);
            DrawUtil.blitNineSliceInnerSegment(texture, nineSlice, x, y + borderTop, width, height - borderBottom - borderTop, 0, borderTop, nineSlice.width(), nineSlice.height() - borderBottom - borderTop, nineSlice.width(), nineSlice.height(), color);
            DrawUtil.blitSprite(texture, nineSlice.width(), nineSlice.height(), 0, nineSlice.height() - borderBottom, x, y + height - borderBottom, width, borderBottom, color);
        } else {
            DrawUtil.blitSprite(texture, nineSlice.width(), nineSlice.height(), 0, 0, x, y, borderLeft, borderTop, color);
            DrawUtil.blitNineSliceInnerSegment(texture, nineSlice, x + borderLeft, y, width - borderRight - borderLeft, borderTop, borderLeft, 0, nineSlice.width() - borderRight - borderLeft, borderTop, nineSlice.width(), nineSlice.height(), color);
            DrawUtil.blitSprite(texture, nineSlice.width(), nineSlice.height(), nineSlice.width() - borderRight, 0, x + width - borderRight, y, borderRight, borderTop, color);
            DrawUtil.blitSprite(texture, nineSlice.width(), nineSlice.height(), 0, nineSlice.height() - borderBottom, x, y + height - borderBottom, borderLeft, borderBottom, color);
            DrawUtil.blitNineSliceInnerSegment(texture, nineSlice, x + borderLeft, y + height - borderBottom, width - borderRight - borderLeft, borderBottom, borderLeft, nineSlice.height() - borderBottom, nineSlice.width() - borderRight - borderLeft, borderBottom, nineSlice.width(), nineSlice.height(), color);
            DrawUtil.blitSprite(texture, nineSlice.width(), nineSlice.height(), nineSlice.width() - borderRight, nineSlice.height() - borderBottom, x + width - borderRight, y + height - borderBottom, borderRight, borderBottom, color);
            DrawUtil.blitNineSliceInnerSegment(texture, nineSlice, x, y + borderTop, borderLeft, height - borderBottom - borderTop, 0, borderTop, borderLeft, nineSlice.height() - borderBottom - borderTop, nineSlice.width(), nineSlice.height(), color);
            DrawUtil.blitNineSliceInnerSegment(texture, nineSlice, x + borderLeft, y + borderTop, width - borderRight - borderLeft, height - borderBottom - borderTop, borderLeft, borderTop, nineSlice.width() - borderRight - borderLeft, nineSlice.height() - borderBottom - borderTop, nineSlice.width(), nineSlice.height(), color);
            DrawUtil.blitNineSliceInnerSegment(texture, nineSlice, x + width - borderRight, y + borderTop, borderRight, height - borderBottom - borderTop, nineSlice.width() - borderRight, borderTop, borderRight, nineSlice.height() - borderBottom - borderTop, nineSlice.width(), nineSlice.height(), color);
        }
    }

    private static void blitNineSliceInnerSegment(C_0561170 texture, NineSlice nineSlice, int x, int y, int width, int height, int u, int v, int regionWidth, int regionHeight, int texWidth, int texHeight, int color) {
        if (width > 0 && height > 0) {
            if (nineSlice.stretchInner()) {
                DrawUtil.innerBlit(texture, x, x + width, y, y + height, (float)u / (float)texWidth, (float)(u + regionWidth) / (float)texWidth, (float)v / (float)texHeight, (float)(v + regionHeight) / (float)texHeight, color);
            } else {
                DrawUtil.blitTiledSprite(texture, x, y, width, height, u, v, regionWidth, regionHeight, texWidth, texHeight, color);
            }
        }
    }

    private static void blitTiledSprite(C_0561170 texture, int x, int y, int width, int height, int u, int v, int spriteWidth, int spriteHeight, int nineSliceWidth, int nineSliceHeight, int color) {
        if (width > 0 && height > 0) {
            if (spriteWidth > 0 && spriteHeight > 0) {
                for (int xStep = 0; xStep < width; xStep += spriteWidth) {
                    int i = Math.min(spriteWidth, width - xStep);
                    for (int yStep = 0; yStep < height; yStep += spriteHeight) {
                        int w = Math.min(spriteHeight, height - yStep);
                        DrawUtil.blitSprite(texture, nineSliceWidth, nineSliceHeight, u, v, x + xStep, y + yStep, i, w, color);
                    }
                }
            } else {
                throw new IllegalArgumentException("Tiled sprite texture size must be positive, got " + spriteWidth + "x" + spriteHeight);
            }
        }
    }

    private static void innerBlit(C_0561170 resourceLocation, int x, int x2, int y, int y2, float u, float u2, float v, float v2, int color) {
        C_8105098.m_0408063().m_1218956().m_5325521(resourceLocation);
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        int a = color >> 24 & 0xFF;
        C_3754158.m_3323122((float)r, (float)g, (float)b, (float)a);
        C_5786166 tessellator = C_5786166.m_2065116();
        C_8373595 bufferBuilder = tessellator.m_1454391();
        bufferBuilder.m_0421390(7, C_4461663.f_9223614);
        bufferBuilder.m_3299851((double)x, (double)y2, 0.0).m_4749889((double)u, (double)v2).m_4365807();
        bufferBuilder.m_3299851((double)x2, (double)y2, 0.0).m_4749889((double)u2, (double)v2).m_4365807();
        bufferBuilder.m_3299851((double)x2, (double)y, 0.0).m_4749889((double)u2, (double)v).m_4365807();
        bufferBuilder.m_3299851((double)x, (double)y, 0.0).m_4749889((double)u, (double)v).m_4365807();
        tessellator.m_8222644();
        C_3754158.m_3323122((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface GuiSpriteScaling {
    }

    public record Stretch() implements GuiSpriteScaling
    {
    }

    public record Tile(int width, int height) implements GuiSpriteScaling
    {
    }

    public record NineSlice(int width, int height, Border border, boolean stretchInner) implements GuiSpriteScaling
    {
        public NineSlice(int width, int height, Border border) {
            this(width, height, border, false);
        }

        public NineSlice(int width, int height, int borderSize) {
            this(width, height, new Border(borderSize));
        }
    }

    public record Border(int left, int right, int top, int bottom) {
        public Border(int size) {
            this(size, size, size, size);
        }
    }
}

