/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.hypixel.autoboop;

import com.google.common.collect.ImmutableList;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.ClickableWidget;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.Element;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.TextFieldWidget;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.vanilla.ElementListWidget;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.vanilla.EntryListWidget;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.vanilla.widgets.VanillaButtonWidget;
import io.github.axolotlclient.modules.hypixel.autoboop.FilterListConfigurationScreen;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.unmapped.C_3390001;
import net.minecraft.unmapped.C_8105098;

@Environment(value=EnvType.CLIENT)
public class FiltersList
extends ElementListWidget<Entry> {
    final FilterListConfigurationScreen screen;

    public FiltersList(FilterListConfigurationScreen screen) {
        super(C_8105098.m_0408063(), screen.f_5465691, screen.f_3080061, 33, screen.f_3080061 - 33, 24);
        this.screen = screen;
        this.reload();
    }

    public void reload() {
        this.clearEntries();
        for (String entry : this.screen.filters) {
            this.addEntry((EntryListWidget.Entry)new FilterEntry(entry));
        }
        this.addEntry((EntryListWidget.Entry)new SpacerEntry());
        this.addEntry((EntryListWidget.Entry)new NewEntry());
    }

    protected int getScrollbarPositionX() {
        return this.getRowLeft() + this.getRowWidth() + 10;
    }

    public int getRowWidth() {
        return 340;
    }

    public void apply() {
        this.screen.filters.clear();
        this.screen.filters.addAll(this.children().stream().filter(e -> e instanceof FilterEntry).map(e -> (FilterEntry)((Object)e)).map(e -> e.editBox.getText()).filter(s -> !s.isBlank()).toList());
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.children().stream().filter(e -> e instanceof FilterEntry).map(e -> (FilterEntry)((Object)e)).map(e -> e.editBox).forEach(e -> e.setFocused(false));
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Environment(value=EnvType.CLIENT)
    public class FilterEntry
    extends Entry {
        private static final String REMOVE_BUTTON_TITLE = C_3390001.m_2053009((String)"autoboop.filters.remove", (Object[])new Object[0]);
        private final TextFieldWidget editBox;
        private final ClickableWidget removeButton;

        FilterEntry(String filter) {
            this.editBox = new TextFieldWidget(((FiltersList)FiltersList.this).client.f_0426313, 0, 0, 200, 20, C_3390001.m_2053009((String)"autoboop.filters.edit", (Object[])new Object[0]));
            this.editBox.setText(filter);
            this.editBox.setMaxLength(16);
            this.removeButton = new VanillaButtonWidget(0, 0, 50, 20, REMOVE_BUTTON_TITLE, b -> {
                FiltersList.this.removeEntry((EntryListWidget.Entry)this);
                FiltersList.this.apply();
                FiltersList.this.setScrollAmount(FiltersList.this.getScrollAmount());
            });
        }

        public void render(int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            int i = FiltersList.this.getScrollbarPositionX() - this.removeButton.getWidth() - 10;
            int j = top - 2;
            this.removeButton.setPosition(i, j);
            this.removeButton.render(mouseX, mouseY, partialTick);
            this.editBox.setPosition(left, j);
            this.editBox.setWidth(i - left - 4);
            this.editBox.render(mouseX, mouseY, partialTick);
        }

        public List<? extends Element> children() {
            return ImmutableList.of((Object)this.editBox, (Object)this.removeButton);
        }
    }

    public static class SpacerEntry
    extends Entry {
        public void render(int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
        }

        public List<? extends Element> children() {
            return List.of();
        }
    }

    public class NewEntry
    extends Entry {
        private final ClickableWidget addButton = new VanillaButtonWidget(0, 0, 150, 20, C_3390001.m_2053009((String)"autoboop.filters.add", (Object[])new Object[0]), button -> {
            int i = FiltersList.this.children().indexOf((Object)this);
            FiltersList.this.children().add(Math.max(i - 1, 0), new FilterEntry(""));
            FiltersList.this.apply();
            FiltersList.this.setScrollAmount(Math.max(0, FiltersList.this.getMaxPosition() - (FiltersList.this.bottom - FiltersList.this.top - 4)));
        });

        public void render(int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            int i = FiltersList.this.getScrollbarPositionX() - width / 2 - 10 - this.addButton.getWidth() / 2;
            int j = top - 2;
            this.addButton.setPosition(i, j);
            this.addButton.render(mouseX, mouseY, partialTick);
        }

        public List<? extends Element> children() {
            return List.of(this.addButton);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static abstract class Entry
    extends ElementListWidget.Entry<Entry> {
    }
}

