/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.screenshotUtils;

import io.github.axolotlclient.AxolotlClientConfig.api.util.Colors;
import io.github.axolotlclient.api.API;
import io.github.axolotlclient.api.requests.FriendRequest;
import io.github.axolotlclient.api.requests.UserRequest;
import io.github.axolotlclient.modules.hud.util.DrawUtil;
import io.github.axolotlclient.modules.screenshotUtils.DownloadImageScreen;
import io.github.axolotlclient.modules.screenshotUtils.ImageInstance;
import io.github.axolotlclient.modules.screenshotUtils.ImageScreen;
import io.github.axolotlclient.modules.screenshotUtils.ImageShare;
import io.github.axolotlclient.util.Util;
import io.github.axolotlclient.util.Watcher;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.unmapped.C_1630332;
import net.minecraft.unmapped.C_2348249;
import net.minecraft.unmapped.C_3020744;
import net.minecraft.unmapped.C_3390001;
import net.minecraft.unmapped.C_3754158;
import net.minecraft.unmapped.C_3831727;
import net.minecraft.unmapped.C_4461663;
import net.minecraft.unmapped.C_4976084;
import net.minecraft.unmapped.C_5786166;
import net.minecraft.unmapped.C_8105098;
import net.minecraft.unmapped.C_8373595;

public class GalleryScreen
extends C_3020744 {
    public static final Path SCREENSHOTS_DIR = FabricLoader.getInstance().getGameDir().resolve("screenshots");
    private Tab<?> current;
    private final C_3020744 parent;
    private final Watcher watcher;
    private final String title = C_3390001.m_2053009((String)"gallery.title", (Object[])new Object[0]);
    private static final int entrySpacing = 4;
    private static final int entryWidth = 100;
    private static final int entryHeight = 75;
    private static final int marginLeftRight = 10;
    private boolean isError;
    private boolean online;
    private ImageList area;

    public GalleryScreen(C_3020744 parent) {
        this.parent = parent;
        this.current = Tab.LOCAL;
        this.watcher = Watcher.createSelfTicking((Path)SCREENSHOTS_DIR, () -> {
            if (this.current == Tab.LOCAL) {
                this.m_0116202(this.f_7153641, this.f_5465691, this.f_3080061);
            }
        });
    }

    public void m_7261014(int mouseX, int mouseY, float delta) {
        this.m_7817195();
        this.area.m_9734698(mouseX, mouseY, delta);
        super.m_7261014(mouseX, mouseY, delta);
        if (this.online) {
            this.m_2717572(this.f_2020658, this.title, this.f_5465691 / 2, 18 - this.f_2020658.f_6725889, -1);
            this.m_2717572(this.f_2020658, this.current.title(), this.f_5465691 / 2, 22, -1);
        } else {
            this.m_2717572(this.f_2020658, this.title, this.f_5465691 / 2, 20 - this.f_2020658.f_6725889 / 2, -1);
        }
        if (this.isError) {
            this.m_2717572(this.f_2020658, C_3390001.m_2053009((String)"gallery.error.loading", (Object[])new Object[0]), this.f_5465691 / 2, 36, -1);
        }
    }

    public void m_3356138() {
        super.m_3356138();
        this.area.m_1002325();
    }

    protected void m_7362766(int i, int j, int k) {
        super.m_7362766(i, j, k);
        this.area.m_7379893(i, j, k);
    }

    protected void m_5308748(int i, int j, int k) {
        super.m_5308748(i, j, k);
        this.area.m_9825864(i, j, k);
    }

    public void m_3593494() {
        this.online = API.getInstance().isAuthenticated();
        int columnCount = (this.f_5465691 - 20 + 4 - 13) / 104;
        this.area = new ImageList(this.f_7153641, this.f_5465691, this.f_3080061, 33, this.f_3080061 - 40, 79, columnCount);
        CompletableFuture.runAsync(() -> {
            try {
                this.loadTab(this.current, columnCount, this.area);
            }
            catch (Exception e) {
                this.isError = true;
                this.f_2213969.add(new C_2348249(0, this.f_5465691 / 2 - 75, 36 + this.f_2020658.f_6725889 + 8, 150, 20, C_3390001.m_2053009((String)"gallery.reload", (Object[])new Object[0])));
            }
        });
        int buttonWidth = columnCount <= 5 && this.online ? 100 : 150;
        int footerButtonX = this.online ? this.f_5465691 / 2 - buttonWidth - buttonWidth / 2 - 4 : this.f_5465691 / 2 - buttonWidth - 2;
        int footerButtonY = this.f_3080061 - 16 - 10;
        if (this.online) {
            C_2348249 switchTab = this.current == Tab.SHARED ? new C_2348249(1, footerButtonX, footerButtonY, buttonWidth, 20, C_3390001.m_2053009((String)"gallery.tab.local", (Object[])new Object[0])) : new C_2348249(2, footerButtonX, footerButtonY, buttonWidth, 20, C_3390001.m_2053009((String)"gallery.tab.shared", (Object[])new Object[0]));
            this.f_2213969.add(switchTab);
            footerButtonX += buttonWidth + 4;
        }
        this.f_2213969.add(new C_2348249(3, footerButtonX, footerButtonY, buttonWidth, 20, C_3390001.m_2053009((String)"gallery.download_external", (Object[])new Object[0])));
        this.f_2213969.add(new C_2348249(4, footerButtonX += buttonWidth + 4, footerButtonY, buttonWidth, 20, C_3390001.m_2053009((String)"gui.back", (Object[])new Object[0])));
    }

    protected void m_7971793(C_2348249 buttonWidget) {
        switch (buttonWidget.f_5920996) {
            case 0: {
                this.m_0116202(this.f_7153641, this.f_5465691, this.f_3080061);
                break;
            }
            case 1: {
                this.setTab(Tab.LOCAL);
                break;
            }
            case 2: {
                this.setTab(Tab.SHARED);
                break;
            }
            case 3: {
                this.f_7153641.m_6408915((C_3020744)new DownloadImageScreen(this));
                break;
            }
            case 4: {
                Tab.LOCAL.loadingCache().forEach((path, instance) -> {
                    if (instance != null) {
                        this.f_7153641.m_1218956().m_3775266(instance.id());
                    }
                });
                Tab.LOCAL.loadingCache().clear();
                Tab.SHARED.loadingCache().forEach((s, instance) -> {
                    if (instance != null) {
                        this.f_7153641.m_1218956().m_3775266(instance.id());
                    }
                });
                Tab.SHARED.loadingCache().clear();
                Watcher.close((Watcher)this.watcher);
                this.f_7153641.m_6408915(this.parent);
            }
        }
    }

    private void setTab(Tab<?> tab) {
        this.current = tab;
        this.m_0116202(this.f_7153641, this.f_5465691, this.f_3080061);
    }

    private <T> void loadTab(Tab<T> tab, int columnCount, ImageList area) throws Exception {
        List images = tab.list.call();
        int size = images.size();
        for (int i = 0; i < size; i += columnCount) {
            ImageListEntry row = new ImageListEntry(columnCount, area);
            area.addEntry(row);
            for (int x = 0; x < columnCount && i + x < size; ++x) {
                Object p = images.get(i + x);
                ImageEntry entry = new ImageEntry(100, 75, () -> tab.loader.load(p), row);
                row.add(entry);
            }
        }
    }

    private record Tab<T>(String title, Callable<List<T>> list, Map<T, ImageInstance> loadingCache, Loader<T> loader) {
        private static final Tab<Path> LOCAL = Tab.of(C_3390001.m_2053009((String)"gallery.title.local", (Object[])new Object[0]), () -> {
            try (Stream<Path> screenshots = Files.list(SCREENSHOTS_DIR);){
                List<Path> list = screenshots.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).sorted(Comparator.comparingLong(p -> {
                    try {
                        return Files.getLastModifiedTime(p, new LinkOption[0]).toMillis();
                    }
                    catch (IOException e) {
                        return 0L;
                    }
                }).reversed()).toList();
                return list;
            }
        }, ImageInstance.LocalImpl::new);
        private static final Tab<String> SHARED = Tab.of(C_3390001.m_2053009((String)"gallery.title.shared", (Object[])new Object[0]), () -> (List)((CompletableFuture)FriendRequest.getInstance().getFriendUuids().thenApply(res -> res.stream().map(UserRequest::getUploadedImages).map(CompletableFuture::join).filter(Optional::isPresent).map(Optional::get).reduce(new ArrayList(), (l1, l2) -> {
            l1.addAll(l2);
            return l1;
        }))).join(), url -> ImageShare.getInstance().downloadImage((String)url).join());

        private static <T> Tab<T> of(String title, Callable<List<T>> list, Loader<T> loader) {
            HashMap cache = new HashMap();
            return new Tab<Object>(title, list, cache, o -> {
                if (cache.containsKey(o)) {
                    return (ImageInstance)cache.get(o);
                }
                ImageInstance val = loader.load(o);
                cache.put(o, val);
                return val;
            });
        }

        static interface Loader<T> {
            public ImageInstance load(T var1) throws Exception;
        }
    }

    private static class ImageList
    extends C_1630332 {
        private final int rowWidth;
        private final List<ImageListEntry> entries = new ArrayList<ImageListEntry>();

        public ImageList(C_8105098 minecraft, int screenWidth, int screenHeight, int top, int bottom, int entryHeight, int columns) {
            super(minecraft, screenWidth, screenHeight, top, bottom, entryHeight);
            this.rowWidth = columns * 104 - 4;
        }

        public void addEntry(ImageListEntry entry) {
            this.entries.add(entry);
        }

        public int m_6519286() {
            return this.rowWidth;
        }

        public int getRowLeft() {
            return this.f_8129586 + this.f_2695432 / 2 - this.m_6519286() / 2;
        }

        public void removeEntry(ImageListEntry entry) {
            this.entries.remove(entry);
        }

        public void shiftEntries(ImageListEntry origin) {
            int lastIndex;
            int originIndex = this.entries.indexOf(origin);
            if (originIndex == (lastIndex = this.entries.size() - 1)) {
                return;
            }
            ImageListEntry next = this.entries.get(originIndex + 1);
            origin.add(next.pop());
        }

        protected int m_3021017() {
            return this.getRowLeft() + this.m_6519286() + 6 + 2;
        }

        public boolean isInListContent(int x, int y) {
            return x >= this.f_8129586 && x < this.f_7901480 && y >= this.f_9975269 && y < this.f_9145833;
        }

        public int getY() {
            return this.f_9975269;
        }

        public int getWidth() {
            return this.f_2695432;
        }

        protected int m_3791031() {
            return this.entries.size();
        }

        public int viewHeight() {
            return this.f_9145833 - this.f_9975269;
        }

        public C_1630332.C_8277969 m_7118949(int i) {
            return this.entries.get(i);
        }
    }

    private static class ImageListEntry
    implements C_1630332.C_8277969 {
        private final List<ImageEntry> buttons;
        private final int size;
        private final ImageList list;

        public ImageListEntry(int size, ImageList list) {
            this.size = size;
            this.buttons = new ArrayList<ImageEntry>(size);
            this.list = list;
        }

        public void m_2013749(int index, int left, int top, int width, int height, int mouseX, int mouseY, boolean hovered) {
            if (Math.max(left, this.list.getRowLeft()) <= Math.min(left + width, this.list.getRowLeft() + this.list.getWidth()) - 1 && Math.max(top - height, this.list.getY()) <= Math.min(top + height * 2, this.list.getY() + this.list.viewHeight()) - 1) {
                this.buttons.forEach(e -> {
                    e.f_8532347 = top;
                    e.m_5350167(C_8105098.m_0408063(), mouseX, mouseY);
                });
            } else {
                this.buttons.forEach(e -> {
                    e.f_8532347 = top;
                });
            }
        }

        public void add(ImageEntry e) {
            this.buttons.add(e);
            this.repositionButtons();
        }

        public void remove(ImageEntry e) {
            this.buttons.remove((Object)e);
            if (this.buttons.isEmpty()) {
                this.list.removeEntry(this);
            } else if (this.buttons.size() < this.size) {
                this.list.shiftEntries(this);
            }
            this.repositionButtons();
        }

        private void repositionButtons() {
            int x = this.list.getRowLeft();
            for (ImageEntry e : this.buttons) {
                e.f_3923091 = x;
                x += e.m_8567079() + 4;
            }
        }

        public ImageEntry pop() {
            ImageEntry entry = this.buttons.remove(0);
            if (this.buttons.isEmpty()) {
                this.list.removeEntry(this);
                this.list.m_9909453(0);
            } else if (this.buttons.size() < this.size) {
                this.list.shiftEntries(this);
            }
            this.repositionButtons();
            return entry;
        }

        public void m_1433237(int i, int j, int k) {
        }

        public boolean m_3739705(int i, int j, int k, int l, int m, int n) {
            Optional<ImageEntry> present = this.buttons.stream().filter(C_2348249::m_7131232).findFirst();
            present.ifPresent(ImageEntry::onPress);
            return present.isPresent();
        }

        public void m_4703785(int i, int j, int k, int l, int m, int n) {
        }
    }

    private class ImageEntry
    extends C_2348249 {
        private static final int bgColor = Colors.DARK_GRAY.toInt();
        private static final int accent = Colors.GRAY.withBrightness(0.5f).withAlpha(128).toInt();
        private final C_3831727 font;
        private final Callable<ImageInstance> instanceSupplier;
        private final ImageListEntry row;
        private long loadStart;
        private CompletableFuture<ImageInstance> future;

        protected ImageEntry(int width, int height, Callable<ImageInstance> instanceSupplier, ImageListEntry row) {
            super(99, 0, 0, width, height, "");
            this.instanceSupplier = instanceSupplier;
            this.row = row;
            this.font = C_8105098.m_0408063().f_0426313;
        }

        private CompletableFuture<ImageInstance> load() {
            if (this.future == null) {
                this.loadStart = C_8105098.m_6224581();
                this.future = CompletableFuture.supplyAsync(() -> {
                    try {
                        ImageInstance instance = this.instanceSupplier.call();
                        this.f_4865617 = instance.filename();
                        return instance;
                    }
                    catch (Exception e) {
                        GalleryScreen.this.f_7153641.m_2167033(() -> this.row.remove(this));
                        return null;
                    }
                });
            }
            return this.future;
        }

        public void onPress() {
            GalleryScreen.this.f_7153641.m_6408915(ImageScreen.create(GalleryScreen.this, this.load(), false));
            this.m_1301911(GalleryScreen.this.f_7153641.m_7555106());
        }

        public void m_5350167(C_8105098 client, int mouseX, int mouseY) {
            boolean bl = this.f_8690685 = mouseX >= this.f_3923091 && mouseY >= this.f_8532347 && mouseX < this.f_3923091 + this.f_9527567 && mouseY < this.f_8532347 + this.f_7845401;
            if (this.load().isDone() && this.load().join() != null && client.m_1218956().m_1605001(this.load().join().id()) != null) {
                client.m_1218956().m_5325521(this.load().join().id());
                C_3754158.m_6326777((float)1.0f, (float)1.0f, (float)1.0f);
                ImageEntry.m_5935491((int)this.f_3923091, (int)this.f_8532347, (float)0.0f, (float)0.0f, (int)this.m_8567079(), (int)(this.getHeight() - this.font.f_6725889 - 2), (float)this.m_8567079(), (float)(this.getHeight() - this.font.f_6725889 - 2));
                this.drawScrollingText(this.font, 2, -1);
            } else {
                float delta = (float)this.easeInOutCubic((float)(C_8105098.m_6224581() - this.loadStart) % 1000.0f / 1000.0f);
                ImageEntry.m_7865719((int)(this.getX() + 2), (int)(this.getY() + 2), (int)(this.getXEnd() - 2), (int)(this.getYEnd() - this.font.f_6725889 - 2), (int)bgColor);
                this.drawHorizontalGradient(this.getX() + 2, this.getY() + 2, this.getYEnd() - this.font.f_6725889 - 2, this.lerp(delta, this.getX() + 2, this.getXEnd() - 2));
                ImageEntry.m_7865719((int)(this.getX() + 2), (int)(this.getYEnd() - this.font.f_6725889 - 1), (int)(this.getXEnd() - 2), (int)(this.getYEnd() - 2), (int)bgColor);
                this.drawHorizontalGradient(this.getX() + 2, this.getYEnd() - this.font.f_6725889 - 1, this.getYEnd() - 2, this.lerp(delta, this.getX() + 2, this.getXEnd() - 2));
            }
            DrawUtil.outlineRect(this.getX(), this.getY(), this.m_8567079(), this.getHeight(), this.row.list.isInListContent(mouseX, mouseY) && this.m_7131232() ? -1 : bgColor);
        }

        private int getX() {
            return this.f_3923091;
        }

        private int getY() {
            return this.f_8532347;
        }

        protected int getYEnd() {
            return this.f_8532347 + this.getHeight();
        }

        private int getHeight() {
            return this.f_7845401;
        }

        protected int getXEnd() {
            return this.f_3923091 + this.m_8567079();
        }

        private void drawHorizontalGradient(int x1, int y1, int y2, int x2) {
            C_8373595 consumer = C_5786166.m_2065116().m_1454391();
            consumer.m_0421390(7, C_4461663.f_8459667);
            consumer.m_3299851((double)x1, (double)y1, 0.0).m_9724942(bgColor >> 16 & 0xFF, bgColor >> 8 & 0xFF, bgColor & 0xFF, bgColor >> 24 & 0xFF);
            consumer.m_3299851((double)x1, (double)y2, 0.0).m_9724942(bgColor >> 16 & 0xFF, bgColor >> 8 & 0xFF, bgColor & 0xFF, bgColor >> 24 & 0xFF);
            consumer.m_3299851((double)x2, (double)y2, 0.0).m_9724942(accent >> 16 & 0xFF, accent >> 8 & 0xFF, accent & 0xFF, accent >> 24 & 0xFF);
            consumer.m_3299851((double)x2, (double)y1, 0.0).m_9724942(accent >> 16 & 0xFF, accent >> 8 & 0xFF, accent & 0xFF, accent >> 24 & 0xFF);
            C_5786166.m_2065116().m_8222644();
        }

        private double easeInOutCubic(double x) {
            return x < 0.5 ? 4.0 * x * x * x : 1.0 - Math.pow(-2.0 * x + 2.0, 3.0) / 2.0;
        }

        private int lerp(float delta, int start, int end) {
            return (int)C_4976084.m_7164829((float)Util.lerp(delta, start, end), (float)start, (float)end);
        }

        protected void drawScrollingText(C_3831727 font, int offset, int color) {
            int i = this.f_3923091 + offset;
            int j = this.f_3923091 + this.m_8567079() - offset;
            DrawUtil.drawScrollableText(font, this.f_4865617, i, this.f_8532347 + this.getHeight() - font.f_6725889 - 1, j, this.f_8532347 + this.getHeight(), color);
        }
    }
}

