/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.screenshotUtils;

import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.AxolotlClientCommon;
import io.github.axolotlclient.api.API;
import io.github.axolotlclient.api.util.UUIDHelper;
import io.github.axolotlclient.modules.screenshotUtils.GalleryScreen;
import io.github.axolotlclient.modules.screenshotUtils.ImageInstance;
import io.github.axolotlclient.modules.screenshotUtils.ImageShare;
import io.github.axolotlclient.modules.screenshotUtils.LoadingImageScreen;
import io.github.axolotlclient.modules.screenshotUtils.ScreenshotCopying;
import io.github.axolotlclient.util.GsonHelper;
import io.github.axolotlclient.util.OSUtil;
import io.github.axolotlclient.util.notifications.Notifications;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.imageio.ImageIO;
import net.minecraft.unmapped.C_2348249;
import net.minecraft.unmapped.C_3020744;
import net.minecraft.unmapped.C_3390001;
import net.minecraft.unmapped.C_3754158;
import net.minecraft.unmapped.C_8105098;

public class ImageScreen
extends C_3020744 {
    private final C_3020744 parent;
    private final ImageInstance image;
    private final boolean freeOnClose;
    private final boolean isRemote;
    private final String title;
    private final CompletableFuture<String> uploader;

    static C_3020744 create(C_3020744 parent, CompletableFuture<ImageInstance> future, boolean freeOnClose) {
        if (future.isDone()) {
            if (future.join() != null) {
                return new ImageScreen(parent, future.join(), freeOnClose);
            }
            return parent;
        }
        return new LoadingImageScreen(parent, (CompletableFuture<Void>)future.thenAccept(i -> {
            if (i != null) {
                C_8105098.m_0408063().m_2167033(() -> C_8105098.m_0408063().m_6408915((C_3020744)new ImageScreen(parent, (ImageInstance)i, freeOnClose)));
            } else {
                C_8105098.m_0408063().m_2167033(() -> C_8105098.m_0408063().m_6408915(parent));
            }
        }), freeOnClose);
    }

    private ImageScreen(C_3020744 parent, ImageInstance instance, boolean freeOnClose) {
        this.title = instance.filename();
        this.parent = parent;
        this.image = instance;
        this.freeOnClose = freeOnClose;
        this.isRemote = this.image instanceof ImageInstance.Remote;
        this.uploader = this.isRemote ? UUIDHelper.tryGetUsernameAsync((String)((ImageInstance.Remote)this.image).uploader()) : null;
    }

    public void m_7261014(int mouseX, int mouseY, float delta) {
        this.m_7817195();
        super.m_7261014(mouseX, mouseY, delta);
        if (this.isRemote && this.uploader.isDone()) {
            ImageInstance.Remote r = (ImageInstance.Remote)this.image;
            this.m_2717572(this.f_2020658, this.title, this.f_5465691 / 2, 19 - this.f_2020658.f_6725889 - 2, -1);
            this.m_2717572(this.f_2020658, C_3390001.m_2053009((String)"gallery.image.upload_details", (Object[])new Object[]{this.uploader.join(), r.sharedAt().atZone(ZoneId.systemDefault()).format(AxolotlClientCommon.getInstance().getConfig().getDateTimeFormatter())}), this.f_5465691 / 2, 21, -1);
        } else {
            this.m_2717572(this.f_2020658, this.title, this.f_5465691 / 2, 16 - this.f_2020658.f_6725889 / 2, -1);
        }
    }

    public void m_3593494() {
        int contentsHeight = this.f_3080061 - ((this.isRemote ? 38 : 33) + 33);
        int buttonWidth = 75;
        double imgAspectRatio = (double)this.image.image().getWidth() / (double)this.image.image().getHeight();
        int imageWidth = Math.min((int)((double)contentsHeight * imgAspectRatio), this.f_5465691 - buttonWidth - 4 - 20);
        int imageHeight = (int)((double)imageWidth / imgAspectRatio);
        ImageElement element = new ImageElement(imageWidth, imageHeight);
        this.f_2213969.add(element);
        if (this.f_5465691 / 2 > imageWidth / 2 + buttonWidth + 4) {
            element.setPosition(this.f_5465691 / 2 - imageWidth / 2, 36);
        } else {
            element.setPosition(this.f_5465691 / 2 - imageWidth / 2 - buttonWidth / 2 - 2, 36);
        }
        int actionX = element.f_3923091 + imageWidth + 4;
        ArrayList<C_2348249> actions = new ArrayList<C_2348249>();
        if (this.image instanceof ImageInstance.Local) {
            if (API.getInstance().isAuthenticated() && !(this.image instanceof ImageInstance.Remote)) {
                actions.add(new C_2348249(0, 0, 0, buttonWidth, 20, C_3390001.m_2053009((String)"gallery.image.upload", (Object[])new Object[0])));
            }
            actions.add(new C_2348249(1, 0, 0, buttonWidth, 20, C_3390001.m_2053009((String)"gallery.image.copy", (Object[])new Object[0])));
            actions.add(new C_2348249(2, 0, 0, buttonWidth, 20, C_3390001.m_2053009((String)"gallery.image.open.external", (Object[])new Object[0])));
        }
        if (this.image instanceof ImageInstance.Remote) {
            if (!(this.image instanceof ImageInstance.Local)) {
                actions.add(new C_2348249(3, 0, 0, buttonWidth, 20, C_3390001.m_2053009((String)"gallery.image.save", (Object[])new Object[0])));
                actions.add(new C_2348249(4, 0, 0, buttonWidth, 20, C_3390001.m_2053009((String)"gallery.image.copy", (Object[])new Object[0])));
            }
            actions.add(new C_2348249(5, 0, 0, buttonWidth, 20, C_3390001.m_2053009((String)"gallery.image.open.external.browser", (Object[])new Object[0])));
            actions.add(new C_2348249(6, 0, 0, buttonWidth, 20, C_3390001.m_2053009((String)"gallery.image.copy_url", (Object[])new Object[0])));
        }
        int actionY = element.f_8532347;
        for (C_2348249 w : actions) {
            w.f_3923091 = actionX;
            w.f_8532347 = actionY;
            this.f_2213969.add(w);
            actionY += 24;
        }
        this.f_2213969.add(new C_2348249(7, this.f_5465691 / 2 - 75, this.f_3080061 - 33 + 16 - 10, 150, 20, C_3390001.m_2053009((String)"gui.back", (Object[])new Object[0])));
    }

    protected void m_7971793(C_2348249 b) {
        if (b.f_5920996 == 0) {
            b.f_3831222 = false;
            ImageInstance.Local local = (ImageInstance.Local)this.image;
            ImageShare.getInstance().upload(local.location()).thenAccept(s -> {
                if (s.isEmpty()) {
                    Notifications.getInstance().addStatus("gallery.image.upload.failure", "gallery.image.upload.failure.description", new Object[0]);
                } else {
                    this.f_7153641.m_2167033(() -> this.f_7153641.m_6408915((C_3020744)new ImageScreen(this.parent, local.toShared((String)s, API.getInstance().getSelf().getUuid(), Instant.now()), this.freeOnClose)));
                    ImageScreen.m_5360526((String)s);
                    Notifications.getInstance().addStatus("gallery.image.upload.success", "gallery.image.upload.success.description", s);
                }
            });
        } else if (b.f_5920996 == 1) {
            ImageInstance.Local local = (ImageInstance.Local)this.image;
            ScreenshotCopying.copy((Path)local.location());
        } else if (b.f_5920996 == 2) {
            ImageInstance.Local local = (ImageInstance.Local)this.image;
            OSUtil.getOS().open(local.location().toUri());
        } else if (b.f_5920996 == 3) {
            ImageInstance.Remote remote = (ImageInstance.Remote)this.image;
            b.f_3831222 = false;
            try {
                Path out = this.saveSharedImage(remote);
                this.f_7153641.m_6408915((C_3020744)new ImageScreen(this.parent, remote.toShared(out), this.freeOnClose));
            }
            catch (IOException e) {
                Notifications.getInstance().addStatus("gallery.image.save.failure", "gallery.image.save.failure.description", e.getMessage());
                AxolotlClient.LOGGER.warn("Failed to save shared image!", new Object[]{e});
            }
        } else if (b.f_5920996 == 4) {
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                ImageIO.write((RenderedImage)this.image.image(), "png", baos);
                ScreenshotCopying.copy((byte[])baos.toByteArray());
            }
            catch (IOException e) {
                Notifications.getInstance().addStatus("gallery.image.copy.failure", "gallery.image.copy.failure.description", e.getMessage());
                AxolotlClient.LOGGER.warn("Failed to copy shared image!", new Object[]{e});
            }
        } else if (b.f_5920996 == 5) {
            ImageInstance.Remote remote = (ImageInstance.Remote)this.image;
            OSUtil.getOS().open(remote.url());
        } else if (b.f_5920996 == 6) {
            ImageInstance.Remote remote = (ImageInstance.Remote)this.image;
            ImageScreen.m_5360526((String)remote.url());
        } else if (b.f_5920996 == 7) {
            if (this.freeOnClose) {
                this.f_7153641.m_1218956().m_3775266(this.image.id());
            }
            this.f_7153641.m_6408915(this.parent);
        }
    }

    private Path saveSharedImage(ImageInstance.Remote remote) throws IOException {
        Path out = GalleryScreen.SCREENSHOTS_DIR.resolve("shared").resolve(remote.uploader()).resolve(remote.filename());
        Path infoJson = out.resolveSibling(remote.filename() + ".json");
        Files.createDirectories(out.getParent(), new FileAttribute[0]);
        try (OutputStream s = Files.newOutputStream(out, new OpenOption[0]);){
            ImageIO.write((RenderedImage)remote.image(), "png", s);
        }
        Map<String, Instant> json = Map.of("uploader", remote.uploader(), "shared_at", remote.sharedAt());
        Files.writeString(infoJson, (CharSequence)GsonHelper.GSON.toJson(json), new OpenOption[0]);
        return out;
    }

    private class ImageElement
    extends C_2348249 {
        public ImageElement(int width, int height) {
            super(99, 0, 0, width, height, "");
            this.f_3831222 = false;
        }

        public void m_5350167(C_8105098 client, int mouseX, int mouseY) {
            C_3754158.m_3323122((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            client.m_1218956().m_5325521(ImageScreen.this.image.id());
            ImageElement.m_5935491((int)this.f_3923091, (int)this.f_8532347, (float)0.0f, (float)0.0f, (int)this.m_8567079(), (int)this.getHeight(), (float)this.m_8567079(), (float)this.getHeight());
        }

        private int getHeight() {
            return this.f_7845401;
        }

        public void setPosition(int x, int y) {
            this.f_3923091 = x;
            this.f_8532347 = y;
        }
    }
}

