/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.screenshotUtils;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import io.github.axolotlclient.modules.screenshotUtils.GalleryScreen;
import io.github.axolotlclient.modules.screenshotUtils.ImageInstance;
import io.github.axolotlclient.modules.screenshotUtils.ImageNetworking;
import io.github.axolotlclient.modules.screenshotUtils.ScreenshotUtils;
import io.github.axolotlclient.util.Util;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import javax.imageio.ImageIO;
import lombok.Generated;
import net.minecraft.unmapped.C_1160932;
import net.minecraft.unmapped.C_1716360;
import net.minecraft.unmapped.C_1945050;
import net.minecraft.unmapped.C_3020744;
import net.minecraft.unmapped.C_3390001;
import net.minecraft.unmapped.C_5008376;
import net.minecraft.unmapped.C_6237110;
import net.minecraft.unmapped.C_8529493;
import net.minecraft.unmapped.C_9550253;

public class ImageShare
extends ImageNetworking {
    private static final ImageShare Instance = new ImageShare();

    private ImageShare() {
    }

    public void uploadImage(Path file) {
        Util.addMessageToChatHud((C_9550253)new C_1160932("imageUploadStarted", new Object[0]));
        this.upload(file).whenCompleteAsync((downloadUrl, throwable) -> {
            if (downloadUrl.isEmpty()) {
                Util.addMessageToChatHud((C_9550253)new C_1160932("imageUploadFailure", new Object[0]));
            } else {
                Util.addMessageToChatHud(new C_1716360(C_3390001.m_2053009((String)"imageUploadSuccess", (Object[])new Object[0]) + " ").m_8059675(new C_1716360(downloadUrl).m_7551367(new C_6237110().m_9739860(Boolean.valueOf(true)).m_0282611(C_1945050.f_8162691).m_7701784((C_8529493)new ScreenshotUtils.CustomClickEvent(null, null, (String)downloadUrl){
                    final /* synthetic */ String val$downloadUrl;
                    {
                        this.val$downloadUrl = string;
                        super(action, file);
                    }

                    @Override
                    public void doAction() {
                        C_3020744.m_5360526((String)this.val$downloadUrl);
                    }
                }).m_3975477(new C_5008376(C_5008376.C_4842797.f_5996706, (C_9550253)new C_1716360(C_3390001.m_2053009((String)"clickToCopy", (Object[])new Object[0])))))));
            }
        });
    }

    public CompletableFuture<ImageInstance> downloadImage(String url) {
        return this.download(url).thenApply(data -> {
            if (data == ImageNetworking.ImageData.EMPTY) return null;
            try (ByteArrayInputStream in = new ByteArrayInputStream(data.data());){
                ImageInstance.RemoteImpl remote = new ImageInstance.RemoteImpl(ImageIO.read(in), data.name(), data.uploader(), data.sharedAt(), (String)ImageShare.ensureUrl((String)url).orElseThrow());
                try {
                    Path local = GalleryScreen.SCREENSHOTS_DIR.resolve(remote.filename());
                    HashFunction hash = Hashing.goodFastHash((int)32);
                    if (Files.exists(local, new LinkOption[0]) && hash.hashBytes(data.data()).equals((Object)hash.hashBytes(Files.readAllBytes(local)))) {
                        ImageInstance imageInstance = remote.toShared(local);
                        return imageInstance;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                ImageInstance.RemoteImpl remoteImpl = remote;
                return remoteImpl;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        });
    }

    @Generated
    public static ImageShare getInstance() {
        return Instance;
    }
}

