/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.screenshotUtils;

import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.AxolotlClientConfig.api.options.Option;
import io.github.axolotlclient.AxolotlClientConfig.api.options.OptionCategory;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.BooleanOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.StringArrayOption;
import io.github.axolotlclient.api.API;
import io.github.axolotlclient.modules.AbstractModule;
import io.github.axolotlclient.modules.screenshotUtils.GalleryScreen;
import io.github.axolotlclient.modules.screenshotUtils.ImageInstance;
import io.github.axolotlclient.modules.screenshotUtils.ImageScreen;
import io.github.axolotlclient.modules.screenshotUtils.ImageShare;
import io.github.axolotlclient.modules.screenshotUtils.ScreenshotCopying;
import io.github.axolotlclient.util.OSUtil;
import io.github.axolotlclient.util.Util;
import io.github.axolotlclient.util.options.GenericOption;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BooleanSupplier;
import lombok.Generated;
import net.minecraft.unmapped.C_1160932;
import net.minecraft.unmapped.C_1716360;
import net.minecraft.unmapped.C_1945050;
import net.minecraft.unmapped.C_3020744;
import net.minecraft.unmapped.C_3390001;
import net.minecraft.unmapped.C_5008376;
import net.minecraft.unmapped.C_6237110;
import net.minecraft.unmapped.C_8105098;
import net.minecraft.unmapped.C_8529493;
import net.minecraft.unmapped.C_9550253;
import org.jetbrains.annotations.Nullable;

public class ScreenshotUtils
extends AbstractModule {
    private static final ScreenshotUtils Instance = new ScreenshotUtils();
    private final OptionCategory category = OptionCategory.create((String)"screenshotUtils");
    private final BooleanOption enabled = new BooleanOption("enabled", Boolean.valueOf(false));
    private final GenericOption openViewer = new GenericOption("imageViewer", "openViewer", () -> C_8105098.m_0408063().m_6408915((C_3020744)new GalleryScreen(C_8105098.m_0408063().f_0723335)));
    private final Map<BooleanSupplier, Action> actions = new LinkedHashMap<BooleanSupplier, Action>();
    private StringArrayOption autoExec;

    public void init() {
        this.actions.put(() -> true, new Action("copyAction", C_1945050.f_0440484, "copy_image", ScreenshotCopying::copy));
        this.actions.put(() -> true, new Action("deleteAction", C_1945050.f_3614776, "delete_image", file -> {
            try {
                Files.delete(file);
                Util.addMessageToChatHud((C_9550253)new C_1716360(C_3390001.m_2053009((String)"screenshot_deleted", (Object[])new Object[0]).replace("<name>", file.getFileName().toString())));
            }
            catch (Exception e) {
                AxolotlClient.LOGGER.warn("Couldn't delete Screenshot " + file.getFileName().toString(), new Object[0]);
            }
        }));
        this.actions.put(() -> true, new Action("openAction", C_1945050.f_5887713, "open_image", file -> OSUtil.getOS().open(file.toUri())));
        this.actions.put(() -> true, new Action("viewInGalleryAction", C_1945050.f_3614776, "view_in_gallery", file -> {
            try {
                ImageInstance.LocalImpl instance = new ImageInstance.LocalImpl(file);
                C_8105098.m_0408063().m_2167033(() -> C_8105098.m_0408063().m_6408915(ImageScreen.create(null, CompletableFuture.completedFuture(instance), true)));
            }
            catch (Exception ignored) {
                Util.addMessageToChatHud((C_9550253)new C_1160932("screenshot.gallery.view.error", new Object[0]));
            }
        }));
        this.actions.put(() -> API.getInstance().isAuthenticated(), new Action("uploadAction", C_1945050.f_0440484, "upload_image", ImageShare.getInstance()::uploadImage));
        this.autoExec = new StringArrayOption("autoExec", Util.make(() -> {
            ArrayList<String> names = new ArrayList<String>();
            names.add("off");
            this.actions.forEach((condition, action) -> names.add(action.getName()));
            return names.toArray(new String[0]);
        }), "off");
        this.category.add(new Option[]{this.enabled, this.autoExec, this.openViewer});
        AxolotlClient.config().general.add(new OptionCategory[]{this.category});
    }

    public C_9550253 onScreenshotTaken(C_9550253 text, File shot) {
        C_9550253 t;
        if (((Boolean)this.enabled.get()).booleanValue() && (t = this.getUtilsText(shot.toPath())) != null) {
            return text.m_1643573("\n").m_8059675(t);
        }
        return text;
    }

    @Nullable
    private C_9550253 getUtilsText(Path file) {
        if (!((String)this.autoExec.get()).equals("off")) {
            this.actions.forEach((condition, action) -> {
                if (condition.getAsBoolean() && ((String)this.autoExec.get()).equals(action.getName())) {
                    action.getClickEvent(file).doAction();
                }
            });
            return null;
        }
        C_1716360 message = new C_1716360("");
        this.actions.forEach((arg_0, arg_1) -> ScreenshotUtils.lambda$getUtilsText$13((C_9550253)message, file, arg_0, arg_1));
        return message;
    }

    @Generated
    public static ScreenshotUtils getInstance() {
        return Instance;
    }

    private static /* synthetic */ void lambda$getUtilsText$13(C_9550253 message, Path file, BooleanSupplier condition, Action action) {
        if (condition.getAsBoolean()) {
            message.m_8059675(action.getText(file)).m_1643573(" ");
        }
    }

    public static class Action {
        private final String translationKey;
        private final C_1945050 formatting;
        private final String hoverTextKey;
        private final OnActionCall clickEvent;

        public C_9550253 getText(Path file) {
            return new C_1716360(C_3390001.m_2053009((String)this.translationKey, (Object[])new Object[0])).m_7551367(new C_6237110().m_0282611(this.formatting).m_7701784((C_8529493)this.getClickEvent(file)).m_3975477(new C_5008376(C_5008376.C_4842797.f_5996706, (C_9550253)new C_1716360(C_3390001.m_2053009((String)this.hoverTextKey, (Object[])new Object[0])))));
        }

        public String getName() {
            return this.translationKey;
        }

        public CustomClickEvent getClickEvent(Path file) {
            return new CustomClickEvent(this.clickEvent, file);
        }

        @Generated
        public Action(String translationKey, C_1945050 formatting, String hoverTextKey, OnActionCall clickEvent) {
            this.translationKey = translationKey;
            this.formatting = formatting;
            this.hoverTextKey = hoverTextKey;
            this.clickEvent = clickEvent;
        }
    }

    public static interface OnActionCall {
        public void doAction(Path var1);
    }

    public static class CustomClickEvent
    extends C_8529493 {
        private final OnActionCall action;
        private final Path file;

        public CustomClickEvent(OnActionCall action, Path file) {
            super(C_8529493.C_4892378.m_6936186((String)""), "");
            this.action = action;
            this.file = file;
        }

        public void doAction() {
            if (this.file != null) {
                this.action.doAction(this.file);
            } else {
                AxolotlClient.LOGGER.warn("How'd you manage to do this? Now there's a screenshot ClickEvent without a File attached to it!", new Object[0]);
            }
        }
    }
}

