/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.scrollableTooltips;

import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.AxolotlClientConfig.api.options.Option;
import io.github.axolotlclient.AxolotlClientConfig.api.options.OptionCategory;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.BooleanOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.IntegerOption;
import io.github.axolotlclient.modules.AbstractModule;
import io.github.axolotlclient.util.Util;
import java.util.List;
import lombok.Generated;
import net.minecraft.unmapped.C_3020744;
import org.lwjgl.input.Mouse;

public class ScrollableTooltips
extends AbstractModule {
    private static final ScrollableTooltips instance = new ScrollableTooltips();
    public final BooleanOption enabled = new BooleanOption("enabled", Boolean.valueOf(false));
    public final BooleanOption enableShiftHorizontalScroll = new BooleanOption("shiftHorizontalScroll", Boolean.valueOf(true));
    protected final IntegerOption scrollAmount = new IntegerOption("scrollAmount", Integer.valueOf(5), Integer.valueOf(1), Integer.valueOf(20));
    protected final BooleanOption inverse = new BooleanOption("inverse", Boolean.valueOf(false));
    private final BooleanOption alignToBottom = new BooleanOption("alignToBottom", Boolean.valueOf(false));
    private final OptionCategory category = OptionCategory.create((String)"scrollableTooltips");
    public int tooltipOffsetX;
    public int tooltipOffsetY;
    private boolean alignedToBottom;

    public void init() {
        this.category.add(new Option[]{this.enabled});
        this.category.add(new Option[]{this.enableShiftHorizontalScroll});
        this.category.add(new Option[]{this.scrollAmount});
        this.category.add(new Option[]{this.inverse});
        this.category.add(new Option[]{this.alignToBottom});
        AxolotlClient.config().rendering.add(new OptionCategory[]{this.category});
    }

    public void onRenderTooltip() {
        int i;
        if (((Boolean)this.enabled.get()).booleanValue() && (i = Mouse.getDWheel()) != 0) {
            if (i < 0) {
                this.onScroll(this.applyInverse(false));
            }
            if (i > 0) {
                this.onScroll(this.applyInverse(true));
            }
        }
    }

    public void onScroll(boolean reverse) {
        if (C_3020744.m_5142737()) {
            this.tooltipOffsetX = reverse ? (this.tooltipOffsetX -= ((Integer)this.scrollAmount.get()).intValue()) : (this.tooltipOffsetX += ((Integer)this.scrollAmount.get()).intValue());
        } else {
            this.tooltipOffsetY = reverse ? (this.tooltipOffsetY -= ((Integer)this.scrollAmount.get()).intValue()) : (this.tooltipOffsetY += ((Integer)this.scrollAmount.get()).intValue());
        }
    }

    protected boolean applyInverse(boolean value) {
        if (((Boolean)this.inverse.get()).booleanValue()) {
            return !value;
        }
        return value;
    }

    public void resetScroll() {
        this.alignedToBottom = false;
        this.tooltipOffsetX = 0;
        this.tooltipOffsetY = 0;
    }

    public void alignToScreenBottom(List<String> tooltip, int y) {
        if (((Boolean)this.alignToBottom.get()).booleanValue() && !this.alignedToBottom) {
            int height = tooltip.size() * 10 - 4;
            if (height + y > Util.getWindow().m_5421693()) {
                this.tooltipOffsetY = Util.getWindow().m_5421693() - y - height;
            }
            this.alignedToBottom = true;
        }
    }

    @Generated
    public static ScrollableTooltips getInstance() {
        return instance;
    }
}

