/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.sky;

import com.google.gson.JsonObject;
import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.mixin.TextureManagerAccessor;
import io.github.axolotlclient.mixin.WorldRendererAccessor;
import io.github.axolotlclient.util.Util;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.unmapped.C_0561170;
import net.minecraft.unmapped.C_3754158;
import net.minecraft.unmapped.C_4461663;
import net.minecraft.unmapped.C_4976084;
import net.minecraft.unmapped.C_5091950;
import net.minecraft.unmapped.C_5786166;
import net.minecraft.unmapped.C_8105098;
import net.minecraft.unmapped.C_8373595;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;

public abstract class SkyboxInstance {
    protected final C_0561170 MOON_PHASES = new C_0561170("textures/environment/moon_phases.png");
    protected final C_0561170 SUN = new C_0561170("textures/environment/sun.png");
    protected int blendMode = 1;
    protected boolean alwaysOn;
    protected float maxAlpha = 1.0f;
    protected boolean manualBlend = false;
    protected int blendSrcFactor = 1;
    protected int blendDstFactor = 1;
    protected int blendEquation;
    protected boolean rotate = false;
    protected float rotationSpeed = 1.0f;
    protected float[] rotationStatic = new float[]{0.0f, 0.0f, 0.0f};
    protected float[] rotationAxis = new float[]{0.0f, 0.0f, 0.0f};
    protected boolean showSun = true;
    protected boolean showMoon = true;
    protected boolean showStars = true;
    JsonObject object;
    float alpha = 1.0f;
    C_0561170[] textures = new C_0561170[6];
    int[] fade = new int[4];

    public SkyboxInstance(JsonObject json) {
        this.object = json;
    }

    public float getAlpha() {
        int tempOutTime;
        int tempFullTime;
        int tempInTime;
        if (this.alwaysOn) {
            return 1.0f;
        }
        int currentTime = (int)Objects.requireNonNull(C_8105098.m_0408063().f_4601986).m_2665637() % 24000;
        int durationIn = Util.getTicksBetween(this.fade[0], this.fade[1]);
        int durationOut = Util.getTicksBetween(this.fade[2], this.fade[3]);
        int endFadeIn = this.fade[1] % 24000;
        int startFadeIn = this.fade[0] % 24000;
        if (endFadeIn < startFadeIn) {
            endFadeIn += 24000;
        }
        int startFadeOut = this.fade[2] % 24000;
        int endFadeOut = this.fade[3] % 24000;
        if (startFadeOut < endFadeIn) {
            startFadeOut += 24000;
        }
        if (endFadeOut < startFadeOut) {
            endFadeOut += 24000;
        }
        if ((tempInTime = currentTime) < startFadeIn) {
            tempInTime += 24000;
        }
        if ((tempFullTime = currentTime) < endFadeIn) {
            tempFullTime += 24000;
        }
        if ((tempOutTime = currentTime) < startFadeOut) {
            tempOutTime += 24000;
        }
        float maxPossibleAlpha = startFadeIn < tempInTime && endFadeIn >= tempInTime ? 1.0f - (float)(endFadeIn - tempInTime) / (float)durationIn : (endFadeIn < tempFullTime && startFadeOut >= tempFullTime ? 1.0f : (startFadeOut < tempOutTime && endFadeOut >= tempOutTime ? (float)(endFadeOut - tempOutTime) / (float)durationOut : 0.0f));
        this.alpha = C_4976084.m_7164829((float)(maxPossibleAlpha * this.maxAlpha), (float)0.0f, (float)1.0f);
        return this.alpha;
    }

    protected int parseBlend(String str) {
        if (str == null) {
            return 1;
        }
        return switch (str.toLowerCase(Locale.ENGLISH).trim()) {
            case "alpha" -> 0;
            case "add" -> 1;
            case "subtract" -> 2;
            case "multiply" -> 3;
            case "dodge" -> 4;
            case "burn" -> 5;
            case "screen" -> 6;
            case "overlay" -> 7;
            case "replace" -> 8;
            default -> {
                AxolotlClient.LOGGER.warn("Unknown blend: " + str, new Object[0]);
                yield 1;
            }
        };
    }

    public void render(float delta, float brightness) {
        C_3754158.m_6191982();
        C_3754158.m_9671730();
        C_3754158.m_8373640();
        this.setupBlend(brightness);
        this.setupRotate(delta, brightness);
        this.renderSkybox();
        this.renderDecorations(delta, brightness);
        this.clearBlend(brightness);
        this.clearRotate();
        C_3754158.m_2041265();
        C_3754158.m_2754767();
        C_3754158.m_5313301();
    }

    protected void setupBlend(float brightness) {
        C_3754158.m_6191982();
        C_3754158.m_5313301();
        if (this.manualBlend) {
            C_3754158.m_9671730();
            C_3754158.m_2076358((int)this.blendSrcFactor, (int)this.blendDstFactor);
            GL14.glBlendEquation((int)this.blendEquation);
            C_3754158.m_7547086();
            return;
        }
        switch (this.blendMode) {
            case 0: {
                C_3754158.m_9671730();
                C_3754158.m_2076358((int)770, (int)771);
                break;
            }
            case 1: {
                C_3754158.m_9671730();
                C_3754158.m_2076358((int)770, (int)1);
                break;
            }
            case 2: {
                C_3754158.m_9671730();
                C_3754158.m_2076358((int)775, (int)0);
                break;
            }
            case 3: {
                C_3754158.m_9671730();
                C_3754158.m_2076358((int)774, (int)771);
                break;
            }
            case 4: {
                C_3754158.m_9671730();
                C_3754158.m_2076358((int)1, (int)1);
                break;
            }
            case 5: {
                C_3754158.m_9671730();
                C_3754158.m_2076358((int)0, (int)769);
                break;
            }
            case 6: {
                C_3754158.m_9671730();
                C_3754158.m_2076358((int)1, (int)769);
                break;
            }
            case 7: {
                C_3754158.m_9671730();
                C_3754158.m_2076358((int)774, (int)768);
                break;
            }
            case 8: {
                C_3754158.m_5313301();
            }
        }
        C_3754158.m_3323122((float)1.0f, (float)1.0f, (float)1.0f, (float)brightness);
        C_3754158.m_7547086();
    }

    protected void setupRotate(float delta, float brightness) {
        C_3754158.m_8616673((float)0.0f, (float)this.rotationStatic[0], (float)this.rotationStatic[1], (float)this.rotationStatic[2]);
        if (this.rotate) {
            C_3754158.m_8616673((float)0.0f, (float)this.rotationAxis[0], (float)this.rotationAxis[1], (float)this.rotationAxis[2]);
            C_3754158.m_3323122((float)1.0f, (float)1.0f, (float)1.0f, (float)brightness);
            C_3754158.m_8616673((float)(C_8105098.m_0408063().f_4601986.m_0386667(delta) * this.rotationSpeed), (float)0.0f, (float)1.0f, (float)0.0f);
            C_3754158.m_8616673((float)0.0f, (float)(-this.rotationAxis[0]), (float)(-this.rotationAxis[1]), (float)(-this.rotationAxis[2]));
        }
    }

    public abstract void renderSkybox();

    protected void renderDecorations(float delta, float brightness) {
        float o;
        C_3754158.m_7547086();
        C_3754158.m_9671730();
        C_3754158.m_0833259((int)770, (int)1, (int)1, (int)0);
        C_3754158.m_8373640();
        C_3754158.m_3323122((float)1.0f, (float)1.0f, (float)1.0f, (float)brightness);
        C_3754158.m_8616673((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        C_3754158.m_8616673((float)(C_8105098.m_0408063().f_4601986.m_0386667(delta) * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        C_5786166 tessellator = C_5786166.m_2065116();
        C_8373595 bufferBuilder = tessellator.m_1454391();
        if (this.showSun) {
            o = 30.0f;
            C_8105098.m_0408063().m_1218956().m_5325521(this.SUN);
            bufferBuilder.m_0421390(7, C_4461663.f_9223614);
            bufferBuilder.m_3299851((double)(-o), 100.0, (double)(-o)).m_4749889(0.0, 0.0).m_4365807();
            bufferBuilder.m_3299851((double)o, 100.0, (double)(-o)).m_4749889(1.0, 0.0).m_4365807();
            bufferBuilder.m_3299851((double)o, 100.0, (double)o).m_4749889(1.0, 1.0).m_4365807();
            bufferBuilder.m_3299851((double)(-o), 100.0, (double)o).m_4749889(0.0, 1.0).m_4365807();
            tessellator.m_8222644();
        }
        if (this.showMoon) {
            o = 20.0f;
            C_8105098.m_0408063().m_1218956().m_5325521(this.MOON_PHASES);
            int x = C_8105098.m_0408063().f_4601986.m_3322854();
            int t = x % 4;
            int u = x / 4 % 2;
            float s = (float)t / 4.0f;
            float v = (float)u / 2.0f;
            float w = (float)(t + 1) / 4.0f;
            float y = (float)(u + 1) / 2.0f;
            bufferBuilder.m_0421390(7, C_4461663.f_9223614);
            bufferBuilder.m_3299851((double)(-o), -100.0, (double)o).m_4749889((double)w, (double)y).m_4365807();
            bufferBuilder.m_3299851((double)o, -100.0, (double)o).m_4749889((double)s, (double)y).m_4365807();
            bufferBuilder.m_3299851((double)o, -100.0, (double)(-o)).m_4749889((double)s, (double)v).m_4365807();
            bufferBuilder.m_3299851((double)(-o), -100.0, (double)(-o)).m_4749889((double)w, (double)v).m_4365807();
            tessellator.m_8222644();
        }
        if (this.showStars) {
            C_3754158.m_2090124();
            float z = C_8105098.m_0408063().f_4601986.m_9739314(delta) * brightness;
            if (z > 0.0f) {
                C_3754158.m_3323122((float)z, (float)z, (float)z, (float)z);
                if (((WorldRendererAccessor)C_8105098.m_0408063().f_4021716).getVbo()) {
                    C_5091950 starsBuffer = ((WorldRendererAccessor)C_8105098.m_0408063().f_4021716).getStarsBuffer();
                    starsBuffer.m_4899212();
                    GL11.glEnableClientState((int)32884);
                    GL11.glVertexPointer((int)3, (int)5126, (int)12, (long)0L);
                    starsBuffer.m_2500802(7);
                    starsBuffer.m_7277379();
                    GL11.glDisableClientState((int)32884);
                } else {
                    C_3754158.m_1175393((int)((WorldRendererAccessor)C_8105098.m_0408063().f_4021716).getStarsList());
                }
            }
        }
        C_3754158.m_5313301();
        C_3754158.m_2754767();
        C_3754158.m_2041265();
        C_3754158.m_7547086();
    }

    protected void clearBlend(float brightness) {
        C_3754158.m_6191982();
        C_3754158.m_9671730();
        C_3754158.m_2076358((int)0, (int)1);
        C_3754158.m_3323122((float)1.0f, (float)1.0f, (float)1.0f, (float)brightness);
    }

    protected void clearRotate() {
        C_3754158.m_8616673((float)0.0f, (float)(-this.rotationStatic[0]), (float)(-this.rotationStatic[1]), (float)(-this.rotationStatic[2]));
    }

    public void remove() {
        for (C_0561170 id : this.textures) {
            try {
                C_8105098.m_0408063().m_1218956().m_3775266(id);
                ((TextureManagerAccessor)C_8105098.m_0408063().m_1218956()).getTextures().remove(id);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

