/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.sky;

import io.github.axolotlclient.modules.sky.SkyboxInstance;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Predicate;

public class SkyboxManager {
    public static final double MINIMUM_ALPHA = 0.01;
    private static final SkyboxManager INSTANCE = new SkyboxManager();
    private final ArrayList<SkyboxInstance> skyboxes = new ArrayList();
    private final ArrayList<SkyboxInstance> active_skies = new ArrayList();
    private final Predicate<? super SkyboxInstance> renderPredicate = skybox -> !this.active_skies.contains(skybox) && (double)skybox.getAlpha() >= 0.01;

    public static SkyboxManager getInstance() {
        return INSTANCE;
    }

    public void addSkybox(SkyboxInstance skybox) {
        this.skyboxes.add(Objects.requireNonNull(skybox));
    }

    public void renderSkyboxes(float delta, float brightness) {
        this.skyboxes.stream().filter(this.renderPredicate).forEach(this.active_skies::add);
        this.active_skies.sort((skybox1, skybox2) -> skybox1.alpha >= skybox2.alpha ? 0 : 1);
        this.active_skies.forEach(skyboxInstance -> skyboxInstance.render(delta, brightness));
        this.active_skies.removeIf(skybox -> (double)skybox.alpha <= 0.01);
    }

    public void clearSkyboxes() {
        for (SkyboxInstance skybox : this.skyboxes) {
            skybox.remove();
        }
        this.skyboxes.clear();
        this.active_skies.clear();
    }

    public void removeSkybox(SkyboxInstance skybox) {
        this.skyboxes.remove(skybox);
        if (this.active_skies.contains(skybox)) {
            this.active_skies.remove(skybox);
        }
    }

    public boolean hasSkyBoxes() {
        this.skyboxes.stream().filter(this.renderPredicate).forEach(this.active_skies::add);
        if (this.active_skies.isEmpty()) {
            return false;
        }
        this.active_skies.removeIf(skybox -> (double)skybox.getAlpha() <= 0.01);
        return !this.active_skies.isEmpty();
    }
}

