/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.unfocusedFpsLimiter;

import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.AxolotlClientConfig.api.options.Option;
import io.github.axolotlclient.AxolotlClientConfig.api.options.OptionCategory;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.BooleanOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.FloatOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.IntegerOption;
import io.github.axolotlclient.modules.AbstractModule;
import java.util.concurrent.locks.LockSupport;
import lombok.Generated;
import net.minecraft.unmapped.C_7541710;
import net.minecraft.unmapped.C_8105098;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;

public class UnfocusedFpsLimiter
extends AbstractModule {
    private static final UnfocusedFpsLimiter Instance = new UnfocusedFpsLimiter();
    private final BooleanOption enabled = new BooleanOption("enabled", Boolean.valueOf(false));
    private final BooleanOption reduceFPSWhenUnfocused = new BooleanOption("reduceFPS", Boolean.valueOf(false));
    private final IntegerOption unfocusedFPS = new IntegerOption("unfocusedFPS", Integer.valueOf(10), Integer.valueOf(0), Integer.valueOf(60));
    private final BooleanOption restoreOnHover = new BooleanOption("restoreOnHover", Boolean.valueOf(true));
    private final FloatOption unfocusedVolumeMultiplier = new FloatOption("unfocusedVolumeMultiplier", Float.valueOf(0.25f), Float.valueOf(0.0f), Float.valueOf(1.0f));
    private final FloatOption hiddenVolumeMultiplier = new FloatOption("hiddenVolumeMultiplier", Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f));
    private final BooleanOption runGCOnUnfocus = new BooleanOption("runGCOnUnfocus", Boolean.valueOf(false));
    private boolean isFocused;
    private boolean isVisible;
    private boolean isHovered;
    private long lastRender;
    private boolean wasFocused = true;
    private boolean wasVisible = true;
    private boolean hasRenderedLastFrame = false;

    public void init() {
        OptionCategory category = OptionCategory.create((String)"fpsLimiter");
        category.add(new Option[]{this.enabled, this.reduceFPSWhenUnfocused, this.unfocusedFPS, this.restoreOnHover, this.unfocusedVolumeMultiplier, this.hiddenVolumeMultiplier, this.runGCOnUnfocus});
        AxolotlClient.config().rendering.add(new OptionCategory[]{category});
    }

    public boolean checkForRender() {
        if (!((Boolean)this.enabled.get()).booleanValue()) {
            return true;
        }
        this.isFocused = Display.isActive();
        this.isVisible = Display.isVisible();
        this.isHovered = Mouse.isInsideWindow();
        this.checkForStateChanges();
        long currentTime = C_8105098.m_6224581();
        long timeSinceLastRender = currentTime - this.lastRender;
        if (!this.checkForRender(timeSinceLastRender)) {
            return false;
        }
        this.lastRender = currentTime;
        return true;
    }

    private void checkForStateChanges() {
        if (this.isFocused != this.wasFocused) {
            this.wasFocused = this.isFocused;
            if (this.isFocused) {
                this.onFocus();
            } else {
                this.onUnfocus();
            }
        }
        if (this.isVisible != this.wasVisible) {
            this.wasVisible = this.isVisible;
            if (this.isVisible) {
                this.onAppear();
            } else {
                this.onDisappear();
            }
        }
    }

    private boolean checkForRender(long timeSinceLastRender) {
        boolean shouldSkipRender;
        Integer fpsOverride = this.fpsOverride();
        if (fpsOverride == null) {
            this.hasRenderedLastFrame = false;
            return true;
        }
        if (!this.hasRenderedLastFrame) {
            this.hasRenderedLastFrame = true;
            return true;
        }
        if (fpsOverride == 0) {
            this.idle(1000L);
            return false;
        }
        long frameTime = 1000 / fpsOverride;
        boolean bl = shouldSkipRender = timeSinceLastRender < frameTime;
        if (!shouldSkipRender) {
            return true;
        }
        this.idle(frameTime);
        return false;
    }

    private void onFocus() {
        this.setVolumeMultiplier(1.0f);
    }

    private void onUnfocus() {
        if (this.isVisible) {
            this.setVolumeMultiplier(((Float)this.unfocusedVolumeMultiplier.get()).floatValue());
        }
        if (((Boolean)this.runGCOnUnfocus.get()).booleanValue()) {
            System.gc();
        }
    }

    private void onAppear() {
        if (!this.isFocused) {
            this.setVolumeMultiplier(((Float)this.unfocusedVolumeMultiplier.get()).floatValue());
        }
    }

    private void onDisappear() {
        this.setVolumeMultiplier(((Float)this.hiddenVolumeMultiplier.get()).floatValue());
    }

    @Nullable
    private Integer fpsOverride() {
        if (!this.isVisible) {
            return 0;
        }
        if (((Boolean)this.restoreOnHover.get()).booleanValue() && this.isHovered) {
            return null;
        }
        if (((Boolean)this.reduceFPSWhenUnfocused.get()).booleanValue() && !Display.isActive()) {
            return (Integer)this.unfocusedFPS.get();
        }
        return null;
    }

    private void idle(long waitMillis) {
        long targetMs = System.currentTimeMillis() + waitMillis;
        while (!(Display.isVisible() || Mouse.isInsideWindow() && ((Boolean)this.restoreOnHover.get()).booleanValue() || System.currentTimeMillis() > targetMs)) {
            LockSupport.parkNanos("waiting to render", 30000000L);
        }
    }

    private void setVolumeMultiplier(float multiplier) {
        boolean clientWillPause;
        boolean bl = clientWillPause = !this.isFocused && this.client.f_9967940.f_2500570 && this.client.f_0723335 == null;
        if (multiplier == 0.0f && clientWillPause) {
            return;
        }
        float baseVolume = C_8105098.m_0408063().f_9967940.m_4335136(C_7541710.f_2389417);
        C_8105098.m_0408063().m_7555106().m_0692862(C_7541710.f_2389417, baseVolume * multiplier);
    }

    @Generated
    public static UnfocusedFpsLimiter getInstance() {
        return Instance;
    }
}

