/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.util;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.sdl.SDLMouse;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class WindowAccess {
    private static final boolean GLFW_AVAILABLE = WindowAccess.checkGlfwAvailable();
    private static final boolean SDL_AVAILABLE = WindowAccess.checkSDLAvailable();
    private static final WindowAccess INSTANCE = WindowAccess.create();

    public static boolean isGlfwAvailable() {
        return GLFW_AVAILABLE;
    }

    public static boolean isSdlAvailable() {
        return SDL_AVAILABLE;
    }

    public abstract long createCursor(Cursor var1);

    public abstract void setCursor(long var1);

    public abstract void destroyStandardCursor(long ... var1);

    public abstract boolean rawMouseMotionAvailable();

    public abstract void setRawMouseMotion(boolean var1);

    public static WindowAccess getInstance() {
        return INSTANCE;
    }

    private static boolean checkGlfwAvailable() {
        try {
            Class.forName("org.lwjgl.glfw.GLFW");
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static boolean checkSDLAvailable() {
        try {
            Class.forName("org.lwjgl.sdl.SDL");
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static WindowAccess create() {
        if (GLFW_AVAILABLE) {
            return new GLFWAccess();
        }
        if (SDL_AVAILABLE) {
            return new SDLAccess();
        }
        return new NoOpAccess();
    }

    static final class GLFWAccess
    extends WindowAccess {
        GLFWAccess() {
        }

        @Override
        public long createCursor(Cursor cursor) {
            return GLFW.glfwCreateStandardCursor((int)(switch (cursor.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> 221193;
                case 1 -> 221185;
                case 2 -> 221191;
                case 3 -> 221192;
            }));
        }

        @Override
        public void setCursor(long cursor) {
            GLFW.glfwSetCursor((long)WindowHandleAccess.getWindowHandle(), (long)cursor);
        }

        @Override
        public void destroyStandardCursor(long ... cursors) {
        }

        @Override
        public boolean rawMouseMotionAvailable() {
            return WindowHandleAccess.isHandleAvailable();
        }

        @Override
        public void setRawMouseMotion(boolean enabled) {
            GLFW.glfwSetInputMode((long)WindowHandleAccess.getWindowHandle(), (int)208901, (int)(enabled ? 1 : 0));
        }
    }

    static final class SDLAccess
    extends WindowAccess {
        SDLAccess() {
        }

        @Override
        public long createCursor(Cursor cursor) {
            return SDLMouse.SDL_CreateSystemCursor((int)(switch (cursor.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> 9;
                case 1 -> 0;
                case 2 -> 5;
                case 3 -> 6;
            }));
        }

        @Override
        public void setCursor(long cursor) {
            SDLMouse.SDL_SetCursor((long)cursor);
        }

        @Override
        public void destroyStandardCursor(long ... cursors) {
            for (long c : cursors) {
                SDLMouse.SDL_DestroyCursor((long)c);
            }
        }

        @Override
        public boolean rawMouseMotionAvailable() {
            return false;
        }

        @Override
        public void setRawMouseMotion(boolean enabled) {
        }
    }

    static final class NoOpAccess
    extends WindowAccess {
        NoOpAccess() {
        }

        @Override
        public long createCursor(Cursor cursor) {
            return 0L;
        }

        @Override
        public void setCursor(long cursor) {
        }

        @Override
        public void destroyStandardCursor(long ... cursors) {
        }

        @Override
        public boolean rawMouseMotionAvailable() {
            return false;
        }

        @Override
        public void setRawMouseMotion(boolean enabled) {
        }
    }

    public static class WindowHandleAccess {
        private static MethodHandle getHandle;
        private static long windowHandle;

        public static long getWindowHandle() {
            if (windowHandle == -1L) {
                try {
                    windowHandle = getHandle.invoke();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return windowHandle;
        }

        public static boolean isHandleAvailable() {
            return WindowHandleAccess.getWindowHandle() != -1L;
        }

        static {
            try {
                getHandle = MethodHandles.lookup().findStatic(Class.forName("org.lwjgl.opengl.Display"), "getHandle", MethodType.methodType(Long.TYPE));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            windowHandle = -1L;
        }
    }

    public static enum Cursor {
        RESIZE_ALL,
        ARROW,
        RESIZE_NWSE,
        RESIZE_NESW;

    }
}

