/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.util.notifications;

import com.google.common.collect.ImmutableList;
import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.modules.hud.util.DrawUtil;
import io.github.axolotlclient.util.notifications.toasts.Toast;
import io.github.axolotlclient.util.notifications.toasts.ToastManager;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.unmapped.C_0561170;
import net.minecraft.unmapped.C_2899740;
import net.minecraft.unmapped.C_3754158;
import net.minecraft.unmapped.C_3831727;
import net.minecraft.unmapped.C_8105098;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class AxolotlClientToast
extends DrawUtil
implements Toast {
    private static final C_0561170 BACKGROUND_SPRITE = new C_0561170("axolotlclient", "textures/gui/sprites/toast/axolotlclient.png");
    private static final int DISPLAY_TIME_MILLIS = 5000;
    private static final int MAX_LINE_SIZE = 200;
    private static final int LINE_SPACING = 12;
    private static final int MARGIN = 10;
    private final String title;
    private final List<String> messageLines;
    private final int width;
    private Toast.Visibility wantedVisibility = Toast.Visibility.HIDE;

    public AxolotlClientToast(String title, @Nullable String message) {
        this(title, (List<String>)AxolotlClientToast.nullToEmpty(message), Math.max(160, 35 + Math.max(C_8105098.m_0408063().f_0426313.m_0040387(title), message == null ? 0 : C_8105098.m_0408063().f_0426313.m_0040387(message))));
    }

    public static AxolotlClientToast multiline(C_8105098 minecraft, String title, String message) {
        C_3831727 font = minecraft.f_0426313;
        List list = font.m_0466830(message, 200);
        int i = Math.min(200, Math.max(font.m_0040387(title), list.stream().mapToInt(arg_0 -> ((C_3831727)font).m_0040387(arg_0)).max().orElse(200)));
        return new AxolotlClientToast(title, list, i + 20 + 15);
    }

    private AxolotlClientToast(String title, List<String> messageLines, int width) {
        this.title = title;
        this.messageLines = messageLines;
        this.width = width;
    }

    private static ImmutableList<String> nullToEmpty(@Nullable String message) {
        return message == null ? ImmutableList.of() : ImmutableList.of((Object)message);
    }

    @Override
    public int width() {
        return this.width;
    }

    @Override
    public int height() {
        return 20 + Math.max(this.messageLines.size(), 1) * 12;
    }

    @Override
    public Toast.Visibility getWantedVisibility() {
        return this.wantedVisibility;
    }

    @Override
    public void update(ToastManager toastManager, long l) {
        double d = 5000.0 * toastManager.getNotificationDisplayTimeMultiplier();
        this.wantedVisibility = (double)l < d ? Toast.Visibility.SHOW : Toast.Visibility.HIDE;
    }

    @Override
    public void render(C_3831727 font, long startTime) {
        C_3754158.m_5313301();
        C_2899740.m_8989115();
        AxolotlClientToast.blitSprite(BACKGROUND_SPRITE, 0, 0, this.width(), this.height(), new DrawUtil.NineSlice(160, 64, new DrawUtil.Border(17, 30, 4, 4), false));
        C_8105098.m_0408063().m_1218956().m_5325521(AxolotlClient.badgeIcon);
        AxolotlClientToast.m_5935491((int)4, (int)4, (float)0.0f, (float)0.0f, (int)15, (int)15, (float)15.0f, (float)15.0f);
        int textOffset = 22;
        if (this.messageLines.isEmpty()) {
            AxolotlClientToast.drawString(this.title, (float)textOffset, 12.0f, -256, false);
        } else {
            AxolotlClientToast.drawString(this.title, (float)textOffset, 7.0f, -256, false);
            for (int i = 0; i < this.messageLines.size(); ++i) {
                AxolotlClientToast.drawString(this.messageLines.get(i), (float)textOffset, (float)(18 + i * 12), -1, false);
            }
        }
        C_2899740.m_3229588();
    }
}

