/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.util.notifications.toasts;

import com.google.common.collect.Queues;
import io.github.axolotlclient.util.Util;
import io.github.axolotlclient.util.notifications.toasts.Toast;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Deque;
import java.util.List;
import lombok.Generated;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.unmapped.C_3754158;
import net.minecraft.unmapped.C_4976084;
import net.minecraft.unmapped.C_8105098;
import net.ornithemc.osl.lifecycle.api.client.MinecraftClientEvents;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class ToastManager {
    private static final int SLOT_COUNT = 5;
    private static final int ALL_SLOTS_OCCUPIED = -1;
    final C_8105098 minecraft;
    private final List<ToastInstance<?>> visibleToasts = new ArrayList();
    private final BitSet occupiedSlots = new BitSet(5);
    private final Deque<Toast> queued = Queues.newArrayDeque();

    public ToastManager(C_8105098 minecraft) {
        this.minecraft = minecraft;
        MinecraftClientEvents.TICK_END.register(mc -> this.update());
    }

    public void update() {
        this.visibleToasts.removeIf(toastInstance -> {
            toastInstance.update();
            if (toastInstance.hasFinishedRendering()) {
                this.occupiedSlots.clear(toastInstance.firstSlotIndex, toastInstance.firstSlotIndex + toastInstance.occupiedSlotCount);
                return true;
            }
            return false;
        });
        if (!this.queued.isEmpty() && this.freeSlotCount() > 0) {
            this.queued.removeIf(toast -> {
                int i = toast.occupiedSlotCount();
                int j = this.findFreeSlotsIndex(i);
                if (j == -1) {
                    return false;
                }
                this.visibleToasts.add(new ToastInstance(this, toast, j, i));
                this.occupiedSlots.set(j, j + i);
                return true;
            });
        }
    }

    public void render() {
        if (!this.minecraft.f_9967940.f_8058174) {
            int i = (int)Util.getWindow().m_3624537();
            for (ToastInstance<?> toastInstance : this.visibleToasts) {
                toastInstance.render(i);
            }
        }
    }

    private int findFreeSlotsIndex(int i) {
        if (this.freeSlotCount() >= i) {
            int j = 0;
            for (int k = 0; k < 5; ++k) {
                if (this.occupiedSlots.get(k)) {
                    j = 0;
                    continue;
                }
                if (++j != i) continue;
                return k + 1 - j;
            }
        }
        return -1;
    }

    private int freeSlotCount() {
        return 5 - this.occupiedSlots.cardinality();
    }

    @Nullable
    public <T extends Toast> T getToast(Class<? extends T> class_, Object object) {
        for (ToastInstance<?> toastInstance : this.visibleToasts) {
            if (toastInstance == null || !class_.isAssignableFrom(toastInstance.getToast().getClass()) || !toastInstance.getToast().getToken().equals(object)) continue;
            return (T)toastInstance.getToast();
        }
        for (Toast toast : this.queued) {
            if (!class_.isAssignableFrom(toast.getClass()) || !toast.getToken().equals(object)) continue;
            return (T)toast;
        }
        return null;
    }

    public void clear() {
        this.occupiedSlots.clear();
        this.visibleToasts.clear();
        this.queued.clear();
    }

    public void addToast(Toast toast) {
        this.queued.add(toast);
    }

    public double getNotificationDisplayTimeMultiplier() {
        return 1.0;
    }

    @Generated
    public C_8105098 getMinecraft() {
        return this.minecraft;
    }

    @Environment(value=EnvType.CLIENT)
    class ToastInstance<T extends Toast> {
        private static final long SLIDE_ANIMATION_DURATION_MS = 600L;
        private final T toast;
        final int firstSlotIndex;
        final int occupiedSlotCount;
        private long animationStartTime = -1L;
        private long becameFullyVisibleAt = -1L;
        private Toast.Visibility visibility = Toast.Visibility.SHOW;
        private long fullyVisibleFor;
        private float visiblePortion;
        private boolean hasFinishedRendering;
        final /* synthetic */ ToastManager this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        ToastInstance(T toast, int i, int j) {
            this.this$0 = (ToastManager)this$0;
            this.toast = toast;
            this.firstSlotIndex = i;
            this.occupiedSlotCount = j;
        }

        public boolean hasFinishedRendering() {
            return this.hasFinishedRendering;
        }

        private void calculateVisiblePortion(long l) {
            float f = C_4976084.m_7164829((float)((float)(l - this.animationStartTime) / 600.0f), (float)0.0f, (float)1.0f);
            f *= f;
            this.visiblePortion = this.visibility == Toast.Visibility.HIDE ? 1.0f - f : f;
        }

        public void update() {
            long l = C_8105098.m_6224581();
            if (this.animationStartTime == -1L) {
                this.animationStartTime = l;
                this.visibility.playSound(this.this$0.minecraft.m_7555106());
            }
            if (this.visibility == Toast.Visibility.SHOW && l - this.animationStartTime <= 600L) {
                this.becameFullyVisibleAt = l;
            }
            this.fullyVisibleFor = l - this.becameFullyVisibleAt;
            this.calculateVisiblePortion(l);
            this.toast.update(this.this$0, this.fullyVisibleFor);
            Toast.Visibility visibility = this.toast.getWantedVisibility();
            if (visibility != this.visibility) {
                this.animationStartTime = l - (long)((int)((1.0f - this.visiblePortion) * 600.0f));
                this.visibility = visibility;
                this.visibility.playSound(this.this$0.minecraft.m_7555106());
            }
            this.hasFinishedRendering = this.visibility == Toast.Visibility.HIDE && l - this.animationStartTime > 600L;
        }

        public void render(int i) {
            C_3754158.m_8373640();
            C_3754158.m_3172490((float)((float)i - (float)this.toast.width() * this.visiblePortion), (float)(this.firstSlotIndex * 32), (float)1000.0f);
            this.toast.render(this.this$0.minecraft.f_0426313, this.fullyVisibleFor);
            C_3754158.m_2041265();
        }

        @Generated
        public T getToast() {
            return this.toast;
        }
    }
}

