/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.util.options.vanilla;

import io.github.axolotlclient.AxolotlClientConfig.api.util.Color;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.BooleanOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.OptionCategoryImpl;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.vanilla.widgets.BooleanWidget;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.vanilla.widgets.CategoryWidget;
import io.github.axolotlclient.modules.hud.util.DrawUtil;
import io.github.axolotlclient.util.ButtonWidgetTextures;
import io.github.axolotlclient.util.options.ForceableBooleanOption;
import net.minecraft.unmapped.C_0561170;
import net.minecraft.unmapped.C_3831727;
import net.minecraft.unmapped.C_8105098;

public class QuickToggleCategoryWidget
extends CategoryWidget {
    private BooleanWidget enabledButton;

    public QuickToggleCategoryWidget(int x, int y, int width, int height, OptionCategoryImpl category) {
        super(x, y, width, height, category);
        category.getOptions().stream().filter(o -> o instanceof BooleanOption).map(o -> (BooleanOption)o).filter(o -> "enabled".equals(o.getName())).findFirst().ifPresent(booleanOption -> {
            ForceableBooleanOption o;
            this.enabledButton = new BooleanWidget(x + (width - 33), y + 3, 30, height - 5, (BooleanOption)booleanOption){

                protected void drawWidget(int mouseX, int mouseY, float delta) {
                    C_0561170 tex = ButtonWidgetTextures.get(!this.active ? 0 : (this.isHovered() ? 2 : 1));
                    DrawUtil.blitSprite(tex, this.getX(), this.getY(), this.getWidth(), this.getHeight(), new DrawUtil.NineSlice(200, 20, 3));
                    DrawUtil.drawScrollableText(this.client.f_0426313, this.getMessage(), this.getX() + 2, this.getY(), this.getX() + this.getWidth() - 2, this.getY() + this.getHeight(), !this.active ? 0xA0A0A0 : (this.hovered ? 0xFFFFA0 : 0xE0E0E0));
                }
            };
            this.enabledButton.active = !(booleanOption instanceof ForceableBooleanOption && (o = (ForceableBooleanOption)booleanOption).isForceOff());
        });
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        if (this.enabledButton != null && this.enabledButton.isMouseOver(mouseX, mouseY)) {
            this.hovered = false;
            return true;
        }
        return super.isMouseOver(mouseX, mouseY);
    }

    public void drawWidget(int mouseX, int mouseY, float delta) {
        super.drawWidget(mouseX, mouseY, delta);
        if (this.enabledButton != null) {
            this.enabledButton.setY(this.getY() + 2);
            this.enabledButton.update();
            this.enabledButton.render(mouseX, mouseY, delta);
        }
    }

    protected void drawScrollingText(C_3831727 textRenderer, int i, Color j) {
        int k = this.getX() + i;
        int l = this.getX() + this.getWidth() - i;
        int center = this.getX() + this.getWidth() / 2;
        if (this.enabledButton != null) {
            l -= this.enabledButton.getWidth() + 4;
            center -= this.enabledButton.getWidth() / 2 + 2;
        }
        QuickToggleCategoryWidget.drawScrollingText((C_3831727)textRenderer, (String)this.getMessage(), (int)center, (int)k, (int)this.getY(), (int)l, (int)(this.getY() + this.getHeight()), (Color)j);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.enabledButton != null && this.enabledButton.isHovered()) {
            this.playDownSound(C_8105098.m_0408063().m_7555106());
            this.enabledButton.onPress();
            return true;
        }
        return this.hovered && super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (!this.active || !this.visible) {
            return false;
        }
        if (keyCode != 257 && keyCode != 32 && keyCode != 335) {
            return false;
        }
        this.playDownSound(C_8105098.m_0408063().m_7555106());
        this.mouseClicked(0.0, 0.0, 0);
        return true;
    }
}

