/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.api.worldhost;

import com.mojang.authlib.GameProfile;
import com.mojang.util.UndashedUuid;
import io.github.axolotlclient.api.API;
import io.github.axolotlclient.api.handlers.StatusUpdateHandler;
import io.github.axolotlclient.api.multiplayer.ServerInfoUtil;
import io.github.axolotlclient.api.requests.FriendRequest;
import io.github.axolotlclient.api.requests.UserRequest;
import io.github.axolotlclient.api.types.Status;
import io.github.axolotlclient.api.types.User;
import io.github.axolotlclient.api.util.UUIDHelper;
import io.github.gaming32.worldhost.FriendsListUpdate;
import io.github.gaming32.worldhost.WorldHost;
import io.github.gaming32.worldhost.gui.screen.PlayerInfoScreen;
import io.github.gaming32.worldhost.plugin.FriendAdder;
import io.github.gaming32.worldhost.plugin.FriendListFriend;
import io.github.gaming32.worldhost.plugin.Joinability;
import io.github.gaming32.worldhost.plugin.OnlineFriend;
import io.github.gaming32.worldhost.plugin.WorldHostPlugin;
import io.github.gaming32.worldhost.plugin.vanilla.GameProfileBasedProfilable;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_1132;
import net.minecraft.class_2561;
import net.minecraft.class_2926;
import net.minecraft.class_310;
import net.minecraft.class_412;
import net.minecraft.class_437;
import net.minecraft.class_639;
import net.minecraft.class_642;

public class AxolotlClientWorldHostPlugin
implements WorldHostPlugin {
    static AxolotlClientWorldHostPlugin Instance;
    private final FriendAdder friendAdder = new AxolotlClientFriendAdder();

    public AxolotlClientWorldHostPlugin() {
        Instance = this;
        API.addStartupListener(() -> WorldHost.reconnect((boolean)false, (boolean)true));
        StatusUpdateHandler.addUpdateListener((String)"world_host_plugin", user -> {
            if (user.getStatus().isOnline() && user.getStatus().getActivity() != null && user.getStatus().getActivity().hasMetadata()) {
                AxolotlClientOnlineFriend friend = AxolotlClientOnlineFriend.of(user);
                WorldHost.ONLINE_FRIENDS.put(friend.uuid(), friend);
                WorldHost.ONLINE_FRIEND_UPDATES.forEach(FriendsListUpdate::friendsListUpdate);
            }
        });
    }

    Status.Activity.WorldHostMetadata getWhStatusDescription() {
        class_1132 server = class_310.method_1551().method_1576();
        class_2926 status = server.method_3765();
        String connectionId = server.method_3860() ? WorldHost.connectionIdToString((long)WorldHost.CONNECTION_ID) : null;
        String externalIp = server.method_3860() && (Boolean)API.getInstance().getApiOptions().allowFriendsServerJoin.get() != false ? WorldHost.getExternalIp() : null;
        return new Status.Activity.WorldHostMetadata(connectionId, externalIp, ServerInfoUtil.getServerInfo(server.method_27728().method_150(), status));
    }

    public void listFriends(Consumer<FriendListFriend> friendConsumer) {
        FriendRequest.getInstance().getFriends().thenAccept(list -> list.stream().map(AxolotlClientFriendListFriend::new).forEach(friendConsumer));
    }

    public Optional<FriendAdder> friendAdder() {
        return Optional.of(this.friendAdder);
    }

    public void pingFriends(Collection<OnlineFriend> friends) {
        friends.stream().filter(AxolotlClientOnlineFriend.class::isInstance).forEach(friend -> {
            Status.Activity.MetadataAttributes metadataAttributes = ((AxolotlClientOnlineFriend)friend).metadata.attributes();
            Objects.requireNonNull(metadataAttributes);
            Status.Activity.MetadataAttributes selector0$temp = metadataAttributes;
            int index$1 = 0;
            Status.Activity.ServerInfo info = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Status.Activity.WorldHostMetadata.class, Status.Activity.E4mcMetadata.class, Status.Activity.ExternalServerMetadata.class}, (Object)selector0$temp, index$1)) {
                case 0 -> {
                    Status.Activity.WorldHostMetadata wh = (Status.Activity.WorldHostMetadata)selector0$temp;
                    yield wh.serverInfo();
                }
                case 1 -> {
                    Status.Activity.E4mcMetadata e4 = (Status.Activity.E4mcMetadata)selector0$temp;
                    yield e4.serverInfo();
                }
                case 2 -> {
                    Status.Activity.ExternalServerMetadata ex = (Status.Activity.ExternalServerMetadata)selector0$temp;
                    yield new Status.Activity.ServerInfo(ex.serverName(), ex.serverName(), null, null, null);
                }
                default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(((AxolotlClientOnlineFriend)friend).metadata.attributes()));
            };
            WorldHost.ONLINE_FRIEND_PINGS.put(friend.uuid(), ServerInfoUtil.getServerStatus(info));
        });
    }

    public void refreshOnlineFriends() {
        FriendRequest.getInstance().getFriends().thenAccept(list -> {
            list.stream().filter(u -> u.getStatus().getTitle().equals("api.status.title.world_host")).map(AxolotlClientFriendListFriend::new).forEach(friend -> WorldHost.ONLINE_FRIENDS.put(friend.profile.getId(), AxolotlClientOnlineFriend.of(friend.friend)));
            WorldHost.ONLINE_FRIEND_UPDATES.forEach(FriendsListUpdate::friendsListUpdate);
        });
    }

    private static class AxolotlClientFriendAdder
    implements FriendAdder {
        private AxolotlClientFriendAdder() {
        }

        public class_2561 label() {
            return class_2561.method_43470((String)"AxolotlClient");
        }

        public void searchFriends(String s, int i, Consumer<FriendListFriend> consumer) {
            if (s.isEmpty()) {
                return;
            }
            ((Optional)UUIDHelper.ensureUuidOpt((String)s).join()).ifPresent(uuid -> UserRequest.get((String)uuid).thenAccept(o -> o.map(AxolotlClientFriendListFriend::new).ifPresent(consumer)));
        }

        public boolean delayLookup(String s) {
            return true;
        }

        public int maxValidNameLength() {
            return 36;
        }
    }

    private record AxolotlClientOnlineFriend(User user, GameProfile profile, Status.Activity.Metadata metadata) implements OnlineFriend,
    GameProfileBasedProfilable
    {
        private static AxolotlClientOnlineFriend of(User user) {
            if (user.getStatus().isOnline() && user.getStatus().getActivity() != null && user.getStatus().getActivity().hasMetadata()) {
                Status.Activity.Metadata data = user.getStatus().getActivity().metadata();
                return new AxolotlClientOnlineFriend(user, new GameProfile(UndashedUuid.fromStringLenient((String)user.getUuid()), user.getName()), data);
            }
            throw new IllegalArgumentException();
        }

        public UUID uuid() {
            return this.profile.getId();
        }

        public void joinWorld(class_437 screen) {
            Status.Activity.MetadataAttributes metadataAttributes = this.metadata.attributes();
            Objects.requireNonNull(metadataAttributes);
            Status.Activity.MetadataAttributes metadataAttributes2 = metadataAttributes;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Status.Activity.WorldHostMetadata.class, Status.Activity.E4mcMetadata.class, Status.Activity.ExternalServerMetadata.class}, (Object)metadataAttributes2, n)) {
                case 0: {
                    Status.Activity.WorldHostMetadata wh = (Status.Activity.WorldHostMetadata)metadataAttributes2;
                    Long id = WorldHost.tryParseConnectionId((String)wh.connectionId());
                    if (id == null) break;
                    WorldHost.join((long)id, (class_437)screen);
                    break;
                }
                case 1: {
                    Status.Activity.E4mcMetadata e4 = (Status.Activity.E4mcMetadata)metadataAttributes2;
                    this.connectToServer(screen, e4.domain(), e4.serverInfo().levelName());
                    break;
                }
                case 2: {
                    Status.Activity.ExternalServerMetadata ex = (Status.Activity.ExternalServerMetadata)metadataAttributes2;
                    this.connectToServer(screen, ex.address(), ex.serverName());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + String.valueOf(this.metadata.attributes()));
                }
            }
        }

        private void connectToServer(class_437 parent, String address, String name) {
            if (address != null) {
                class_412.method_36877((class_437)parent, (class_310)class_310.method_1551(), (class_639)class_639.method_2950((String)address), (class_642)new class_642(name, address, class_642.class_8678.field_45611), (boolean)false, null);
            }
        }

        public GameProfile defaultProfile() {
            return this.profile;
        }

        public Joinability joinability() {
            Status.Activity.MetadataAttributes metadataAttributes = this.metadata.attributes();
            Objects.requireNonNull(metadataAttributes);
            Status.Activity.MetadataAttributes metadataAttributes2 = metadataAttributes;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Status.Activity.WorldHostMetadata.class, Status.Activity.E4mcMetadata.class, Status.Activity.ExternalServerMetadata.class}, (Object)metadataAttributes2, n)) {
                case 0: {
                    Status.Activity.WorldHostMetadata a = (Status.Activity.WorldHostMetadata)metadataAttributes2;
                    if (a.connectionId() == null) break;
                    return Joinability.Joinable.INSTANCE;
                }
                case 1: {
                    Status.Activity.E4mcMetadata e = (Status.Activity.E4mcMetadata)metadataAttributes2;
                    if (e.domain() == null) break;
                    return Joinability.Joinable.INSTANCE;
                }
                case 2: {
                    Status.Activity.ExternalServerMetadata ex = (Status.Activity.ExternalServerMetadata)metadataAttributes2;
                    if (ex.address() != null) {
                        return Joinability.Joinable.INSTANCE;
                    }
                    return new Joinability.Unjoinable((class_2561)class_2561.method_43471((String)"api.worldhost.joinability.not_joinable"));
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + String.valueOf(this.metadata.attributes()));
                }
            }
            return new Joinability.Unjoinable((class_2561)class_2561.method_43471((String)"api.worldhost.joinability.not_published"));
        }
    }

    private record AxolotlClientFriendListFriend(User friend, GameProfile profile) implements FriendListFriend,
    GameProfileBasedProfilable
    {
        private AxolotlClientFriendListFriend(User friend) {
            this(friend, new GameProfile(UndashedUuid.fromStringLenient((String)friend.getUuid()), friend.getName()));
        }

        public void removeFriend(Runnable runnable) {
            FriendRequest.getInstance().removeFriend(this.friend);
        }

        public void showFriendInfo(class_437 screen) {
            class_310.method_1551().method_1507((class_437)new PlayerInfoScreen(screen, this.profile));
        }

        public GameProfile defaultProfile() {
            return this.profile;
        }

        public void addFriend(boolean notify, Runnable refresher) {
            FriendRequest.getInstance().addFriend(this.friend.getUuid());
            refresher.run();
        }

        public Optional<class_2561> tag() {
            return Optional.of(class_2561.method_43470((String)"AxolotlClient"));
        }
    }
}

