/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.auth;

import com.mojang.authlib.minecraft.UserApiService;
import com.mojang.authlib.yggdrasil.ProfileResult;
import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.AxolotlClientConfig.api.options.Option;
import io.github.axolotlclient.AxolotlClientConfig.api.options.OptionCategory;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.BooleanOption;
import io.github.axolotlclient.api.API;
import io.github.axolotlclient.api.types.User;
import io.github.axolotlclient.api.util.UUIDHelper;
import io.github.axolotlclient.mixin.MinecraftClientAccessor;
import io.github.axolotlclient.modules.Module;
import io.github.axolotlclient.modules.auth.Account;
import io.github.axolotlclient.modules.auth.Accounts;
import io.github.axolotlclient.modules.auth.AccountsScreen;
import io.github.axolotlclient.modules.auth.DeviceCodeDisplayScreen;
import io.github.axolotlclient.modules.auth.DeviceFlowData;
import io.github.axolotlclient.modules.auth.MSApi;
import io.github.axolotlclient.modules.auth.skin.SkinManager;
import io.github.axolotlclient.util.ThreadExecuter;
import io.github.axolotlclient.util.notifications.Notifications;
import io.github.axolotlclient.util.options.GenericOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import net.minecraft.class_1068;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_320;
import net.minecraft.class_410;
import net.minecraft.class_437;
import net.minecraft.class_5520;
import net.minecraft.class_7569;
import net.minecraft.class_7574;
import net.minecraft.class_7853;

public class Auth
extends Accounts
implements Module {
    private static final Auth Instance = new Auth();
    public final BooleanOption showButton = new BooleanOption("auth.showButton", Boolean.valueOf(false));
    public final BooleanOption skinManagerAnimations = new BooleanOption("skins.manage.animations", Boolean.valueOf(true));
    private final class_310 client = class_310.method_1551();
    private final GenericOption viewAccounts = new GenericOption("viewAccounts", "clickToOpen", () -> this.client.method_1507((class_437)new AccountsScreen(this.client.field_1755)));
    private final Set<String> loadingTexture = new HashSet<String>();
    private final Map<String, class_2960> textures = new WeakHashMap<String, class_2960>();
    private final SkinManager skinManager = new SkinManager();

    public void init() {
        this.load();
        this.msApi = new MSApi((Accounts)this, () -> this.client.field_1690.field_1883);
        if (this.isContained(this.client.method_1548().method_1675())) {
            this.current = this.getAccounts().stream().filter(account -> account.getUuid().equals(UUIDHelper.toUndashed((UUID)this.client.method_1548().method_44717()))).toList().getFirst();
            this.current.setAuthToken(this.client.method_1548().method_1674());
            this.current.setName(this.client.method_1548().method_1676());
        } else {
            this.current = new Account(this.client.method_1548().method_1676(), UUIDHelper.toUndashed((UUID)this.client.method_1548().method_44717()), this.client.method_1548().method_1674());
        }
        this.category.add(new Option[]{this.showButton, this.viewAccounts});
        AxolotlClient.config().general.add(new OptionCategory[]{this.category});
    }

    protected void login(Account account) {
        if (this.client.field_1687 != null) {
            return;
        }
        if (account.needsRefresh() && !account.isOffline()) {
            if (account.isExpired()) {
                Notifications.getInstance().addStatus((class_2561)class_2561.method_43471((String)"auth.notif.title"), (class_2561)class_2561.method_43469((String)"auth.notif.refreshing", (Object[])new Object[]{account.getName()}));
            }
            ((CompletableFuture)account.refresh(this.msApi).thenAccept(a -> {
                if (!a.isExpired()) {
                    this.login((Account)a);
                }
            })).thenRun(() -> ((Auth)this).save());
        } else {
            try {
                API.getInstance().shutdown();
                ((MinecraftClientAccessor)this.client).axolotlclient$setSession(new class_320(account.getName(), UUIDHelper.fromUndashed((String)account.getUuid()), account.getAuthToken(), Optional.empty(), Optional.empty(), class_320.class_321.field_34962));
                UserApiService service = account.isOffline() ? UserApiService.OFFLINE : ((MinecraftClientAccessor)class_310.method_1551()).getAuthService().createUserApiService(this.client.method_1548().method_1674());
                ((MinecraftClientAccessor)this.client).axolotlclient$setUserApiService(service);
                ((MinecraftClientAccessor)this.client).axolotlclient$setSocialInteractionsManager(new class_5520(this.client, service));
                ((MinecraftClientAccessor)this.client).axolotlclient$setPlayerKeyPairManager(class_7853.method_46532((UserApiService)service, (class_320)this.client.method_1548(), (Path)this.client.field_1697.toPath()));
                ((MinecraftClientAccessor)this.client).axolotlclient$setChatReportingContext(class_7574.method_44599((class_7569)class_7569.method_44586(), (UserApiService)service));
                this.save();
                this.current = account;
                Notifications.getInstance().addStatus((class_2561)class_2561.method_43471((String)"auth.notif.title"), (class_2561)class_2561.method_43469((String)"auth.notif.login.successful", (Object[])new Object[]{this.current.getName()}));
                API.getInstance().startup(account);
            }
            catch (Exception e) {
                Notifications.getInstance().addStatus((class_2561)class_2561.method_43471((String)"auth.notif.title"), (class_2561)class_2561.method_43471((String)"auth.notif.login.failed"));
            }
        }
    }

    CompletableFuture<Account> showAccountsExpiredScreen(Account account) {
        class_437 current = this.client.field_1755;
        CompletableFuture<Account> fut = new CompletableFuture<Account>();
        this.client.execute(() -> this.client.method_1507((class_437)new class_410(bl -> {
            if (bl) {
                this.msApi.startDeviceAuth().thenRun(() -> fut.complete(account));
            } else {
                fut.cancel(true);
            }
            this.client.method_1507(current);
        }, (class_2561)class_2561.method_43471((String)"auth"), (class_2561)class_2561.method_43469((String)"auth.accountExpiredNotice", (Object[])new Object[]{account.getName()}))));
        return fut;
    }

    void displayDeviceCode(DeviceFlowData data) {
        this.client.execute(() -> this.client.method_1507((class_437)new DeviceCodeDisplayScreen(this.client.field_1755, data)));
    }

    private void loadTexture(String uuid) {
        if (!this.loadingTexture.contains(uuid)) {
            this.loadingTexture.add(uuid);
            ThreadExecuter.scheduleTask(() -> {
                UUID uUID = UUIDHelper.fromUndashed((String)uuid);
                ProfileResult profileResult = this.client.method_1495().fetchProfile(uUID, false);
                if (profileResult != null) {
                    this.client.method_1582().method_52863(profileResult.profile()).thenAccept(playerSkin -> this.textures.put(uuid, playerSkin.comp_1626()));
                }
                this.loadingTexture.remove(uuid);
            });
        }
    }

    public class_2960 getSkinTexture(Account account) {
        return this.getSkinTexture(account.getUuid());
    }

    public class_2960 getSkinTexture(User user) {
        return this.getSkinTexture(user.getUuid());
    }

    public class_2960 getSkinTexture(String uuid) {
        if (!this.textures.containsKey(uuid)) {
            this.loadTexture(uuid);
            return Objects.requireNonNullElseGet(this.textures.get(uuid), () -> class_1068.method_4648((UUID)UUIDHelper.fromUndashed((String)uuid)).comp_1626());
        }
        return this.textures.get(uuid);
    }

    @Generated
    public static Auth getInstance() {
        return Instance;
    }

    @Generated
    public SkinManager getSkinManager() {
        return this.skinManager;
    }
}

