/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.forgelin.coroutines;

import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineDispatcher;
import net.minecraft.profiler.Profiler;
import net.minecraft.server.MinecraftServer;
import net.shadowfacts.forgelin.coroutines.ThreadSafeDispatcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c1\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0012\u0010\n\u001a\u00020\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007J\b\u0010\r\u001a\u00020\tH\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lnet/shadowfacts/forgelin/coroutines/MinecraftServerDispatcher;", "Lkotlinx/coroutines/CoroutineDispatcher;", "<init>", "()V", "taskDispatcher", "Lnet/shadowfacts/forgelin/coroutines/ThreadSafeDispatcher;", "server", "Lnet/minecraft/server/MinecraftServer;", "setup", "", "runTasks", "profiler", "Lnet/minecraft/profiler/Profiler;", "clear", "isDispatchNeeded", "", "context", "Lkotlin/coroutines/CoroutineContext;", "dispatch", "block", "Ljava/lang/Runnable;", "forgelin-mc1.7.10"})
@PublishedApi
public final class MinecraftServerDispatcher
extends CoroutineDispatcher {
    @NotNull
    public static final MinecraftServerDispatcher INSTANCE = new MinecraftServerDispatcher();
    @NotNull
    private static final ThreadSafeDispatcher taskDispatcher = new ThreadSafeDispatcher();
    @Nullable
    private static MinecraftServer server;

    private MinecraftServerDispatcher() {
    }

    @JvmStatic
    public static final void setup(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        MinecraftServerDispatcher.server = server;
        Thread thread = Thread.currentThread();
        Intrinsics.checkNotNullExpressionValue((Object)thread, (String)"currentThread(...)");
        taskDispatcher.setThread(thread);
    }

    @JvmStatic
    public static final void runTasks(@Nullable Profiler profiler) {
        taskDispatcher.runTasks(profiler);
    }

    @JvmStatic
    public static final void clear() {
        taskDispatcher.clear();
        server = null;
    }

    public boolean isDispatchNeeded(@NotNull CoroutineContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return taskDispatcher.needsDispatch();
    }

    public void dispatch(@NotNull CoroutineContext context, @NotNull Runnable block) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        MinecraftServer minecraftServer = server;
        if (!(minecraftServer != null ? !minecraftServer.func_71241_aa() : false)) {
            throw new IllegalStateException("Server is not set or not running");
        }
        taskDispatcher.scheduleTask(block);
    }
}

