/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.forgelin.internal.asm;

import java.util.ListIterator;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ASMTransformer
implements IClassTransformer {
    private static final String SERVER_NAME = "net.minecraft.server.MinecraftServer";
    private static final String SERVER_INTERNAL = "net/minecraft/server/MinecraftServer";
    private static final String MC_NAME = "net.minecraft.client.Minecraft";
    private static final String MC_INTERNAL = "net/minecraft/client/Minecraft";
    private static final String PROFILER_INTERNAL = "net/minecraft/profiler/Profiler";
    private static final String PROFILER_DESC = "Lnet/minecraft/profiler/Profiler;";
    private static final String CLIENT_HANDLER_INTERNAL = "net/shadowfacts/forgelin/coroutines/MinecraftClientDispatcher";
    private static final String SERVER_HANDLER_INTERNAL = "net/shadowfacts/forgelin/coroutines/MinecraftServerDispatcher";
    private static final String HANDLER_METHOD_NAME = "runTasks";
    private static final String HANDLER_METHOD_DESC = "(Lnet/minecraft/profiler/Profiler;)V";
    private final boolean deobf = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (basicClass == null) {
            return null;
        }
        if (SERVER_NAME.equals(transformedName)) {
            ClassNode node = ASMTransformer.bytesToNode(basicClass);
            this.patchServerRun(node);
            this.patchServerUpdate(node);
            return ASMTransformer.nodeToBytes(node);
        }
        if (MC_NAME.equals(transformedName)) {
            ClassNode node = ASMTransformer.bytesToNode(basicClass);
            this.patchClientRunTick(node);
            return ASMTransformer.nodeToBytes(node);
        }
        return basicClass;
    }

    private void patchClientRunTick(ClassNode node) {
        MethodNode runTickMethod = ASMTransformer.findMethod(node, this.forEnv("runTick", "func_71407_l"), "()V");
        FieldNode profilerField = ASMTransformer.findField(node, this.forEnv("mcProfiler", "field_71424_I"));
        InsnList theCall = new InsnList();
        ASMTransformer.callHandler(theCall, profilerField, MC_INTERNAL, CLIENT_HANDLER_INTERNAL);
        runTickMethod.instructions.insert(theCall);
    }

    private void patchServerRun(ClassNode node) {
        MethodNode runMethod = ASMTransformer.findMethod(node, "run", "()V");
        ListIterator insns = runMethod.instructions.iterator();
        while (insns.hasNext()) {
            AbstractInsnNode insn = (AbstractInsnNode)insns.next();
            if (insn.getOpcode() != 177) continue;
            insns.previous();
            insns.add(new MethodInsnNode(184, SERVER_HANDLER_INTERNAL, "clear", "()V", false));
            insns.next();
        }
        InsnList theCall = new InsnList();
        theCall.add((AbstractInsnNode)new VarInsnNode(25, 0));
        theCall.add((AbstractInsnNode)new MethodInsnNode(184, SERVER_HANDLER_INTERNAL, "setup", "(Lnet/minecraft/server/MinecraftServer;)V", false));
        runMethod.instructions.insert(theCall);
    }

    private void patchServerUpdate(ClassNode node) {
        MethodNode updateMethod = ASMTransformer.findMethod(node, this.forEnv("updateTimeLightAndEntities", "func_71190_q"), "()V");
        FieldNode profilerField = ASMTransformer.findField(node, this.forEnv("theProfiler", "field_71304_b"));
        InsnList theCall = new InsnList();
        ASMTransformer.callHandler(theCall, profilerField, SERVER_INTERNAL, SERVER_HANDLER_INTERNAL);
        updateMethod.instructions.insert(theCall);
    }

    private String forEnv(String deobf, String obf) {
        return this.deobf ? deobf : obf;
    }

    private static void callHandler(@NotNull InsnList theCall, @Nullable FieldNode profilerField, String fieldClass, String handler) {
        if (profilerField != null && PROFILER_DESC.equals(profilerField.desc)) {
            theCall.add((AbstractInsnNode)new VarInsnNode(25, 0));
            theCall.add((AbstractInsnNode)new FieldInsnNode(180, fieldClass, profilerField.name, profilerField.desc));
        } else {
            theCall.add((AbstractInsnNode)new InsnNode(1));
        }
        theCall.add((AbstractInsnNode)new MethodInsnNode(184, handler, HANDLER_METHOD_NAME, HANDLER_METHOD_DESC, false));
    }

    @NotNull
    private static MethodNode findMethod(@NotNull ClassNode node, @NotNull String name, @NotNull String desc) {
        for (MethodNode method : node.methods) {
            if (!name.equals(method.name) || !desc.equals(method.desc)) continue;
            return method;
        }
        throw new IllegalArgumentException("Could not find method " + name + " " + desc + " in class " + node.name);
    }

    @Nullable
    private static FieldNode findField(@NotNull ClassNode node, @NotNull String name) {
        for (FieldNode field : node.fields) {
            if (!name.equals(field.name)) continue;
            return field;
        }
        return null;
    }

    @NotNull
    private static ClassNode bytesToNode(byte @NotNull [] basicClass) {
        ClassNode node = new ClassNode();
        new ClassReader(basicClass).accept((ClassVisitor)node, 0);
        return node;
    }

    private static byte @NotNull [] nodeToBytes(@NotNull ClassNode node) {
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }
}

