/*
 * Decompiled with CFR 0.152.
 */
package com.voxcrafterlp.cauldroninteract;

import com.google.common.collect.Lists;
import com.voxcrafterlp.cauldroninteract.listener.BlockDispenseListener;
import com.voxcrafterlp.cauldroninteract.listener.InventoryMoveItemListener;
import com.voxcrafterlp.cauldroninteract.utils.bstats.bukkit.Metrics;
import com.voxcrafterlp.cauldroninteract.utils.githubversionchecker.CheckResult;
import com.voxcrafterlp.cauldroninteract.utils.githubversionchecker.GithubVersionChecker;
import com.voxcrafterlp.cauldroninteract.utils.githubversionchecker.ReleaseVersion;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class CauldronInteract
extends JavaPlugin {
    private static CauldronInteract instance;
    private Metrics metrics;
    private static final String consolePrefix = "\u00a77[\u00a7bCauldronInteract\u00a77] ";
    private List<Inventory> blockedInventories;

    public void onEnable() {
        instance = this;
        this.blockedInventories = Lists.newCopyOnWriteArrayList();
        this.registerListener();
        this.loadMetrics();
        Bukkit.getConsoleSender().sendMessage("\u00a77[\u00a7bCauldronInteract\u00a77] \u00a7av" + this.getDescription().getVersion() + " by VoxCrafter_LP enabled!");
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, this::checkForUpdates);
    }

    private void registerListener() {
        PluginManager pluginManager = Bukkit.getPluginManager();
        pluginManager.registerEvents((Listener)new BlockDispenseListener(), (Plugin)this);
        pluginManager.registerEvents((Listener)new InventoryMoveItemListener(), (Plugin)this);
    }

    private void loadMetrics() {
        int pluginId = 12031;
        this.metrics = new Metrics(this, 12031);
    }

    private void checkForUpdates() {
        Bukkit.getConsoleSender().sendMessage("\u00a77[\u00a7bCauldronInteract\u00a77] \u00a7aChecking for updates...");
        try {
            ReleaseVersion currentVersion = new ReleaseVersion(this.getDescription().getVersion());
            GithubVersionChecker versionChecker = new GithubVersionChecker("VoxCrafterLP", "CauldronInteract", currentVersion, false);
            CheckResult checkResult = versionChecker.check();
            switch (checkResult.getVersionState()) {
                case OUTDATED: {
                    Bukkit.getConsoleSender().sendMessage("\u00a77[\u00a7bCauldronInteract\u00a77] \u00a77There is a \u00a7anewer \u00a77version available\u00a78: \u00a72" + checkResult.getVersion().toString());
                    break;
                }
                case NEWER: 
                case UP_TO_DATE: {
                    Bukkit.getConsoleSender().sendMessage("\u00a77[\u00a7bCauldronInteract\u00a77] \u00a7aYou are up to date.");
                }
            }
        }
        catch (Exception exception) {
            Bukkit.getConsoleSender().sendMessage("\u00a77[\u00a7bCauldronInteract\u00a77] \u00a7cAn error occurred while checking for updates...");
        }
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public List<Inventory> getBlockedInventories() {
        return this.blockedInventories;
    }

    public static CauldronInteract getInstance() {
        return instance;
    }
}

