/*
 * Decompiled with CFR 0.152.
 */
package com.voxcrafterlp.cauldroninteract.utils;

import com.voxcrafterlp.cauldroninteract.CauldronInteract;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Dispenser;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.Levelled;
import org.bukkit.event.Event;
import org.bukkit.event.block.CauldronLevelChangeEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.material.MaterialData;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionType;

public abstract class CauldronUtils {
    protected void modifyDispenserInventory(Block block, ItemStack remove, ItemStack add, boolean resetCauldron) {
        Dispenser dispenser = (Dispenser)block.getState();
        if (!CauldronInteract.getInstance().getBlockedInventories().contains(dispenser.getInventory())) {
            CauldronInteract.getInstance().getBlockedInventories().add(dispenser.getInventory());
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)CauldronInteract.getInstance(), () -> {
            int removeIndex;
            Inventory dispenserInventory = dispenser.getInventory();
            int n = removeIndex = remove.getAmount() > 1 ? dispenserInventory.first(remove) : dispenserInventory.first(remove.getType());
            if (removeIndex != -1) {
                ItemStack newItemStack = dispenserInventory.getItem(removeIndex);
                newItemStack.setAmount(newItemStack.getAmount() - 1);
                dispenserInventory.setItem(removeIndex, newItemStack);
            }
            if (dispenserInventory.firstEmpty() == -1) {
                dispenser.getWorld().dropItem(dispenser.getLocation().add(0.5, -0.75, 0.5), add);
            } else {
                dispenserInventory.addItem(new ItemStack[]{add});
            }
            CauldronInteract.getInstance().getBlockedInventories().remove(dispenserInventory);
        }, 1L);
        dispenser.update(true);
        block.getState().update(true);
        if (resetCauldron) {
            block.getRelative(this.getFacing(block)).setType(Material.CAULDRON);
        }
    }

    protected void updateCauldronWaterLevel(Block block, int newLevel, CauldronLevelChangeEvent.ChangeReason reason) throws IllegalArgumentException {
        if (newLevel < 1 || newLevel > 3) {
            throw new IllegalArgumentException("The acceptable range is between 1 and 3.");
        }
        Levelled cauldronData = (Levelled)block.getBlockData();
        cauldronData.setLevel(newLevel);
        block.setBlockData((BlockData)cauldronData);
        Bukkit.getPluginManager().callEvent((Event)new CauldronLevelChangeEvent(block, null, reason, block.getState()));
    }

    protected int getCauldronWaterLevel(Block block) {
        return ((Levelled)block.getBlockData()).getLevel();
    }

    protected BlockFace getFacing(Block block) {
        return block.getBlockData() instanceof Directional ? ((Directional)block.getBlockData()).getFacing() : BlockFace.SELF;
    }

    protected BlockFace getFacing(MaterialData materialData) {
        int data = materialData.getData() & 7;
        return switch (data) {
            case 0 -> BlockFace.DOWN;
            case 1 -> BlockFace.UP;
            case 2 -> BlockFace.NORTH;
            case 3 -> BlockFace.SOUTH;
            case 4 -> BlockFace.WEST;
            default -> BlockFace.EAST;
        };
    }

    protected ItemStack getWaterBottleItemStack() {
        ItemStack itemStack = new ItemStack(Material.POTION, 1);
        PotionMeta potionMeta = (PotionMeta)itemStack.getItemMeta();
        potionMeta.setBasePotionData(new PotionData(PotionType.WATER));
        itemStack.setItemMeta((ItemMeta)potionMeta);
        return itemStack;
    }

    protected boolean isFull(Levelled levelled) {
        return levelled.getLevel() == levelled.getMaximumLevel();
    }
}

