/*
 * Decompiled with CFR 0.152.
 */
package com.voxcrafterlp.cauldroninteract.utils.githubversionchecker;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.voxcrafterlp.cauldroninteract.utils.githubversionchecker.CheckResult;
import com.voxcrafterlp.cauldroninteract.utils.githubversionchecker.ReleaseVersion;
import com.voxcrafterlp.cauldroninteract.utils.githubversionchecker.VersionState;
import com.voxcrafterlp.cauldroninteract.utils.githubversionchecker.exceptions.NoReleaseFoundException;
import com.voxcrafterlp.cauldroninteract.utils.githubversionchecker.exceptions.RepoNotFoundException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;

public class GithubVersionChecker {
    private final String username;
    private final String repo;
    private final ReleaseVersion currentVersion;
    private final boolean includePreReleases;

    public GithubVersionChecker(String username, String repo, ReleaseVersion currentVersion, boolean includePreReleases) {
        this.username = username;
        this.repo = repo;
        this.currentVersion = currentVersion;
        this.includePreReleases = includePreReleases;
        try {
            URL url = new URL(String.format("https://api.github.com/repos/%s/%s", this.username, this.repo));
            HttpsURLConnection con = (HttpsURLConnection)url.openConnection();
            con.setRequestMethod("GET");
            if (con.getResponseCode() != 200) {
                throw new RepoNotFoundException(this.username, this.repo);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public GithubVersionChecker(String username, String repo, ReleaseVersion currentVersion) {
        this(username, repo, currentVersion, false);
    }

    public CheckResult check() {
        String queryURL = "https://api.github.com/repos/%s/%s/releases/latest";
        if (this.includePreReleases) {
            queryURL = "https://api.github.com/repos/%s/%s/releases?per_page=1";
        }
        try {
            JsonObject releaseData;
            URL url = new URL(String.format(queryURL, this.username, this.repo));
            HttpsURLConnection con = (HttpsURLConnection)url.openConnection();
            con.setRequestMethod("GET");
            if (con.getResponseCode() != 200) {
                throw new NoReleaseFoundException(this.username, this.repo);
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            if (this.includePreReleases) {
                JsonArray jsonArray = JsonParser.parseReader(in).getAsJsonArray();
                if (jsonArray.size() == 0) {
                    throw new NoReleaseFoundException(this.username, this.repo);
                }
                releaseData = jsonArray.get(0).getAsJsonObject();
            } else {
                releaseData = JsonParser.parseReader(in).getAsJsonObject();
            }
            in.close();
            con.disconnect();
            ReleaseVersion githubVersion = new ReleaseVersion(releaseData.get("tag_name").getAsString());
            String pageLink = releaseData.get("html_url").getAsString();
            switch (this.currentVersion.compareTo(githubVersion)) {
                case -1: {
                    return new CheckResult(githubVersion, pageLink, VersionState.OUTDATED);
                }
                case 0: {
                    return new CheckResult(githubVersion, pageLink, VersionState.UP_TO_DATE);
                }
                case 1: {
                    return new CheckResult(githubVersion, pageLink, VersionState.NEWER);
                }
            }
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

